/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.exception;

import com.ejianc.framework.core.util.ExceptionUtils;

public abstract class RootRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -8531149904295764227L;

    public RootRuntimeException() {
    }

    public RootRuntimeException(String message) {
        super(message);
    }

    public RootRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public RootRuntimeException(Throwable cause) {
        super(cause);
    }

    protected RootRuntimeException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public String getFullMessage() {
        return ExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public Throwable getRootCause() {
        Throwable rootCause = null;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class<?> exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof RootRuntimeException) {
            return ((RootRuntimeException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    static {
        ExceptionUtils.class.getName();
    }
}

