/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.io;

import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.reflect.ClassLoaderUtil;
import com.ejianc.framework.core.kit.text.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtil {
    public static URL asUrl(String resourceName) {
        return Resources.getResource((String)resourceName);
    }

    public static URL asUrl(Class<?> contextClass, String resourceName) {
        return Resources.getResource(contextClass, (String)resourceName);
    }

    public static InputStream asStream(String resourceName) throws IOException {
        return Resources.getResource((String)resourceName).openStream();
    }

    public static InputStream asStream(Class<?> contextClass, String resourceName) throws IOException {
        return Resources.getResource(contextClass, (String)resourceName).openStream();
    }

    public static String toString(String resourceName) throws IOException {
        return Resources.toString((URL)Resources.getResource((String)resourceName), (Charset)Charsets.UTF_8);
    }

    public static String toString(Class<?> contextClass, String resourceName) throws IOException {
        return Resources.toString((URL)Resources.getResource(contextClass, (String)resourceName), (Charset)Charsets.UTF_8);
    }

    public static List<String> toLines(String resourceName) throws IOException {
        return Resources.readLines((URL)Resources.getResource((String)resourceName), (Charset)Charsets.UTF_8);
    }

    public static List<String> toLines(Class<?> contextClass, String resourceName) throws IOException {
        return Resources.readLines((URL)Resources.getResource(contextClass, (String)resourceName), (Charset)Charsets.UTF_8);
    }

    public static List<URL> getResourcesQuietly(String resourceName) {
        return ResourceUtil.getResourcesQuietly(resourceName, ClassLoaderUtil.getDefaultClassLoader());
    }

    public static List<URL> getResourcesQuietly(String resourceName, ClassLoader contextClassLoader) {
        try {
            Enumeration<URL> urls = contextClassLoader.getResources(resourceName);
            ArrayList<URL> list = new ArrayList<URL>(10);
            while (urls.hasMoreElements()) {
                list.add(urls.nextElement());
            }
            return list;
        }
        catch (IOException e) {
            return ListUtil.emptyList();
        }
    }
}

