/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.tree;

import com.ejianc.framework.core.tree.TreeNode;
import com.ejianc.framework.core.tree.TreeNodeException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class MultiTreeNode<T>
extends TreeNode<T> {
    private static final long serialVersionUID = 1L;

    public MultiTreeNode(T data) {
        super(data);
    }

    public boolean addSubtrees(Collection<? extends MultiTreeNode<T>> subtrees) {
        if (MultiTreeNode.areAllNulls(subtrees)) {
            return false;
        }
        for (MultiTreeNode<T> subtree : subtrees) {
            MultiTreeNode.linkParent(subtree, this);
            if (this.add(subtree)) continue;
            return false;
        }
        return true;
    }

    public Collection<? extends MultiTreeNode<T>> siblings() {
        if (this.isRoot()) {
            String message = String.format("Unable to find the siblings. The tree node %1$s is root", this.root());
            throw new TreeNodeException(message);
        }
        Collection parentSubtrees = this.parent.subtrees();
        int parentSubtreesSize = parentSubtrees.size();
        if (parentSubtreesSize == 1) {
            return Collections.emptySet();
        }
        HashSet<MultiTreeNode> siblings = new HashSet<MultiTreeNode>(parentSubtreesSize - 1);
        for (TreeNode parentSubtree : parentSubtrees) {
            if (parentSubtree.equals(this)) continue;
            siblings.add((MultiTreeNode)parentSubtree);
        }
        return siblings;
    }

    public boolean hasSubtrees(Collection<? extends MultiTreeNode<T>> subtrees) {
        if (this.isLeaf() || MultiTreeNode.areAllNulls(subtrees)) {
            return false;
        }
        for (MultiTreeNode<T> subtree : subtrees) {
            if (this.hasSubtree(subtree)) continue;
            return false;
        }
        return true;
    }

    public boolean dropSubtrees(Collection<? extends MultiTreeNode<T>> subtrees) {
        if (this.isLeaf() || MultiTreeNode.areAllNulls(subtrees)) {
            return false;
        }
        boolean result = false;
        for (MultiTreeNode<T> subtree : subtrees) {
            boolean currentResult = this.dropSubtree(subtree);
            if (result || !currentResult) continue;
            result = true;
        }
        return result;
    }
}

