/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import jodd.util.StringUtil;

public class DistanceUtil {
    private static double DEF_PI = Math.PI;
    private static double DEF_2PI = Math.PI * 2;
    private static double DEF_PI180 = Math.PI / 180;
    private static double DEF_R = 6370996.81;

    public static Double getTwopointsDistance(String lng1Str, String lat1Str, String lng2Str, String lat2Str) {
        if (StringUtil.isBlank((CharSequence)lat1Str) || StringUtil.isBlank((CharSequence)lng1Str) || StringUtil.isBlank((CharSequence)lat2Str) || StringUtil.isBlank((CharSequence)lng2Str)) {
            return null;
        }
        Double lon1 = Double.parseDouble(lng1Str.trim());
        Double lat1 = Double.parseDouble(lat1Str.trim());
        Double lon2 = Double.parseDouble(lng2Str.trim());
        Double lat2 = Double.parseDouble(lat2Str.trim());
        double ew1 = lon1 * DEF_PI180;
        double ns1 = lat1 * DEF_PI180;
        double ew2 = lon2 * DEF_PI180;
        double ns2 = lat2 * DEF_PI180;
        double distance = Math.sin(ns1) * Math.sin(ns2) + Math.cos(ns1) * Math.cos(ns2) * Math.cos(ew1 - ew2);
        if (distance > 1.0) {
            distance = 1.0;
        } else if (distance < -1.0) {
            distance = -1.0;
        }
        distance = DEF_R * Math.acos(distance);
        BigDecimal bd = new BigDecimal(distance);
        distance = bd.setScale(2, 4).doubleValue();
        return distance;
    }

    public static Boolean isWithin(Double distance, String origin, String destination) {
        String startLng = origin.split(",")[0];
        String startLat = origin.split(",")[1];
        String endLng = destination.split(",")[0];
        String endLat = destination.split(",")[1];
        if (StringUtil.isBlank((CharSequence)startLat) || StringUtil.isBlank((CharSequence)startLng) || StringUtil.isBlank((CharSequence)endLat) || StringUtil.isBlank((CharSequence)endLng)) {
            return false;
        }
        Double calDistance = DistanceUtil.getTwopointsDistance(startLng, startLat, endLng, endLat);
        if (calDistance != null) {
            boolean result = distance >= (double)calDistance.intValue();
            return result;
        }
        return false;
    }

    public static JSONArray getDistance(List<String> origins, String destination) {
        JSONArray list = new JSONArray();
        String endLng = destination.split(",")[0];
        String endLat = destination.split(",")[1];
        for (String origin : origins) {
            String startLng = origin.split(",")[0];
            String startLat = origin.split(",")[1];
            Double calDistance = DistanceUtil.getTwopointsDistance(startLng, startLat, endLng, endLat);
            JSONObject json = new JSONObject();
            json.put("origin", (Object)origin);
            json.put("destination", (Object)destination);
            json.put("distance", (Object)calDistance);
            list.add((Object)json);
        }
        return list;
    }

    public static void main(String[] args) {
        boolean ss = DistanceUtil.isWithin(100.0, "144,136.1332", "144,136.1338");
        System.out.println(ss);
    }
}

