/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.ContextCoreUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class ExcelExport {
    private static ExcelExport excelExport = null;
    private static HttpMessageConverters httpMessageConverters = null;

    private ExcelExport() {
        System.out.println("============jxls\u5bfc\u51fa \u521d\u59cb\u5316===========");
    }

    public static synchronized ExcelExport getInstance() {
        if (excelExport == null) {
            httpMessageConverters = ContextCoreUtil.getBeanByType(HttpMessageConverters.class);
            excelExport = new ExcelExport();
        }
        return excelExport;
    }

    @Deprecated
    public void export(String exitsName, Map<String, Object> data, HttpServletResponse response) {
        this.export(exitsName, data, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void export(String exitsName, Map<String, Object> data, HttpServletResponse response, String excelExportTitle) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.put("dateFormat", dateFormat);
            data.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);
            if (StringUtils.isNotBlank((CharSequence)excelExportTitle)) {
                workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
            }
            workbook.write((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void exportWithTrans(String exitsName, Map<String, Object> data, HttpServletResponse response) {
        this.exportWithTrans(exitsName, data, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportWithTrans(String exitsName, Map<String, Object> data, HttpServletResponse response, String excelExportTitle) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;
        try {
            ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
            outputStream = response.getOutputStream();
            List records = (List)data.get("records");
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            List converters = httpMessageConverters.getConverters();
            ObjectMapper objectMapper = null;
            for (HttpMessageConverter converter : converters) {
                if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
                objectMapper = ((MappingJackson2HttpMessageConverter)converter).getObjectMapper();
                break;
            }
            if (ListUtil.isNotEmpty(records)) {
                for (Object record : records) {
                    String str = objectMapper.writeValueAsString(record);
                    JSONObject obj = JSONObject.parseObject((String)str);
                    if (StringUtils.isNotEmpty((CharSequence)obj.getString("billState")) && obj.getString("billState").length() == 1) {
                        obj.put("billState", (Object)BillStateEnum.getEnumByStateCode(obj.getInteger("billState")).getDescription());
                    }
                    result.add(obj);
                }
                data.put("records", result);
            }
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);
            if (StringUtils.isNotBlank((CharSequence)excelExportTitle)) {
                workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
            }
            workbook.write((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

