/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;

public class ImgUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressPic(String imgUrl, InputStream inputStream) {
        try {
            BufferedImage bim = null;
            if (StringUtils.isNotEmpty((CharSequence)imgUrl)) {
                bim = ImageIO.read(new URL(imgUrl));
            }
            if (inputStream != null) {
                bim = ImageIO.read(inputStream);
            }
            if (bim == null) {
                byte[] byArray = null;
                return byArray;
            }
            int srcWidth = bim.getWidth();
            int srcHeight = bim.getHeight();
            Thumbnails.Builder builder = inputStream != null ? Thumbnails.of((BufferedImage[])new BufferedImage[]{bim}).outputFormat("jpg") : Thumbnails.of((URL[])new URL[]{new URL(imgUrl)}).outputFormat("jpg");
            if (srcWidth > 4000 || srcHeight > 4000) {
                builder.size(4000, 4000);
            } else {
                builder.size(srcWidth, srcHeight);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            builder.toOutputStream((OutputStream)bos);
            byte[] bytes = ImgUtils.compressPicCycle(bos.toByteArray(), 3072L, 0.8);
            System.out.println("\u56fe\u7247\u538b\u7f29\u5b8c\u6210\uff01");
            bos.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressPicNew(String imgUrl, InputStream inputStream, Integer desMaxWidth, Integer desMaxHeight) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage image = null;
            if (StringUtils.isNotEmpty((CharSequence)imgUrl)) {
                image = ImageIO.read(new URL(imgUrl));
            } else if (inputStream != null) {
                image = ImageIO.read(inputStream);
            } else {
                System.out.println("\u538b\u7f29\u56fe\u7247\u5931\u8d25!\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
                throw new IOException("\u538b\u7f29\u56fe\u7247\u5931\u8d25!\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BufferedImage thumbnailImg = new BufferedImage(desMaxWidth, desMaxHeight, 1);
            thumbnailImg.getGraphics().drawImage(image, 0, 0, desMaxWidth, desMaxHeight, null);
            ImageIO.write((RenderedImage)thumbnailImg, "jpg", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u538b\u7f29\u56fe\u7247\u5931\u8d25\uff01");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressPic(String imgUrl, InputStream inputStream, Integer desMaxWidth, Integer desMaxHeight, Integer desFileSize) {
        if (desMaxWidth == null) {
            desMaxWidth = 4000;
        }
        if (desMaxHeight == null) {
            desMaxHeight = 4000;
        }
        if (desFileSize == null) {
            desFileSize = 3;
        }
        try {
            BufferedImage bim = null;
            if (StringUtils.isNotEmpty((CharSequence)imgUrl)) {
                bim = ImageIO.read(new URL(imgUrl));
            }
            if (inputStream != null) {
                bim = ImageIO.read(inputStream);
            }
            if (bim == null) {
                byte[] byArray = null;
                return byArray;
            }
            int srcWidth = bim.getWidth();
            int srcHeight = bim.getHeight();
            Thumbnails.Builder builder = inputStream != null ? Thumbnails.of((BufferedImage[])new BufferedImage[]{bim}).outputFormat("jpg") : Thumbnails.of((URL[])new URL[]{new URL(imgUrl)}).outputFormat("jpg");
            if (srcWidth > desMaxWidth || srcHeight > desMaxHeight) {
                builder.size(desMaxWidth.intValue(), desMaxHeight.intValue());
            } else {
                builder.size(srcWidth, srcHeight);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            builder.toOutputStream((OutputStream)bos);
            byte[] bytes = ImgUtils.compressPicCycle(bos.toByteArray(), (long)desFileSize.intValue() * 1024L, 0.8);
            System.out.println("\u56fe\u7247\u538b\u7f29\u5b8c\u6210\uff01");
            bos.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static byte[] compressPicCycle(byte[] bytes, long desFileSize, double accuracy) throws IOException {
        long srcFileSizeJPG = bytes.length;
        if (srcFileSizeJPG <= desFileSize * 1024L) {
            return bytes;
        }
        ByteArrayInputStream nextInputStream = new ByteArrayInputStream(bytes);
        BufferedImage bim = ImageIO.read(nextInputStream);
        int srcWidth = bim.getWidth();
        int srcHeight = bim.getHeight();
        int desWidth = new BigDecimal(srcWidth).multiply(new BigDecimal(accuracy)).intValue();
        int desHeight = new BigDecimal(srcHeight).multiply(new BigDecimal(accuracy)).intValue();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Thumbnails.of((InputStream[])new InputStream[]{is}).size(desWidth, desHeight).outputQuality(accuracy).toOutputStream((OutputStream)bos);
        byte[] res = ImgUtils.compressPicCycle(bos.toByteArray(), desFileSize, accuracy);
        try {
            ((InputStream)nextInputStream).close();
            bos.close();
            ((InputStream)is).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }
}

