/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties
@Import(value={UtilAutoConfiguration.class})
public class ConfigServiceBootstrapConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    public ConfigClientProperties configClientProperties() {
        ConfigClientProperties client = new ConfigClientProperties((Environment)this.environment);
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={ConfigServicePropertySourceLocator.class})
    @ConditionalOnProperty(value={"spring.cloud.config.enabled"}, matchIfMissing=true)
    public ConfigServicePropertySourceLocator configServicePropertySource(ConfigClientProperties properties) {
        ConfigServicePropertySourceLocator locator = new ConfigServicePropertySourceLocator(properties);
        return locator;
    }
}

