package com.ejianc.business.budget.vo.cons;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CostTypeEnum {
    LABOR_COST_TYPE(1, "人工费"),
    MATERIAL_COST_TYPE(2, "材料费"),
    // MAJOR_COST_TYPE(3, "专业分包费"),
    MECHANICAL_COST_TYPE(4, "其他费"),
    INDIRECTION_COST_TYPE(5, "间接费");

    private final Integer type;
    private final String name;
    private static Map<Integer, CostTypeEnum> enumMap = new HashMap();

    private CostTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }


    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static CostTypeEnum getEnumByType(Integer type) {
        return (CostTypeEnum) enumMap.get(type);
    }

    static {
        enumMap = (Map) EnumSet.allOf(CostTypeEnum.class).stream().collect(Collectors.toMap(CostTypeEnum::getType, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

    public static void main(String[] args) {
        CostTypeEnum enumByType = CostTypeEnum.getEnumByType(1);
        System.out.println(enumByType.name);
    }
}
