package com.ejianc.business.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 成本单据明细
 * 
 * @author generator
 * 
 */
public class CostDocumentsDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long documentsId; // 成本单据主键
    private String costName; // 费用名称
    private BigDecimal mny; // 金额
    private Long costType; // 费用类型
    private String costTypeName; // 费用类型名称
    private Long costAttribute; // 费用属性
    private String costAttributeName; // 费用属性名称
    private String costAttributeCode; // 费用属性编码
    private Long subjectId; // 成本科目
    private String subjectName; // 成本科目名称
    private String remark; // 备注
    

    public Long getDocumentsId() {
        return documentsId;
    }

    public void setDocumentsId(Long documentsId) {
        this.documentsId = documentsId;
    }
    public String getCostName() {
        return costName;
    }

    public void setCostName(String costName) {
        this.costName = costName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCostType() {
        return costType;
    }
    @ReferDeserialTransfer
    public void setCostType(Long costType) {
        this.costType = costType;
    }

    public Long getCostAttribute() {
        return costAttribute;
    }

    public void setCostAttribute(Long costAttribute) {
        this.costAttribute = costAttribute;
    }

    public String getCostAttributeName() {
        return costAttributeName;
    }

    public void setCostAttributeName(String costAttributeName) {
        this.costAttributeName = costAttributeName;
    }

    public String getCostAttributeCode() {
        return costAttributeCode;
    }

    public void setCostAttributeCode(String costAttributeCode) {
        this.costAttributeCode = costAttributeCode;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }
    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
