package com.ejianc.business.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 成本单据
 * 
 * @author generator
 * 
 */
public class CostDocumentsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private String billCode; // 单据编号
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date costDate; // 成本日期
    private BigDecimal costMny; // 成本金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门
    private String departmentName; // 经办人部门
    private String memo; // 备注
    private Integer billState; // 单据状态
    private String relationFlag; // 关联状态(1:是，0：否)
    private List<CostDocumentsDetailVO> costDocumentsDetailList = new ArrayList<>(); // 成本单据明细
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getCostDate() {
        return costDate;
    }

    public void setCostDate(Date costDate) {
        this.costDate = costDate;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<CostDocumentsDetailVO> getCostDocumentsDetailList() {
        return costDocumentsDetailList;
     }

     public void setCostDocumentsDetailList(List<CostDocumentsDetailVO> costDocumentsDetailList) {
        this.costDocumentsDetailList = costDocumentsDetailList;
     }
}
