package com.ejianc.business.budget.vo;

import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;


/**
 * 项目预算清单
 * 
 * @author generator
 * 
 */
public class BudgetProjectDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算主键
    private String detailIndex; // 序号
    private String code; // 清单编号
    private Long parentId; // parent_id
    private String name; // 项目名称
    private String projectDemo; // 项目特征描述
    private String unit; // 计量单位
    private java.math.BigDecimal num; // 工程量
    private java.math.BigDecimal price; // 综合单价
    private java.math.BigDecimal laborCost; // 人工费
    private java.math.BigDecimal materialCost; // 材料费
    private java.math.BigDecimal mechanicalCost; // 机械费
    private java.math.BigDecimal otherCost; // 其他费用
    private java.math.BigDecimal mny; // 合价
    private Integer leafFlag; // 是否末级
    private Integer changeType; // 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Long subjectId; // 成本科目主键
    private String subjectName; // 成本科目名称


    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;

    private List<ITreeNodeB> children;

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    /**
     * 预算主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * parent_id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parent_id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 项目名称
     */
    public String getName() {
        return name;
    }

    /**
     * 项目名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 项目特征描述
     */
    public String getProjectDemo() {
        return projectDemo;
    }

    /**
     * 项目特征描述
     */
    public void setProjectDemo(String projectDemo) {
        this.projectDemo = projectDemo;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 综合单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 综合单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 人工费
     */
    public java.math.BigDecimal getLaborCost() {
        return laborCost;
    }

    /**
     * 人工费
     */
    public void setLaborCost(java.math.BigDecimal laborCost) {
        this.laborCost = laborCost;
    }
    /**
     * 材料费
     */
    public java.math.BigDecimal getMaterialCost() {
        return materialCost;
    }

    /**
     * 材料费
     */
    public void setMaterialCost(java.math.BigDecimal materialCost) {
        this.materialCost = materialCost;
    }
    /**
     * 机械费
     */
    public java.math.BigDecimal getMechanicalCost() {
        return mechanicalCost;
    }

    /**
     * 机械费
     */
    public void setMechanicalCost(java.math.BigDecimal mechanicalCost) {
        this.mechanicalCost = mechanicalCost;
    }
    /**
     * 其他费用
     */
    public java.math.BigDecimal getOtherCost() {
        return otherCost;
    }

    /**
     * 其他费用
     */
    public void setOtherCost(java.math.BigDecimal otherCost) {
        this.otherCost = otherCost;
    }
    /**
     * 合价
     */
    public java.math.BigDecimal getMny() {
        return mny;
    }

    /**
     * 合价
     */
    public void setMny(java.math.BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 是否末级
     */
    public Integer getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Integer leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 成本科目主键
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目主键
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
}
