package com.ejianc.business.cost.api;

import com.ejianc.business.cost.hystrix.CostDetailHystrix;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 成本设置
 * 
 * @author sunyj
 *
 */
@FeignClient(name= "ejc-cost-web", url="${common.env.feign-client-url}", path="ejc-cost-web", fallback = CostDetailHystrix.class)
public interface ICostSettingApi {

    /**
     *  查看项目是否成本设置
     *
     * @param projectId
     *
     * @return
     */
    @GetMapping(value = "/api/setting/checkSettingFlag")
    public CommonResponse<Boolean> checkSettingFlag(@RequestParam(value = "projectId", required = true) Long projectId);


}
