package com.ejianc.business.budget.vo;

import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 项目预算清单明细
 *
 * @author generator
 */
public class BudgetProjectDetailProVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 预算主键
    private String detailIndex; // 序号
    private String code; // 清单编号
    private Long parentId; // parent_id
    private String name; // 清单名称
    private Long categoryId; // 分类id
    private String categoryName; // 分类名称
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private Integer costType; // 费用类型
    private String costTypeName; // 费用类型名称
    private String spec; // 特征/规格型号
    private String unit; // 计量单位
    private BigDecimal num; // 工程量
    private BigDecimal taxPrice; // 综合单价（含税）
    private BigDecimal price; // 综合单价（无税）
    private BigDecimal rate; // 税率
    private BigDecimal laborTaxMnyCost; // 人工费（含税）
    private BigDecimal laborMnyCost; // 人工费(无税)
    private BigDecimal majorTaxMnyCost; // 专业费（含税）
    private BigDecimal majorMnyCost; // 专业费（无税）
    private BigDecimal materialTaxMnyCost; // 材料费（含税）
    private BigDecimal materialMnyCost; // 材料费（无税）
    private BigDecimal mechanicalTaxMnyCost; // 机械费(含税)
    private BigDecimal mechanicalMnyCost; // 机械费（无税）
    private BigDecimal indirectionTaxMnyCost; // 间接费用(含税)
    private BigDecimal indirectionMnyCost; // 间接费用（无税）
    private BigDecimal taxMny; // 合价(含税)
    private BigDecimal mny; // 合价(无税)
    private Boolean leafFlag; // 是否末级
    private BigDecimal lockNum; // 占用数量
    private BigDecimal lockMny; // 占用金额(无税)
    private BigDecimal lockTaxMny; // 占用金额(含税)
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Long subjectId; // 成本科目id
    private String subjectName; // 成本科目

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    private List<ITreeNodeB> children;

    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;
    private String shadowId;
    private String key;
    private String entryType;//0 手动 1 档案
    /**
     * 模糊匹配生成档案使用
     */
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，

    private Long commonId; // 通用的id（包含清单id和档案id），仅清单量价累计用

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }


    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }


    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }


    public Integer getCostType() {
        return costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getLaborTaxMnyCost() {
        return laborTaxMnyCost;
    }

    public void setLaborTaxMnyCost(BigDecimal laborTaxMnyCost) {
        this.laborTaxMnyCost = laborTaxMnyCost;
    }

    public BigDecimal getLaborMnyCost() {
        return laborMnyCost;
    }

    public void setLaborMnyCost(BigDecimal laborMnyCost) {
        this.laborMnyCost = laborMnyCost;
    }

    public BigDecimal getMajorTaxMnyCost() {
        return majorTaxMnyCost;
    }

    public void setMajorTaxMnyCost(BigDecimal majorTaxMnyCost) {
        this.majorTaxMnyCost = majorTaxMnyCost;
    }

    public BigDecimal getMajorMnyCost() {
        return majorMnyCost;
    }

    public void setMajorMnyCost(BigDecimal majorMnyCost) {
        this.majorMnyCost = majorMnyCost;
    }

    public BigDecimal getMaterialTaxMnyCost() {
        return materialTaxMnyCost;
    }

    public void setMaterialTaxMnyCost(BigDecimal materialTaxMnyCost) {
        this.materialTaxMnyCost = materialTaxMnyCost;
    }

    public BigDecimal getMaterialMnyCost() {
        return materialMnyCost;
    }

    public void setMaterialMnyCost(BigDecimal materialMnyCost) {
        this.materialMnyCost = materialMnyCost;
    }

    public BigDecimal getMechanicalTaxMnyCost() {
        return mechanicalTaxMnyCost;
    }

    public void setMechanicalTaxMnyCost(BigDecimal mechanicalTaxMnyCost) {
        this.mechanicalTaxMnyCost = mechanicalTaxMnyCost;
    }

    public BigDecimal getMechanicalMnyCost() {
        return mechanicalMnyCost;
    }

    public void setMechanicalMnyCost(BigDecimal mechanicalMnyCost) {
        this.mechanicalMnyCost = mechanicalMnyCost;
    }

    public BigDecimal getIndirectionTaxMnyCost() {
        return indirectionTaxMnyCost;
    }

    public void setIndirectionTaxMnyCost(BigDecimal indirectionTaxMnyCost) {
        this.indirectionTaxMnyCost = indirectionTaxMnyCost;
    }

    public BigDecimal getIndirectionMnyCost() {
        return indirectionMnyCost;
    }

    public void setIndirectionMnyCost(BigDecimal indirectionMnyCost) {
        this.indirectionMnyCost = indirectionMnyCost;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public BigDecimal getLockNum() {
        return lockNum;
    }

    public void setLockNum(BigDecimal lockNum) {
        this.lockNum = lockNum;
    }

    public BigDecimal getLockMny() {
        return lockMny;
    }

    public void setLockMny(BigDecimal lockMny) {
        this.lockMny = lockMny;
    }

    public BigDecimal getLockTaxMny() {
        return lockTaxMny;
    }

    public void setLockTaxMny(BigDecimal lockTaxMny) {
        this.lockTaxMny = lockTaxMny;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getEntryType() {
        return entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getCommonId() {
        return commonId;
    }

    public void setCommonId(Long commonId) {
        this.commonId = commonId;
    }
}
