package com.ejianc.business.cost.vo;

import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 科目明细数据展示
 * 
 * @author sunyj
 * 
 */
public class SubjectReportVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private String subjectName; // 科目名称
    private java.lang.String subjectCode; // 科目编码
    private String happenDate; // 发生日期
    private Long parentId; // parent_id
    private java.math.BigDecimal happenMny; // 发生成本
    private java.lang.String detailIndex; // 序号  1   1.1

    private java.math.BigDecimal happenMnySum; // 截止上期发生成本


    private List<ITreeNodeB> children; //子集数据

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public BigDecimal getHappenMnySum() {
        return happenMnySum;
    }

    public void setHappenMnySum(BigDecimal happenMnySum) {
        this.happenMnySum = happenMnySum;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getHappenDate() {
        return happenDate;
    }

    public void setHappenDate(String happenDate) {
        this.happenDate = happenDate;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public BigDecimal getHappenMny() {
        return happenMny;
    }

    public void setHappenMny(BigDecimal happenMny) {
        this.happenMny = happenMny;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
    
}
