package com.ejianc.business.budget.hystrix;

import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

/**
 * 项目预算API接口：熔断降级
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Component
public class BudgetProjectProHystrix implements IBudgetProjectProApi {
	/**
	 * 获取预算量价
	 *
	 * @param paramControlVO 项目预算Pro参数控制VO
	 *
	 * @return {@link CommonResponse}<{@link BudgetProjectProQuantityAndMnyVO}>
	 */
	@Override
	public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
		return CommonResponse.error("网络问题， 查询失败。");
	}
}
