package com.ejianc.business.budget.api;

import com.ejianc.business.budget.hystrix.BudgetProjectProHystrix;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 项目预算API接口
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@FeignClient(name = "ejc-cost-web", url = "${common.env.feign-client-url}", path = "ejc-cost-web", fallback = BudgetProjectProHystrix.class)
public interface IBudgetProjectProApi {

	/**
	 * 获取预算量价
	 *
	 * @param paramControlVO 项目预算Pro参数控制VO
	 *
	 * @return {@link CommonResponse}<{@link BudgetProjectProQuantityAndMnyVO}>
	 */
	@PostMapping(value = "/api/budgetProjectPro/fetchQuantityAndMny")
	CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchQuantityAndMny(@Validated @RequestBody BudgetProjectProParamControlVO paramControlVO);

}
