package com.ejianc.business.cost.api;

import com.ejianc.business.cost.hystrix.CostDetailHystrix;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.cost.vo.ProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 费用项明细中间表交互
 * 
 * @author sunyj
 *
 */
@FeignClient(name= "ejc-cost-web", url="${common.env.feign-client-url}", path="ejc-cost-web", fallback = CostDetailHystrix.class)
public interface ICostDetailApi {

    /**
     *  插入费用项明细
     *
     * @param list
     *
     * @return
     */
    @PostMapping(value = "/api/cost/saveCostDetail")
    public CommonResponse<String> saveSubject(@RequestBody List<CostDetailVO> list);

    @GetMapping(value = "/api/cost/deleteCostDetail")
    public CommonResponse<String> deleteSubject(@RequestParam(value = "id", required = true) Long id);

    @GetMapping(value = "/api/cost/checkShareFlag")
    public CommonResponse<String> checkShareFlag(@RequestParam(value = "id", required = true) Long id);

    @GetMapping(value = "/api/cost/getCostMonth")
    public CommonResponse<List<ProjectReportVo>> getCostMonth(@RequestParam(value = "projectId") Long projectId);

}
