package com.ejianc.business.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目完工总结
 * 
 * @author generator
 * 
 */
public class CostProjectFinishVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private String billCode; // 单据编号
    private BigDecimal bidMny; // 中标金额
    private BigDecimal settleMny; // 结算金额
    private BigDecimal alreadyReceiveMny; // 已回款金额
    private BigDecimal willReceiveMny; // 预计回款金额
    private BigDecimal willProfitMny; // 预计利润金额
    private BigDecimal realProfitMny; // 实际利润金额
    private BigDecimal deviation; // 偏差
    private String responsibleName; // 负责人
    private String delayDay; // 延期天数
    private String inspectDay; // 巡视天数
    private String expatriateName; // 外派人员
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate; // 填报日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门
    private String departmentName; // 经办人部门
    private String memo; // 总结及建议(项目部)
    private String remark; // 总结及建议(成控部)
    private Integer billState; // 单据状态
    
    private List<CostProjectFinishDebtVO> costProjectFinishDebtList = new ArrayList<>(); // 项目完工总结-项目外债
    private List<CostProjectFinishSupplierVO> costProjectFinishSupplierList = new ArrayList<>(); // 项目完工总结-推荐入库供应商
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getAlreadyReceiveMny() {
        return alreadyReceiveMny;
    }

    public void setAlreadyReceiveMny(BigDecimal alreadyReceiveMny) {
        this.alreadyReceiveMny = alreadyReceiveMny;
    }
    public BigDecimal getWillReceiveMny() {
        return willReceiveMny;
    }

    public void setWillReceiveMny(BigDecimal willReceiveMny) {
        this.willReceiveMny = willReceiveMny;
    }
    public BigDecimal getWillProfitMny() {
        return willProfitMny;
    }

    public void setWillProfitMny(BigDecimal willProfitMny) {
        this.willProfitMny = willProfitMny;
    }
    public BigDecimal getRealProfitMny() {
        return realProfitMny;
    }

    public void setRealProfitMny(BigDecimal realProfitMny) {
        this.realProfitMny = realProfitMny;
    }
    public BigDecimal getDeviation() {
        return deviation;
    }

    public void setDeviation(BigDecimal deviation) {
        this.deviation = deviation;
    }
    public String getResponsibleName() {
        return responsibleName;
    }

    public void setResponsibleName(String responsibleName) {
        this.responsibleName = responsibleName;
    }
    public String getDelayDay() {
        return delayDay;
    }

    public void setDelayDay(String delayDay) {
        this.delayDay = delayDay;
    }
    public String getInspectDay() {
        return inspectDay;
    }

    public void setInspectDay(String inspectDay) {
        this.inspectDay = inspectDay;
    }
    public String getExpatriateName() {
        return expatriateName;
    }

    public void setExpatriateName(String expatriateName) {
        this.expatriateName = expatriateName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<CostProjectFinishDebtVO> getCostProjectFinishDebtList() {
        return costProjectFinishDebtList;
     }

     public void setCostProjectFinishDebtList(List<CostProjectFinishDebtVO> costProjectFinishDebtList) {
        this.costProjectFinishDebtList = costProjectFinishDebtList;
     }
     public List<CostProjectFinishSupplierVO> getCostProjectFinishSupplierList() {
        return costProjectFinishSupplierList;
     }

     public void setCostProjectFinishSupplierList(List<CostProjectFinishSupplierVO> costProjectFinishSupplierList) {
        this.costProjectFinishSupplierList = costProjectFinishSupplierList;
     }
}
