package com.ejianc.business.budget.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 定额库明细表
 * 
 * @author generator
 * 
 */
public class QuotaDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long quotaId; // 主表ID
    private String quotaDetailCode; // 编码
    private String quotaDetailProjectname; // 项目名称
    private String unit; // 单位名称
    private Long materialId; // 主材品类Id
    private String materialName; // 主材品类名称
    private String materialCode; // 主材品类code
    private String spec; // 规格型号
    private BigDecimal lossRate; // 主材损耗率
    private BigDecimal materialPrice; // 主材单价
    private BigDecimal laborPrice; // 劳务单价
    private BigDecimal allPrice; // 综合单价
    private String memo; // 特征描述
    private String errorMsg; // 导入错误信息

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Long getQuotaId() {
        return quotaId;
    }

    public void setQuotaId(Long quotaId) {
        this.quotaId = quotaId;
    }
    public String getQuotaDetailCode() {
        return quotaDetailCode;
    }

    public void setQuotaDetailCode(String quotaDetailCode) {
        this.quotaDetailCode = quotaDetailCode;
    }
    public String getQuotaDetailProjectname() {
        return quotaDetailProjectname;
    }

    public void setQuotaDetailProjectname(String quotaDetailProjectname) {
        this.quotaDetailProjectname = quotaDetailProjectname;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    @ReferSerialTransfer(referCode="Material001")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getLossRate() {
        return lossRate;
    }

    public void setLossRate(BigDecimal lossRate) {
        this.lossRate = lossRate;
    }
    public BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    public void setMaterialPrice(BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }
    public BigDecimal getLaborPrice() {
        return laborPrice;
    }

    public void setLaborPrice(BigDecimal laborPrice) {
        this.laborPrice = laborPrice;
    }
    public BigDecimal getAllPrice() {
        return allPrice;
    }

    public void setAllPrice(BigDecimal allPrice) {
        this.allPrice = allPrice;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
