/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.utils;

import com.ejianc.business.utils.DifferenceComparison;
import com.ejianc.business.utils.FieldDifferenceComparison;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareDifferenceUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareDifferenceUtil.class);
    private static final String ADD = "add";
    private static final String UPDATE = "update";
    private static final Map<String, Set<Field>> fieldCache = new HashMap<String, Set<Field>>();

    public static List<FieldDifference> compareObj(Object oldObj, Object newObj) {
        ArrayList<FieldDifference> result = new ArrayList<FieldDifference>();
        if (oldObj == null) {
            throw new RuntimeException("CompareDifferenceUtil.compareObj oldObj is null");
        }
        if (null == newObj) {
            throw new RuntimeException("CompareDifferenceUtil.compareObj newObj is null");
        }
        if (oldObj == newObj) {
            return result;
        }
        Class<?> newObjClass = newObj.getClass();
        DifferenceComparison differenceComparison = newObjClass.getAnnotation(DifferenceComparison.class);
        Set<Field> fields = CompareDifferenceUtil.getField(newObjClass);
        if (CollectionUtils.isNotEmpty(fields)) {
            String fieldName = null;
            for (Field field : fields) {
                if (!field.isAnnotationPresent(FieldDifferenceComparison.class)) continue;
                FieldDifferenceComparison fieldDifferenceComparison = field.getAnnotation(FieldDifferenceComparison.class);
                fieldName = field.getName();
                Class<?> type = field.getType();
                String FieldType = type.getSimpleName();
                Object oldValue = CompareDifferenceUtil.getFieldValueByName(fieldName, oldObj);
                Object newValue = CompareDifferenceUtil.getFieldValueByName(fieldName, newObj);
                if (null == oldValue) {
                    if (null == newValue) continue;
                    result.add(FieldDifference.getInstance(fieldName, fieldDifferenceComparison.name(), FieldType, null, newValue));
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)differenceComparison.beforeKeyPrefix())) {
                    String beforeValKey = differenceComparison.beforeKeyPrefix().concat(StringUtils.capitalize((String)fieldName));
                    CompareDifferenceUtil.setFieldValueByName(beforeValKey, oldValue, newObj);
                }
                if (null != newValue) {
                    if (newValue instanceof BigDecimal) {
                        BigDecimal oldValue1;
                        BigDecimal newValue1 = ComputeUtil.toBigDecimal((Object)newValue);
                        if (ComputeUtil.equals((BigDecimal)newValue1, (BigDecimal)(oldValue1 = ComputeUtil.toBigDecimal((Object)oldValue)))) continue;
                        result.add(FieldDifference.getInstance(fieldName, fieldDifferenceComparison.name(), FieldType, oldValue, newValue));
                        continue;
                    }
                    if (oldValue.equals(newValue)) continue;
                    result.add(FieldDifference.getInstance(fieldName, fieldDifferenceComparison.name(), FieldType, oldValue, newValue));
                    continue;
                }
                result.add(FieldDifference.getInstance(fieldName, fieldDifferenceComparison.name(), FieldType, oldValue, null));
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            if (StringUtils.isNotEmpty((CharSequence)differenceComparison.changeFlag())) {
                CompareDifferenceUtil.setFieldValueByName(differenceComparison.changeFlag(), UPDATE, newObj);
            }
            if (StringUtils.isNotEmpty((CharSequence)differenceComparison.differnceList())) {
                CompareDifferenceUtil.setFieldValueByName(differenceComparison.differnceList(), result, newObj);
            }
        }
        return result;
    }

    public static void compareList(List oldList, List newList) {
        block9: {
            if (!CollectionUtils.isNotEmpty((Collection)newList)) break block9;
            DifferenceComparison differenceComparisonNew = newList.get(0).getClass().getAnnotation(DifferenceComparison.class);
            if (StringUtils.isEmpty((CharSequence)differenceComparisonNew.changeFlag())) {
                throw new BusinessException("CompareDifferenceUtil.compareList error: newList changeFlag is null");
            }
            String changeFlagName = differenceComparisonNew.changeFlag();
            if (StringUtils.isEmpty((CharSequence)differenceComparisonNew.compareKey())) {
                throw new BusinessException("CompareDifferenceUtil.compareList error: newList compareKey is null");
            }
            String compareKeyNew = differenceComparisonNew.compareKey();
            if (CollectionUtils.isNotEmpty((Collection)oldList)) {
                DifferenceComparison differenceComparisonOld = oldList.get(0).getClass().getAnnotation(DifferenceComparison.class);
                if (StringUtils.isEmpty((CharSequence)differenceComparisonOld.compareKey())) {
                    throw new BusinessException("CompareDifferenceUtil.compareList error: oldList compareKey is null");
                }
                String compareKeyOld = differenceComparisonOld.compareKey();
                HashMap oldMap = new HashMap();
                for (Object t : oldList) {
                    Object fieldValue = CompareDifferenceUtil.getFieldValueByName(compareKeyOld, t);
                    oldMap.put(fieldValue, t);
                }
                for (Object newItem : newList) {
                    Object _fieldValue = CompareDifferenceUtil.getFieldValueByName(compareKeyNew, newItem);
                    Object oldItem = oldMap.get(_fieldValue);
                    if (oldItem == null) {
                        CompareDifferenceUtil.setFieldValueByName(changeFlagName, ADD, newItem);
                        continue;
                    }
                    CompareDifferenceUtil.compareObj(oldItem, newItem);
                }
            } else {
                for (Object newItem : newList) {
                    CompareDifferenceUtil.setFieldValueByName(changeFlagName, ADD, newItem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Field> getField(Class<?> type) {
        String className = type.getName();
        if (CollectionUtils.isEmpty((Collection)fieldCache.get(className))) {
            String string = className;
            synchronized (string) {
                if (CollectionUtils.isEmpty((Collection)fieldCache.get(className))) {
                    Field[] declaredFields;
                    HashSet<Field> fields = new HashSet<Field>();
                    for (Field declaredField : declaredFields = type.getDeclaredFields()) {
                        if (!declaredField.isAnnotationPresent(FieldDifferenceComparison.class)) continue;
                        fields.add(declaredField);
                    }
                    fieldCache.put(className, fields);
                }
            }
        }
        return fieldCache.get(className);
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            PropertyDescriptor namePd = new PropertyDescriptor(fieldName, o.getClass());
            Method method = namePd.getReadMethod();
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static boolean setFieldValueByName(String fieldName, Object val, Object o) {
        try {
            PropertyDescriptor namePd = new PropertyDescriptor(fieldName, o.getClass());
            Method method = namePd.getWriteMethod();
            method.invoke(o, val);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static class FieldDifference
    implements Serializable {
        private String column;
        private String columnName;
        private String columnType;
        private Object oldValue;
        private Object newValue;

        public static FieldDifference getInstance(String column, String columnName, String columnType, Object oldValue, Object newValue) {
            return new FieldDifference(column, columnName, columnType, oldValue, newValue);
        }

        public FieldDifference(String column, String columnName, String columnType, Object oldValue, Object newValue) {
            this.column = column;
            this.columnName = columnName;
            this.columnType = columnType;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }
    }
}

