package com.ejianc.business.budget.hystrix;

import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 项目预算API接口：熔断降级
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Component
public class BudgetProjectProHystrix implements IBudgetProjectProApi {
	/**
	 * 获取预算量价
	 *
	 * @param paramControlVO 项目预算Pro参数控制VO
	 *
	 * @return {@link CommonResponse}<{@link BudgetProjectProQuantityAndMnyVO}>
	 */
	@Override
	public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
	 * @param projectId
	 * @return
	 */
	@Override
	public CommonResponse<Map<Long, BigDecimal>> getBudgetProjectProQuantityByProjectId(Long projectId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 获取预算金额
	 *
	 * @return {@link CommonResponse}<{@link BudgetProjectProQuantityAndMnyVO}>
	 * @param orgIds
	 */
	@Override
	public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchBudgetMny(List<Long> orgIds) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<Map<String, BigDecimal>> getProOutMny(Long projectId, Long id, String billTypeCode) {
		return CommonResponse.error("网络问题， 查询失败。");
	}
}
