/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExcelImportUtil {
    public static List<Map<String, Object>> treeData(List<Map> list) {
        ArrayList<Map<String, Object>> resp = new ArrayList<Map<String, Object>>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, Map> listMap = new HashMap<String, Map>();
        for (Map item : list) {
            listMap.put(item.get("tid").toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map item;
            item = list.get(i);
            String parentId = item.get("tpid") != null ? item.get("tpid").toString() : "";
            Map parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<Map> children = new ArrayList<Map>();
                children.add(item);
                parent.put("children", children);
                continue;
            }
            rootItems.add(item.get("tid").toString());
        }
        for (String rootId : rootItems) {
            resp.add((Map<String, Object>)listMap.get(rootId));
        }
        return resp;
    }

    public static List<Map<String, Object>> importFlag(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            int i;
            List<Map<String, Object>> mapList;
            List child = (List)map.get("children");
            if (child != null) {
                map.put("leafFlag", false);
            } else {
                map.put("leafFlag", true);
                if (map.get("unit") == null || map.get("unit").equals("")) {
                    map.put("importFlag", false);
                    String warnType = (String)map.get("warnType");
                    if (StringUtils.isNotEmpty((CharSequence)warnType)) {
                        map.put("warnType", warnType + ",\u5355\u4f4d\u4e3a\u7a7a");
                    } else {
                        map.put("warnType", "\u5355\u4f4d\u4e3a\u7a7a");
                    }
                }
            }
            if (!((Boolean)map.get("importFlag")).booleanValue()) {
                if (child == null) continue;
                if (((Boolean)map.get("parentWarn")).booleanValue()) {
                    map.put("children", ExcelImportUtil.importFlagToFalse(child));
                    continue;
                }
                map.put("importFlag", true);
                mapList = ExcelImportUtil.importFlag(child);
                i = 0;
                for (Map<String, Object> childMap : mapList) {
                    if (!((Boolean)childMap.get("importFlag")).booleanValue()) continue;
                    ++i;
                }
                if (i == 0) {
                    map.put("importFlag", false);
                }
                map.put("children", ExcelImportUtil.importFlag(child));
                continue;
            }
            if (child == null) continue;
            mapList = ExcelImportUtil.importFlag(child);
            i = 0;
            for (Map<String, Object> childMap : mapList) {
                if (!((Boolean)childMap.get("importFlag")).booleanValue()) continue;
                ++i;
            }
            if (i == 0) {
                map.put("importFlag", false);
            }
            map.put("children", mapList);
        }
        return list;
    }

    public static List<Map<String, Object>> importFlag2(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            int i;
            List<Map<String, Object>> mapList;
            List child = (List)map.get("children");
            if (child != null) {
                String entryType;
                map.put("leafFlag", false);
                if (map.get("costType") == null || !map.get("costType").toString().equals("0")) {
                    map.put("warnType", "\u7236\u7ea7\u7684\u8d39\u7528\u7c7b\u578b\u53ea\u80fd\u9009\u62e9/");
                    map.put("parentWarn", true);
                    map.put("importFlag", false);
                }
                map.put("costType", null);
                map.put("categoryName", null);
                String string = entryType = map.get("entryType") != null ? map.get("entryType").toString() : null;
                if ("1".equals(entryType)) {
                    map.put("warnType", "\u6863\u6848\u4e0d\u80fd\u65b0\u589e\u4e0b\u7ea7...");
                    map.put("parentWarn", true);
                    map.put("importFlag", false);
                }
            } else {
                String warnType;
                map.put("leafFlag", true);
                if (StringUtils.isEmpty(map.get("costType") != null ? map.get("costType").toString() : null)) {
                    map.put("importFlag", false);
                    warnType = (String)map.get("warnType");
                    if (StringUtils.isNotEmpty((CharSequence)warnType)) {
                        map.put("warnType", warnType + ",\u672b\u7ea7\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    } else {
                        map.put("warnType", "\u672b\u7ea7\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                } else if (map.get("costType").toString().equals("0")) {
                    warnType = (String)map.get("warnType");
                    if (StringUtils.isNotEmpty((CharSequence)warnType)) {
                        map.put("warnType", warnType + ",\u672b\u7ea7\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u9009\u62e9/");
                    } else {
                        map.put("warnType", "\u672b\u7ea7\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u9009\u62e9/");
                    }
                    map.put("importFlag", false);
                }
                if (map.get("entryType") == null) {
                    map.put("importFlag", false);
                    warnType = (String)map.get("warnType");
                    if (StringUtils.isNotEmpty((CharSequence)warnType)) {
                        map.put("warnType", warnType + ",\u6e05\u5355\u7c7b\u578b\u4e3a\u7a7a");
                    } else {
                        map.put("warnType", "\u6e05\u5355\u7c7b\u578b\u4e3a\u7a7a");
                    }
                }
            }
            if (!((Boolean)map.get("importFlag")).booleanValue()) {
                if (child == null) continue;
                if (((Boolean)map.get("parentWarn")).booleanValue()) {
                    map.put("children", ExcelImportUtil.importFlagToFalse(child));
                    continue;
                }
                map.put("importFlag", true);
                mapList = ExcelImportUtil.importFlag2(child);
                i = 0;
                for (Map<String, Object> childMap : mapList) {
                    if (!((Boolean)childMap.get("importFlag")).booleanValue()) continue;
                    ++i;
                }
                if (i == 0) {
                    map.put("importFlag", false);
                }
                map.put("children", ExcelImportUtil.importFlag2(child));
                continue;
            }
            if (child == null) continue;
            mapList = ExcelImportUtil.importFlag2(child);
            i = 0;
            for (Map<String, Object> childMap : mapList) {
                if (!((Boolean)childMap.get("importFlag")).booleanValue()) continue;
                ++i;
            }
            if (i == 0) {
                map.put("importFlag", false);
            }
            map.put("children", mapList);
        }
        return list;
    }

    public static List<Map<String, Object>> importCheckCategoryName(List<Map<String, Object>> list, Map<String, Boolean> materialCategoryMap, Map<String, Boolean> equipmentCategoryProMap) {
        for (Map<String, Object> map : list) {
            List<Map<String, Object>> mapList;
            List child = (List)map.get("children");
            if (child != null) {
                map.put("leafFlag", false);
            } else {
                map.put("leafFlag", true);
                if (map.get("categoryName") != null && map.get("costType") != null) {
                    String entryType;
                    Boolean aBoolean = true;
                    Integer costType = map.get("costType") != null ? (Integer)map.get("costType") : null;
                    String categoryName = (String)map.get("categoryName");
                    String string = entryType = map.get("entryType") != null ? (String)map.get("entryType") : null;
                    if (costType != null && costType == 2 && entryType != null && entryType.equals("1")) {
                        aBoolean = materialCategoryMap.get(categoryName);
                    } else if (costType != null && costType == 4 && entryType != null && entryType.equals("1")) {
                        aBoolean = equipmentCategoryProMap.get(categoryName);
                    }
                    if (!aBoolean.booleanValue()) {
                        map.put("importFlag", false);
                        String warnType = (String)map.get("warnType");
                        if (StringUtils.isNotEmpty((CharSequence)warnType)) {
                            map.put("warnType", warnType + "\u6750\u6599\u5206\u7c7b\u5fc5\u987b\u5b58\u5728,");
                        } else {
                            map.put("warnType", "\u6750\u6599\u5206\u7c7b\u5fc5\u987b\u5b58\u5728");
                        }
                    }
                }
            }
            if (!((Boolean)map.get("importFlag")).booleanValue()) {
                if (child == null) continue;
                if (((Boolean)map.get("parentWarn")).booleanValue()) {
                    map.put("children", ExcelImportUtil.importFlagToFalse(child));
                    continue;
                }
                map.put("importFlag", true);
                mapList = ExcelImportUtil.importCheckCategoryName(child, materialCategoryMap, equipmentCategoryProMap);
                int i = 0;
                for (Map<String, Object> childMap : mapList) {
                    if (!((Boolean)childMap.get("importFlag")).booleanValue()) continue;
                    ++i;
                }
                if (i == 0) {
                    map.put("importFlag", false);
                }
                map.put("children", ExcelImportUtil.importCheckCategoryName(child, materialCategoryMap, equipmentCategoryProMap));
                continue;
            }
            if (child == null) continue;
            mapList = ExcelImportUtil.importCheckCategoryName(child, materialCategoryMap, equipmentCategoryProMap);
            int i = 0;
            for (Map<String, Object> childMap : mapList) {
                if (!((Boolean)childMap.get("importFlag")).booleanValue()) continue;
                ++i;
            }
            if (i == 0) {
                map.put("importFlag", false);
            }
            map.put("children", mapList);
        }
        return list;
    }

    public static List<Map<String, Object>> importFlagToFalse(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            map.put("importFlag", false);
            List child = (List)map.get("children");
            if (child != null) {
                map.put("leafFlag", false);
            } else {
                map.put("leafFlag", true);
            }
            if (child == null) continue;
            map.put("children", ExcelImportUtil.importFlagToFalse(child));
        }
        return list;
    }

    public static List<List<Map<String, Object>>> separate(List<Map<String, Object>> list, List<Map<String, Object>> falseList) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> stringObjectMap = list.get(i);
            if (!((Boolean)stringObjectMap.get("importFlag")).booleanValue()) {
                falseList.add(stringObjectMap);
                list.remove(i);
                --i;
                continue;
            }
            List child = (List)stringObjectMap.get("children");
            if (child == null) continue;
            stringObjectMap.put("children", ExcelImportUtil.separate(child, falseList).get(0));
        }
        ArrayList<List<Map<String, Object>>> lists = new ArrayList<List<Map<String, Object>>>();
        lists.add(list);
        lists.add(falseList);
        return lists;
    }

    public static List<Map<String, Object>> treeToList(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> reList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> stringObjectMap : list) {
            List child = (List)stringObjectMap.get("children");
            String warnType = (String)stringObjectMap.get("warnType");
            if (null == warnType || warnType.length() < 1) {
                stringObjectMap.put("warnType", "\u4e0a\u7ea7\u6216\u4e0b\u7ea7\u5b58\u5728\u9519\u8bef\uff01");
            }
            stringObjectMap.put("id", stringObjectMap.get("tid"));
            if (null != child) {
                List<Map<String, Object>> childrenList = ExcelImportUtil.treeToList(child);
                stringObjectMap.put("children", null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
                continue;
            }
            reList.add(stringObjectMap);
        }
        return reList;
    }

    public static void getCompareCodeMapByTree(List<Map<String, Object>> list, Map<String, String> reList, LinkedList<String> codes, Map<String, Integer> detailCodeCount) {
        for (Map<String, Object> stringObjectMap : list) {
            String changeCompareCode;
            if (codes == null) {
                codes = new LinkedList();
            }
            codes.add(stringObjectMap.get("code").toString());
            if (stringObjectMap.get("materialId") != null) {
                codes.add(stringObjectMap.get("materialId").toString());
            }
            if (detailCodeCount.containsKey(changeCompareCode = String.join((CharSequence)"#", codes))) {
                int i = detailCodeCount.get(changeCompareCode) + 1;
                changeCompareCode = changeCompareCode + "@" + i;
                detailCodeCount.put(changeCompareCode, i);
            } else {
                detailCodeCount.put(changeCompareCode, 1);
            }
            reList.put(stringObjectMap.get("id").toString(), changeCompareCode);
            List child = (List)stringObjectMap.get("children");
            if (null != child) {
                ExcelImportUtil.getCompareCodeMapByTree(child, reList, codes, detailCodeCount);
            }
            codes.remove(stringObjectMap.get("code").toString());
            if (stringObjectMap.get("materialId") == null) continue;
            codes.remove(stringObjectMap.get("materialId").toString());
        }
    }

    public static void getCompareCodeVOMapAndFlatData(List<Map<String, Object>> list, Map<String, Map<String, Object>> reList, LinkedList<String> codes, List<String> detailCodeMapList, Map<String, Integer> importCodeCount) {
        for (Map<String, Object> stringObjectMap : list) {
            int i;
            if (codes == null) {
                codes = new LinkedList();
            }
            String code = stringObjectMap.get("code").toString();
            codes.add(code);
            if (stringObjectMap.get("materialId") != null) {
                codes.add(stringObjectMap.get("materialId").toString());
            }
            String changeCompareCode = String.join((CharSequence)"#", codes);
            if (stringObjectMap.get("materialCode") != null && !detailCodeMapList.contains(changeCompareCode)) {
                for (i = 0; i < codes.size(); ++i) {
                    if (!codes.get(i).equals(code)) continue;
                    codes.set(i, stringObjectMap.get("materialCode").toString());
                }
                changeCompareCode = String.join((CharSequence)"#", codes);
            }
            if (importCodeCount.containsKey(changeCompareCode)) {
                i = importCodeCount.get(changeCompareCode) + 1;
                changeCompareCode = changeCompareCode + "@" + i;
                importCodeCount.put(changeCompareCode, i);
            } else {
                importCodeCount.put(changeCompareCode, 1);
            }
            stringObjectMap.put("changeCompareCode", changeCompareCode);
            if (reList.containsKey(changeCompareCode)) {
                reList.put(changeCompareCode + "@code", stringObjectMap);
            } else {
                reList.put(changeCompareCode, stringObjectMap);
            }
            List child = (List)stringObjectMap.get("children");
            if (null != child) {
                ExcelImportUtil.getCompareCodeVOMapAndFlatData(child, reList, codes, detailCodeMapList, importCodeCount);
                stringObjectMap.remove("children");
            }
            codes.remove(stringObjectMap.get("code").toString());
            if (stringObjectMap.get("materialId") != null) {
                codes.remove(stringObjectMap.get("materialId").toString());
            }
            if (stringObjectMap.get("materialCode") == null) continue;
            codes.remove(stringObjectMap.get("materialCode").toString());
        }
    }
}

