package com.ejianc.business.budget.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class ExcelImportUtil {
    //构造树形
    public static List<Map<String, Object>> treeData(List<Map> list) {
        List<Map<String, Object>> resp = new ArrayList();
        List<String> rootItems = new ArrayList();
        Map<String, Map<String, Object>> listMap = new HashMap();
        Iterator var4 = list.iterator();

        Map item;
        while(var4.hasNext()) {
            item = (Map)var4.next();
            listMap.put(item.get("tid").toString(), item);
        }

        for(int i = 0; i < list.size(); ++i) {
            item = (Map)list.get(i);
            String parentId = item.get("tpid") != null ? item.get("tpid").toString() : "";
            Map<String, Object> parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List<Map<String, Object>> child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                } else {
                    List<Map<String, Object>> children = new ArrayList();
                    children.add(item);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(item.get("tid").toString());
            }
        }

        var4 = rootItems.iterator();

        while(var4.hasNext()) {
            String rootId = (String)var4.next();
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    // 处理导入状态
    public static List<Map<String, Object>> importFlag(List<Map<String, Object>> list){
        for(Map<String, Object> map:list){
            List<Map<String, Object>> child =(List)map.get("children");
            if(child != null){//有子级
                map.put("leafFlag",false);
            }else{
                map.put("leafFlag",true);
                // 末级单位不能为空
                if(map.get("unit")==null||map.get("unit").equals("")){
                    map.put("importFlag",false);
                    String warnType=(String)map.get("warnType");
                    if(StringUtils.isNotEmpty(warnType)){
                        map.put("warnType",warnType+",单位为空");
                    }else{
                        map.put("warnType","单位为空");
                    }
                }
            }
            if((Boolean)map.get("importFlag") == false){// 错误行
                if(child != null){//如果有下级
                    if((Boolean)map.get("parentWarn")){//父级错误，则所有下级都错误
                        map.put("children",importFlagToFalse(child));
                    }else{// 父级没有错误,则本级不算错误
                        map.put("importFlag",true);
                        //继续递归
                        List<Map<String, Object>> mapList = importFlag(child);
                        int i=0;
                        for(Map<String, Object> childMap:mapList){
                            if((Boolean)childMap.get("importFlag")){
                                i++; // 有一个true，上级就不算错误
                            }
                        }
                        // 如果下级都是错误行，则本级也是错误的
                        if(i == 0){
                            map.put("importFlag",false);
                        }
                        map.put("children",importFlag(child));
                    }
                }
            }else{//如果不是错误行，继续递归
                if(child != null) {//如果有下级
                    //继续递归
                    List<Map<String, Object>> mapList = importFlag(child);
                    int i=0;
                    for(Map<String, Object> childMap:mapList){
                        if((Boolean)childMap.get("importFlag")){
                            i++; // 有一个true，上级就不算错误
                        }
                    }
                    // 如果下级都是错误行，则级也是错误的
                    if(i == 0){
                        map.put("importFlag",false);
                    }
                    //map.put("children",importFlag(child));
                    map.put("children",mapList);
                }
            }
        }
        return list;
    }

    // 处理导入状态
    public static List<Map<String, Object>> importFlag2(List<Map<String, Object>> list){
        for(Map<String, Object> map:list){
            List<Map<String, Object>> child =(List)map.get("children");
            if(child != null){//有子级
                map.put("leafFlag",false);
                //如果有子集需要情况父级的费用类型
                if (map.get("costType") == null || !map.get("costType").toString().equals("0")) {
                    map.put("warnType", "父级的费用类型只能选择/");
                    map.put("parentWarn", true);
                    map.put("importFlag", false);
                }
                map.put("costType",null);
                map.put("categoryName",null);
                String entryType = map.get("entryType")!=null ? map.get("entryType").toString() : null;
                if ("1".equals(entryType)){
                    map.put("warnType","档案不能新增下级...");
                    map.put("parentWarn",true);
                    map.put("importFlag",false);
                }
            }else{
                map.put("leafFlag",true);
                // 末级费用类型不能为空
                if(StringUtils.isEmpty((map.get("costType")!=null ? map.get("costType").toString() : null))){
                    map.put("importFlag",false);
                    String warnType=(String)map.get("warnType");
                    if(StringUtils.isNotEmpty(warnType)){
                        map.put("warnType",warnType+",末级费用类型不能为空");
                    }else{
                        map.put("warnType","末级费用类型不能为空");
                    }
                }else {
                    if (map.get("costType").toString().equals("0")){
                        String warnType=(String)map.get("warnType");
                        if(StringUtils.isNotEmpty(warnType)){
                            map.put("warnType",warnType+",末级费用类型不能选择/");
                        }else{
                            map.put("warnType","末级费用类型不能选择/");
                        }
                        map.put("importFlag",false);
                    }
                }
                if (map.get("entryType")==null){
                    map.put("importFlag",false);
                    String warnType=(String)map.get("warnType");
                    if(StringUtils.isNotEmpty(warnType)){
                        map.put("warnType",warnType+",清单类型为空");
                    }else{
                        map.put("warnType","清单类型为空");
                    }
                }
            }
            if((Boolean)map.get("importFlag") == false){// 错误行
                if(child != null){//如果有下级
                    if((Boolean)map.get("parentWarn")){//父级错误，则所有下级都错误
                        map.put("children",importFlagToFalse(child));
                    }else{// 父级没有错误,则本级不算错误
                        map.put("importFlag",true);
                        //继续递归
                        List<Map<String, Object>> mapList = importFlag2(child);
                        int i=0;
                        for(Map<String, Object> childMap:mapList){
                            if((Boolean)childMap.get("importFlag")){
                                i++; // 有一个true，上级就不算错误
                            }
                        }
                        // 如果下级都是错误行，则本级也是错误的
                        if(i == 0){
                            map.put("importFlag",false);
                        }
                        map.put("children",importFlag2(child));
                    }
                }
            }else{//如果不是错误行，继续递归
                if(child != null) {//如果有下级
                    //继续递归
                    List<Map<String, Object>> mapList = importFlag2(child);
                    int i=0;
                    for(Map<String, Object> childMap:mapList){
                        if((Boolean)childMap.get("importFlag")){
                            i++; // 有一个true，上级就不算错误
                        }
                    }
                    // 如果下级都是错误行，则级也是错误的
                    if(i == 0){
                        map.put("importFlag",false);
                    }
                    //map.put("children",importFlag(child));
                    map.put("children",mapList);
                }
            }
        }
        return list;
    }


    // 处理导入状态
    public static List<Map<String, Object>> importCheckCategoryName(List<Map<String, Object>> list, Map<String, Boolean> materialCategoryMap, Map<String, Boolean> equipmentCategoryProMap){
        for(Map<String, Object> map:list){
            List<Map<String, Object>> child =(List)map.get("children");
            if(child != null){//有子级
                map.put("leafFlag",false);
            }else{
                map.put("leafFlag",true);
                //档案分类名称必须存在
                if(map.get("categoryName")!=null &&  map.get("costType")!=null){
                    Boolean aBoolean=true;
                    Integer costType = map.get("costType")!=null ? (Integer)map.get("costType") : null;
                    String categoryName = (String)map.get("categoryName");
                    String entryType = map.get("entryType")!=null ? (String)map.get("entryType") : null;
                    if (costType!=null && costType==2 && entryType!=null && entryType.equals("1")){
                         aBoolean = materialCategoryMap.get(categoryName);
                    }
                    else if (costType!=null && costType==4 &&  entryType!=null && entryType.equals("1")){
                        aBoolean = equipmentCategoryProMap.get(categoryName);
                    }
                    if (aBoolean==false){
                        map.put("importFlag",false);
                        String warnType=(String)map.get("warnType");
                        if(StringUtils.isNotEmpty(warnType)){
                            map.put("warnType",warnType+"材料分类必须存在,");
                        }else{
                            map.put("warnType","材料分类必须存在");
                        }
                    }
                }
            }
            if((Boolean)map.get("importFlag") == false){// 错误行
                if(child != null){//如果有下级
                    if((Boolean)map.get("parentWarn")){//父级错误，则所有下级都错误
                        map.put("children",importFlagToFalse(child));
                    }else{// 父级没有错误,则本级不算错误
                        map.put("importFlag",true);
                        //继续递归
                        List<Map<String, Object>> mapList = importCheckCategoryName(child,materialCategoryMap,equipmentCategoryProMap);
                        int i=0;
                        for(Map<String, Object> childMap:mapList){
                            if((Boolean)childMap.get("importFlag")){
                                i++; // 有一个true，上级就不算错误
                            }
                        }
                        // 如果下级都是错误行，则本级也是错误的
                        if(i == 0){
                            map.put("importFlag",false);
                        }
                        map.put("children",importCheckCategoryName(child,materialCategoryMap,equipmentCategoryProMap));
                    }
                }
            }else{//如果不是错误行，继续递归
                if(child != null) {//如果有下级
                    //继续递归
                    List<Map<String, Object>> mapList = importCheckCategoryName(child,materialCategoryMap,equipmentCategoryProMap);
                    int i=0;
                    for(Map<String, Object> childMap:mapList){
                        if((Boolean)childMap.get("importFlag")){
                            i++; // 有一个true，上级就不算错误
                        }
                    }
                    // 如果下级都是错误行，则级也是错误的
                    if(i == 0){
                        map.put("importFlag",false);
                    }
                    //map.put("children",importFlag(child));
                    map.put("children",mapList);
                }
            }
        }
        return list;
    }

    // 全部置为错误
    public static List<Map<String, Object>> importFlagToFalse(List<Map<String, Object>> list){
        for(Map<String, Object> map:list){
            map.put("importFlag",false);
            List<Map<String, Object>> child =(List)map.get("children");
            if(child != null){//有子级
                map.put("leafFlag",false);
            }else{
                map.put("leafFlag",true);
            }
            if(child != null){
                map.put("children",importFlagToFalse(child));
            }
        }
        return list;
    }
    // 分割能否导入的数据
    public static List<List<Map<String, Object>>> separate(List<Map<String, Object>> list,List<Map<String, Object>> falseList){
        for(int i= 0;i<list.size();i++){
            Map<String, Object> stringObjectMap = list.get(i);
            if((Boolean)stringObjectMap.get("importFlag") == false) {// 错误行
                falseList.add(stringObjectMap);
                list.remove(i);
                i--;
            }else{
                List<Map<String, Object>> child =(List)stringObjectMap.get("children");
                if(child!=null){
                    stringObjectMap.put("children",separate(child,falseList).get(0));
                }
            }
        }
        List<List<Map<String, Object>>> lists=new ArrayList<>();
        lists.add(list);
        lists.add(falseList);
        return lists;
    }
    // 树转list
    public static List<Map<String, Object>> treeToList(List<Map<String, Object>> list){
        List<Map<String, Object>> reList=new ArrayList<>();
        for(Map<String, Object> stringObjectMap:list){
            List<Map<String, Object>> child =(List)stringObjectMap.get("children");
            String warnType=(String)stringObjectMap.get("warnType");
            if(null == warnType || warnType.length()<1){
                stringObjectMap.put("warnType","上级或下级存在错误！");
            }
            stringObjectMap.put("id",stringObjectMap.get("tid"));
            if(null!=child){// 有下级
                List<Map<String, Object>> childrenList=treeToList(child);
                stringObjectMap.put("children",null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
            }else{
                reList.add(stringObjectMap);
            }
        }
        return reList;
    }

    public static void getCompareCodeMapByTree(List<Map<String, Object>> list, Map<String, String> reList, LinkedList<String> codes, Map<String, Integer> detailCodeCount) {
        for (Map<String, Object> stringObjectMap : list) {
            if (codes == null) {
                codes = new LinkedList<>();
            }
            codes.add(stringObjectMap.get("code").toString());
            if (stringObjectMap.get("materialId") != null) {
                codes.add(stringObjectMap.get("materialId").toString());
            }
            String changeCompareCode = String.join("#", codes);
            if (detailCodeCount.containsKey(changeCompareCode)) {
                int i = detailCodeCount.get(changeCompareCode) + 1;
                changeCompareCode += "@" + i;
                detailCodeCount.put(changeCompareCode, i);
            } else {
                detailCodeCount.put(changeCompareCode, 1);
            }

            reList.put(stringObjectMap.get("id").toString(), changeCompareCode);

            List<Map<String, Object>> child = (List) stringObjectMap.get("children");
            if (null != child) {// 有下级
                getCompareCodeMapByTree(child, reList, codes, detailCodeCount);
            }
            codes.remove(stringObjectMap.get("code").toString());
            if (stringObjectMap.get("materialId") != null) {
                codes.remove(stringObjectMap.get("materialId").toString());
            }
        }
    }


    public static void getCompareCodeVOMapAndFlatData(List<Map<String, Object>> list, Map<String, Map<String, Object>> reList, LinkedList<String> codes, List<String> detailCodeMapList, Map<String, Integer> importCodeCount) {
        for (Map<String, Object> stringObjectMap : list) {
            if (codes == null) {
                codes = new LinkedList<>();
            }
            String code = stringObjectMap.get("code").toString();
            codes.add(code);
            if (stringObjectMap.get("materialId") != null) {
                codes.add(stringObjectMap.get("materialId").toString());
            }
            String changeCompareCode = String.join("#", codes);
            if (stringObjectMap.get("materialCode") != null && !detailCodeMapList.contains(changeCompareCode)) {
                for (int i = 0; i < codes.size(); i++) {
                    if (codes.get(i).equals(code)) {
                        codes.set(i, stringObjectMap.get("materialCode").toString());
                    }
                }
                changeCompareCode = String.join("#", codes);
            }

            if (importCodeCount.containsKey(changeCompareCode)) {
                int i = importCodeCount.get(changeCompareCode) + 1;
                changeCompareCode += "@" + i;
                importCodeCount.put(changeCompareCode, i);
            } else {
                importCodeCount.put(changeCompareCode, 1);
            }
            stringObjectMap.put("changeCompareCode", changeCompareCode);
            reList.put(changeCompareCode, stringObjectMap);

            List<Map<String, Object>> child = (List) stringObjectMap.get("children");
            if (null != child) {// 有下级
                getCompareCodeVOMapAndFlatData(child, reList, codes, detailCodeMapList, importCodeCount);
                stringObjectMap.remove("children");
            }
            codes.remove(stringObjectMap.get("code").toString());
            if (stringObjectMap.get("materialId") != null) {
                codes.remove(stringObjectMap.get("materialId").toString());
            }
            if (stringObjectMap.get("materialCode") != null) {
                codes.remove(stringObjectMap.get("materialCode").toString());
            }
        }
    }


}
