package com.ejianc.business.cost.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.List;


/**
 * 集团成本科目实体
 *
 * @author generator
 *
 */
public class SubjectOrgVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String subjectName; // 成本科目名称
    private String subjectCode; // 成本科目编码
    private String memo; // 描述
    private Long parentId; // 父id
    private String innerCode; // 内置编码
    private Integer enabled; // 0：启用 / 1：停用

    private List<Long> ids;
    private String errorMessage;
    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;

    /**
     * 序号
     */
    private String detailIndex;

    private Long templateId; // 模板id

    private String controlType; // 控制方式
    private String receiveId; // 消息接收人
    private String receiveName; // 消息接收人

    @ReferSerialTransfer(referCode = "cost-subject-template")
    public Long getTemplateId() {
        return templateId;
    }
    @ReferDeserialTransfer
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getControlType() {
        return controlType;
    }


    public void setControlType(String controlType) {
        this.controlType = controlType;
    }

    @ReferSerialTransfer(referCode="idm-role")
    public String getReceiveId() {
        return receiveId;
    }

    @ReferDeserialTransfer
    public void setReceiveId(String receiveId) {
        this.receiveId = receiveId;
    }

    public String getReceiveName() {
        return receiveName;
    }

    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public String getWarnType() {
        return warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 成本科目编码
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目编码
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 描述
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 描述
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 父id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 内置编码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 内置编码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    /**
     * 1：启用 / 0：停用
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 1：启用 / 0：停用
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
}
