package com.ejianc.business.cost.api;

import com.ejianc.business.cost.hystrix.ProjectWbsHystrix;
import com.ejianc.business.cost.vo.ProjectWbsVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author cJ
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = ProjectWbsHystrix.class)
public interface IShareProjectWbsApi {

    /**
     * 根据id查询本下项目WBS
     *
     * @param
     * @return
     * @Author
     */
    @GetMapping(value = "/api/shareProjectWbsApi/queryProjectWbsList")
    CommonResponse<List<ProjectWbsVO>> queryProjectWbsList(@RequestParam(value = "id") Long id);

    /***
     * @description: 根据项目id查询wbs
     *
     * @param projectId
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.share.vo.ProjectWbsVO>>
     * @author songlx
     * @date: 2022/5/31
     */
    @GetMapping(value = "/api/shareProjectWbsApi/queryByProjectId")
    CommonResponse<List<ProjectWbsVO>> queryByProjectId(@RequestParam(value = "projectId") Long projectId);


    /***
     * @description: 根据项目ids 返回项目默认的wbs
     *
     * @param projectIds
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.share.vo.ProjectWbsVO>>
     * @author songlx
     * @date: 2022/5/31
     */
    @GetMapping(value = "/api/shareProjectWbsApi/queryByProjectIds")
    CommonResponse<Map<Long,ProjectWbsVO>> queryByProjectIds(@RequestParam(value = "projectIds") List<Long> projectIds);
}
