package com.ejianc.business.cost.api;

import com.ejianc.business.cost.hystrix.SubjectOrgHystrix;
import com.ejianc.business.cost.vo.SubjectOrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 设备rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = SubjectOrgHystrix.class)
public interface IShareSubjectOrgApi {

    /**
     *
     * @Author
     * @param
     * @return
     */
	@GetMapping(value = "/api/shareSubjectOrgApi/querySubjectOrgTree")
	CommonResponse<List<SubjectOrgVO>> shareSubjectOrgApi();

	/**
	 * 查询
	 * @param param
	 * @return
	 */
	@PostMapping("/api/shareSubjectOrgApi/querySubjectOrg")
	@ResponseBody
	public CommonResponse<List<SubjectOrgVO>> querySubjectOrg(@RequestBody QueryParam param);


	@GetMapping("/api/shareSubjectOrgApi/querySubjectOrgIds")
	CommonResponse<List<Long>> querySubjectOrgIds(@RequestParam String subjectName);
}
