package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.ForecastContractDetailEntity;
import com.ejianc.business.cost.bean.ForecastOtherDetailEntity;
import com.ejianc.business.cost.bean.ForecastMaterialcontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastMachinecontractDetailEntity;
import com.ejianc.business.cost.bean.ForecastOthercontractDetailEntity;
/**
 * 成本关门预估
 *
 * @author generator
 *
 */
@TableName("ejc_cost_closing_forecast")
public class CostClosingForecastEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="amount_fees_tax")
    private BigDecimal amountFeesTax; // 预估总成本（含税）
    @TableField(value="amount_fees")
    private BigDecimal amountFees; // 预估总成本（不含税）
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 预估总成本税金
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人姓名
    @TableField(value="employee_org")
    private Long employeeOrg; // 经办部门
    @TableField(value="subconsum")
    private BigDecimal subconsum; // 分包成本关门含税
    @TableField(value="subconsumnotax")
    private BigDecimal subconsumnotax; // 分包成本关门不含税
    @TableField(value="subconsumtax")
    private BigDecimal subconsumtax; // 分包成本关门税金
    @TableField(value="othersum")
    private BigDecimal othersum; // 其他预估含税
    @TableField(value="othersumnotax")
    private BigDecimal othersumnotax; // 其他预估不含税
    @TableField(value="othersumtax")
    private BigDecimal othersumtax; // 其他预估税金
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="max_settlement")
    private BigDecimal maxSettlement; // 最大结算值 （不含税）
    @TableField(value="max_tax_settlement")
    private BigDecimal maxTaxSettlement; // 最大结算值 （含税）
    @TableField(value="conservative_settlement")
    private BigDecimal conservativeSettlement; // 保守结算值 （不含税）
    @TableField(value="conservative_tax_settlement")
    private BigDecimal conservativeTaxSettlement; // 保守结算值 （含税）
    @TableField(value="settlement_tax")
    private BigDecimal settlementTax; // 最大结算值税额
    @TableField(value="conservative_tax")
    private BigDecimal conservativeTax; // 保守结算值税额
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="change_status_name")
    private String changeStatusName; // 变更状态名称



    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 不含税合同额
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 开累不含税产值
    @TableField(value="profit_margin")
    private BigDecimal profitMargin; // 完工利润率

    public BigDecimal getPayreim() {
        return payreim;
    }

    public void setPayreim(BigDecimal payreim) {
        this.payreim = payreim;
    }

    @TableField(value="payreim")
    private BigDecimal payreim; // 累计其他付款


    @TableField(exist=false)
    @SubEntity(serviceName="forecastContractDetailService",pidName = "costClosingForecastId")
    private List<ForecastContractDetailEntity> forecastContractDetailList = new ArrayList<>(); // 合同成本关门预估控制明细
    @TableField(exist=false)
    @SubEntity(serviceName="forecastOtherDetailService",pidName = "costClosingForecastId")
    private List<ForecastOtherDetailEntity> forecastOtherDetailList = new ArrayList<>(); // 其他预估成本关门控制明细
    @TableField(exist=false)
    @SubEntity(serviceName="forecastMaterialcontractDetailService",pidName = "costClosingForecastId")
    private List<ForecastMaterialcontractDetailEntity> forecastMaterialcontractDetailList = new ArrayList<>(); // 物资合同成本关门预估控制明细
    @TableField(exist=false)
    @SubEntity(serviceName="forecastMachinecontractDetailService",pidName = "costClosingForecastId")
    private List<ForecastMachinecontractDetailEntity> forecastMachinecontractDetailList = new ArrayList<>(); // 机械合同成本关门预估控制明细
    @TableField(exist=false)
    @SubEntity(serviceName="forecastOthercontractDetailService",pidName = "costClosingForecastId")
    private List<ForecastOthercontractDetailEntity> forecastOthercontractDetailList = new ArrayList<>(); // 其他合同成本关门预估控制明细

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getAmountFeesTax() {
        return amountFeesTax;
    }

    public void setAmountFeesTax(BigDecimal amountFeesTax) {
        this.amountFeesTax = amountFeesTax;
    }
    public BigDecimal getAmountFees() {
        return amountFees;
    }

    public void setAmountFees(BigDecimal amountFees) {
        this.amountFees = amountFees;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeOrg() {
        return employeeOrg;
    }

    public void setEmployeeOrg(Long employeeOrg) {
        this.employeeOrg = employeeOrg;
    }
    public BigDecimal getSubconsum() {
        return subconsum;
    }

    public void setSubconsum(BigDecimal subconsum) {
        this.subconsum = subconsum;
    }
    public BigDecimal getSubconsumnotax() {
        return subconsumnotax;
    }

    public void setSubconsumnotax(BigDecimal subconsumnotax) {
        this.subconsumnotax = subconsumnotax;
    }
    public BigDecimal getSubconsumtax() {
        return subconsumtax;
    }

    public void setSubconsumtax(BigDecimal subconsumtax) {
        this.subconsumtax = subconsumtax;
    }
    public BigDecimal getOthersum() {
        return othersum;
    }

    public void setOthersum(BigDecimal othersum) {
        this.othersum = othersum;
    }
    public BigDecimal getOthersumnotax() {
        return othersumnotax;
    }

    public void setOthersumnotax(BigDecimal othersumnotax) {
        this.othersumnotax = othersumnotax;
    }
    public BigDecimal getOthersumtax() {
        return othersumtax;
    }

    public void setOthersumtax(BigDecimal othersumtax) {
        this.othersumtax = othersumtax;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getMaxSettlement() {
        return maxSettlement;
    }

    public void setMaxSettlement(BigDecimal maxSettlement) {
        this.maxSettlement = maxSettlement;
    }
    public BigDecimal getMaxTaxSettlement() {
        return maxTaxSettlement;
    }

    public void setMaxTaxSettlement(BigDecimal maxTaxSettlement) {
        this.maxTaxSettlement = maxTaxSettlement;
    }
    public BigDecimal getConservativeSettlement() {
        return conservativeSettlement;
    }

    public void setConservativeSettlement(BigDecimal conservativeSettlement) {
        this.conservativeSettlement = conservativeSettlement;
    }
    public BigDecimal getConservativeTaxSettlement() {
        return conservativeTaxSettlement;
    }

    public void setConservativeTaxSettlement(BigDecimal conservativeTaxSettlement) {
        this.conservativeTaxSettlement = conservativeTaxSettlement;
    }
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }

    public BigDecimal getConservativeTax() {
        return conservativeTax;
    }

    public void setConservativeTax(BigDecimal conservativeTax) {
        this.conservativeTax = conservativeTax;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public List<ForecastContractDetailEntity> getForecastContractDetailList() {
        return forecastContractDetailList;
    }

    public void setForecastContractDetailList(List<ForecastContractDetailEntity> forecastContractDetailList) {
        this.forecastContractDetailList = forecastContractDetailList;
    }

    public List<ForecastOtherDetailEntity> getForecastOtherDetailList() {
        return forecastOtherDetailList;
    }

    public void setForecastOtherDetailList(List<ForecastOtherDetailEntity> forecastOtherDetailList) {
        this.forecastOtherDetailList = forecastOtherDetailList;
    }

    public List<ForecastMaterialcontractDetailEntity> getForecastMaterialcontractDetailList() {
        return forecastMaterialcontractDetailList;
    }

    public void setForecastMaterialcontractDetailList(List<ForecastMaterialcontractDetailEntity> forecastMaterialcontractDetailList) {
        this.forecastMaterialcontractDetailList = forecastMaterialcontractDetailList;
    }

    public List<ForecastMachinecontractDetailEntity> getForecastMachinecontractDetailList() {
        return forecastMachinecontractDetailList;
    }

    public void setForecastMachinecontractDetailList(List<ForecastMachinecontractDetailEntity> forecastMachinecontractDetailList) {
        this.forecastMachinecontractDetailList = forecastMachinecontractDetailList;
    }

    public List<ForecastOthercontractDetailEntity> getForecastOthercontractDetailList() {
        return forecastOthercontractDetailList;
    }

    public void setForecastOthercontractDetailList(List<ForecastOthercontractDetailEntity> forecastOthercontractDetailList) {
        this.forecastOthercontractDetailList = forecastOthercontractDetailList;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getProfitMargin() {
        return profitMargin;
    }

    public void setProfitMargin(BigDecimal profitMargin) {
        this.profitMargin = profitMargin;
    }
}
