package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 最终成本关门通知变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_closing_last_change")
public class CostClosingLastChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值报量（不含税）
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值报量（含税）
    @TableField(value="project_cost")
    private BigDecimal projectCost; // 项目造价
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="last_output_value")
    private BigDecimal lastOutputValue; // 最终审定产值 （不含税）
    @TableField(value="last_tax_output_value")
    private BigDecimal lastTaxOutputValue; // 最终审定产值 （含税）
    @TableField(value="completion_time")
    private Date completionTime; // 完工时间
    @TableField(value="oldlast_cost_closing_time")
    private Date oldlastCostClosingTime; // 原最终成本关门期限
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="sum_production_tax")
    private BigDecimal sumProductionTax; // 项目产值税额
    @TableField(value="settlement_tax")
    private BigDecimal settlementTax; // 最终审定产值税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="completion_acceptance_time")
    private Date completionAcceptanceTime; // 竣工验收时间
    @TableField(value="settlement_auditing_time")
    private Date settlementAuditingTime; // 结算审计时间
    @TableField(value="closing_last_id")
    private Long closingLastId; // 原单id
    @TableField(value="last_cost_closing_time")
    private Date lastCostClosingTime; // 调整后最终成本关门期限
    @TableField(value="days")
    private String days; // 申请延长时间
    @TableField(value="old_cost_closing_time")
    private Date oldCostClosingTime; // 原成本关门期限
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_code")
    private String changeCode; // 变更单号

    
    
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getProjectCost() {
        return projectCost;
    }

    public void setProjectCost(BigDecimal projectCost) {
        this.projectCost = projectCost;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getLastOutputValue() {
        return lastOutputValue;
    }

    public void setLastOutputValue(BigDecimal lastOutputValue) {
        this.lastOutputValue = lastOutputValue;
    }
    public BigDecimal getLastTaxOutputValue() {
        return lastTaxOutputValue;
    }

    public void setLastTaxOutputValue(BigDecimal lastTaxOutputValue) {
        this.lastTaxOutputValue = lastTaxOutputValue;
    }
    public Date getCompletionTime() {
        return completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }
    public Date getOldlastCostClosingTime() {
        return oldlastCostClosingTime;
    }

    public void setOldlastCostClosingTime(Date oldlastCostClosingTime) {
        this.oldlastCostClosingTime = oldlastCostClosingTime;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public BigDecimal getSumProductionTax() {
        return sumProductionTax;
    }

    public void setSumProductionTax(BigDecimal sumProductionTax) {
        this.sumProductionTax = sumProductionTax;
    }
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getCompletionAcceptanceTime() {
        return completionAcceptanceTime;
    }

    public void setCompletionAcceptanceTime(Date completionAcceptanceTime) {
        this.completionAcceptanceTime = completionAcceptanceTime;
    }
    public Date getSettlementAuditingTime() {
        return settlementAuditingTime;
    }

    public void setSettlementAuditingTime(Date settlementAuditingTime) {
        this.settlementAuditingTime = settlementAuditingTime;
    }
    public Long getClosingLastId() {
        return closingLastId;
    }

    public void setClosingLastId(Long closingLastId) {
        this.closingLastId = closingLastId;
    }
    public Date getLastCostClosingTime() {
        return lastCostClosingTime;
    }

    public void setLastCostClosingTime(Date lastCostClosingTime) {
        this.lastCostClosingTime = lastCostClosingTime;
    }
    public String getDays() {
        return days;
    }

    public void setDays(String days) {
        this.days = days;
    }
    public Date getOldCostClosingTime() {
        return oldCostClosingTime;
    }

    public void setOldCostClosingTime(Date oldCostClosingTime) {
        this.oldCostClosingTime = oldCostClosingTime;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    
}
