package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 其他预估成本关门变更控制明细
 *
 * @author generator
 *
 */
@TableName("ejc_forecast_other_detail_change")
public class ForecastOtherDetailChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="cost_type_Id")
    private Long costTypeId; // 费用类别
    @TableField(value="cost_type_name")
    private String costTypeName; // 费用类别名称
    @TableField(value="cost_analysis")
    private String costAnalysis; // 费用分析
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称
    @TableField(value="estimated_amount")
    private BigDecimal estimatedAmount; // 原不含税预估金额(元)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 原预估金额税金
    @TableField(value="estimated_tax_amount")
    private BigDecimal estimatedTaxAmount; // 原含税预估金额(元)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="accounting_id")
    private String accountingId; // 变更状态
    @TableField(value="accounting_name")
    private String accountingName; // 变更状态名称
    @TableField(value="cost_change_forecast_id")
    private Long costChangeForecastId; // 成本关门预估id
    @TableField(value="increase_costs")
    private BigDecimal increaseCosts; // 增加成本费用（含税）
    @TableField(value="increase_costs_notax")
    private BigDecimal increaseCostsNotax; // 增加成本费用（不含税）
    @TableField(value="increase_costs_tax")
    private BigDecimal increaseCostsTax; // 增加成本费用（税金）
    @TableField(value="increase_estimated_amount_notax")
    private BigDecimal increaseEstimatedAmountNotax; // 不含税预估总成本
    @TableField(value="increase_estimated_amount_tax")
    private BigDecimal increaseEstimatedAmountTax; // 预估总成本税金
    @TableField(value="increase_estimated_amount")
    private BigDecimal increaseEstimatedAmount; // 含税预估总成本
    @TableField(value="brief_description")
    private String briefDescription; // 预估成本简要说明
    @TableField(value="source_forecast_id")
    private Long sourceForecastId; // 成本关门预估id
    @TableField(value="source_forecast_other_id")
    private Long sourceForecastOtherId; // 成本关门预估其他明细id
    @TableField(value="accounting_f_j")
    private String accountingFJ; // 上传附件
    @TableField(value="project_id")
    private Long projectId; // 项目主键

    public String getAccountingFJ() {
        return accountingFJ;
    }

    public void setAccountingFJ(String accountingFJ) {
        this.accountingFJ = accountingFJ;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCostTypeId() {
        return costTypeId;
    }

    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }
    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }
    public String getCostAnalysis() {
        return costAnalysis;
    }

    public void setCostAnalysis(String costAnalysis) {
        this.costAnalysis = costAnalysis;
    }
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getEstimatedTaxAmount() {
        return estimatedTaxAmount;
    }

    public void setEstimatedTaxAmount(BigDecimal estimatedTaxAmount) {
        this.estimatedTaxAmount = estimatedTaxAmount;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(String accountingId) {
        this.accountingId = accountingId;
    }
    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getCostChangeForecastId() {
        return costChangeForecastId;
    }

    public void setCostChangeForecastId(Long costChangeForecastId) {
        this.costChangeForecastId = costChangeForecastId;
    }
    public BigDecimal getIncreaseCosts() {
        return increaseCosts;
    }

    public void setIncreaseCosts(BigDecimal increaseCosts) {
        this.increaseCosts = increaseCosts;
    }
    public BigDecimal getIncreaseCostsNotax() {
        return increaseCostsNotax;
    }

    public void setIncreaseCostsNotax(BigDecimal increaseCostsNotax) {
        this.increaseCostsNotax = increaseCostsNotax;
    }
    public BigDecimal getIncreaseCostsTax() {
        return increaseCostsTax;
    }

    public void setIncreaseCostsTax(BigDecimal increaseCostsTax) {
        this.increaseCostsTax = increaseCostsTax;
    }
    public BigDecimal getIncreaseEstimatedAmountNotax() {
        return increaseEstimatedAmountNotax;
    }

    public void setIncreaseEstimatedAmountNotax(BigDecimal increaseEstimatedAmountNotax) {
        this.increaseEstimatedAmountNotax = increaseEstimatedAmountNotax;
    }
    public BigDecimal getIncreaseEstimatedAmountTax() {
        return increaseEstimatedAmountTax;
    }

    public void setIncreaseEstimatedAmountTax(BigDecimal increaseEstimatedAmountTax) {
        this.increaseEstimatedAmountTax = increaseEstimatedAmountTax;
    }
    public BigDecimal getIncreaseEstimatedAmount() {
        return increaseEstimatedAmount;
    }

    public void setIncreaseEstimatedAmount(BigDecimal increaseEstimatedAmount) {
        this.increaseEstimatedAmount = increaseEstimatedAmount;
    }
    public String getBriefDescription() {
        return briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }
    public Long getSourceForecastId() {
        return sourceForecastId;
    }

    public void setSourceForecastId(Long sourceForecastId) {
        this.sourceForecastId = sourceForecastId;
    }
    public Long getSourceForecastOtherId() {
        return sourceForecastOtherId;
    }

    public void setSourceForecastOtherId(Long sourceForecastOtherId) {
        this.sourceForecastOtherId = sourceForecastOtherId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

}
