package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.mapper.CostClosingMapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.service.ICostClosingService;
import com.ejianc.business.cost.vo.CostClosingVO;

/**
 * 成本关门
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costClosing")
public class CostClosingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COST_CLOSING_CODE";//此处需要根据实际修改

    @Autowired
    private ICostClosingService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CostClosingMapper costClosingMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostClosingVO> saveOrUpdate(@RequestBody CostClosingVO saveOrUpdateVO) {
    	CostClosingEntity entity = BeanMapper.map(saveOrUpdateVO, CostClosingEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        LambdaQueryWrapper<CostClosingEntity> lambda2 = Wrappers.<CostClosingEntity>lambdaQuery();
//        lambda2.eq(CostClosingEntity::getProjectId, saveOrUpdateVO.getProjectId());
//        lambda2.eq(CostClosingEntity::getTenantId, tenantId);
//        lambda2.ne(CostClosingEntity::getId, saveOrUpdateVO.getId());
//        List<CostClosingEntity> entities2 = service.list(lambda2);
//        if(entities2 != null && entities2.size() > 0) {
//            throw new BusinessException("该项目已经做过成本关门通知单，不允许保存!");
//        }
//        Long projectId = saveOrUpdateVO.getProjectId();
//        Long id = saveOrUpdateVO.getId();
//        Integer total = costClosingMapper.queryData(projectId,id);
//        if(total != 0) {
//            throw new BusinessException("该项目已经做过成本关门通知单，不允许保存!");
//        }
        if(entity.getChangeStatus() == null){
            entity.setChangeStatus(1);
            entity.setChangeStatusName("未变更");
        }

    	service.saveOrUpdate(entity, false);
    	CostClosingVO vo = BeanMapper.map(entity, CostClosingVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingVO> queryDetail(Long id) {
    	CostClosingEntity entity = service.selectById(id);
    	CostClosingVO vo = BeanMapper.map(entity, CostClosingVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostClosingVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CostClosingVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CostClosingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostClosingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<CostClosingEntity> page = service.queryPage(param,false);
        IPage<CostClosingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        List<CostClosingEntity> list = service.queryList(param);
        IPage<CostClosingEntity> list= service.queryPage(param,false);
        List<CostClosingVO> volist = new ArrayList<>();
        if(null!=list.getRecords()&&CollectionUtils.isNotEmpty(list.getRecords())){
            volist = BeanMapper.mapList(list.getRecords(), CostClosingVO.class);
            volist.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CostClosing-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCostClosingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostClosingVO>> refCostClosingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostClosingEntity> page = service.queryPage(param,false);
        IPage<CostClosingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 根据项目查询施工合同
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/projectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> refProjectData(@RequestParam(value = "id", required = false) String id) {
        Map<String,Object> resultMap = service.queryProjectPage(id);
        return CommonResponse.success("查询参照数据成功！",resultMap);
    }

    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingVO> queryDetailRecord(Long id) {
        CostClosingVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询记录数据成功！",vo);
    }

    @RequestMapping(value = "/addProjectCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addProjectCheck(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "id") Long id) {
        String message = service.addProjectCheck(projectId,id);
        return CommonResponse.success(message);
    }

    @RequestMapping(value = "/checkchange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkchange(@RequestParam(value = "id") Long id) {
        String message = service.checkchange(id);
        return CommonResponse.success(message);
    }


}
