package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cost.service.IReportService;
import com.ejianc.business.cost.utils.MathUtil;
import com.ejianc.business.cost.utils.TreeUtil;
import com.ejianc.business.cost.vo.CostClosingForecastChangeVO;
import com.ejianc.business.cost.vo.CostClosingForecastVO;
import com.ejianc.business.cost.vo.report.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping("/report")
public class ReportController {

    @Autowired
    private IReportService reportService;

    /**
     * 产值统计报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/subjectCostList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> subjectCostList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        return CommonResponse.success("查询列表数据成功！", reportService.subjectCostList(param));
    }

    /**
     * 产值统计报表导出
     * @param param
     * @param response
     */
    @PostMapping("subjectCostExport")
    public void subjectCostExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = reportService.subjectCostList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<SubjectCostVO> list = new ArrayList<>();
        if (null != pageList.get("records") && CollectionUtils.isNotEmpty((List)pageList.get("records"))) {
            list = BeanMapper.mapList((List)pageList.get("records"), SubjectCostVO.class);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("subject-cost-report-export.xlsx", beans, response);
    }


    /**
     * 集团工程产值与实际成本两算对比
     *productionVersusCostCompanyExport
     * @param param
     * @return
     */
    @RequestMapping(value = "/getProductionVersusCostCompanyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getProductionVersusCostCompanyList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.getProductionVersusCostCompanyList(param));
    }

    /**
     * 集团工程产值与实际成本两算对比导出
     *
     * @param param
     * @return
     */
    @PostMapping("productionVersusCostCompanyExport")
    public void productionVersusCostCompanyExport(@RequestBody QueryParam param, HttpServletResponse response) {




        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = reportService.getProductionVersusCostCompanyList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<ProductionVersusCostCompanyVO> list = new ArrayList<>();
        if (null != pageList.get("records") && CollectionUtils.isNotEmpty((List)pageList.get("records"))) {
            list = BeanMapper.mapList((List)pageList.get("records"), ProductionVersusCostCompanyVO.class);
            for (ProductionVersusCostCompanyVO vo : list) {
                vo.setMonthProfitMargin(MathUtil.safeDiv(vo.getMonthProfitMargin(), new BigDecimal("100")));
                vo.setYearProfitMargin(MathUtil.safeDiv(vo.getYearProfitMargin(), new BigDecimal("100")));
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("productionVersusCostCompany-report-export.xlsx", beans, response);
    }
    
    /**
     * 分子公司产值与实际成本两算对比(按项目汇总)
     * @param param
     * @return
     */
    @PostMapping(value = "/queryProjectProductionCostTwo")
    @ResponseBody
    public CommonResponse<Object> queryProjectProductionCostTwo(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.queryProjectProductionCostTwo(param));
    }

    /**
     * 分子公司产值与实际成本两算对比(按项目汇总)导出
     * @param param
     * @return
     */
    @PostMapping(value = "/queryProjectProductionCostTwoExport")
    @ResponseBody
    public void queryProjectProductionCostTwoExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);

        JSONObject pageList = reportService.queryProjectProductionCostTwo(param);

        List<ProjectProductionCostTwoVO> list = (List<ProjectProductionCostTwoVO>) pageList.get("records");
        for (ProjectProductionCostTwoVO vo : list) {
            vo.setMonthProfitMargin(MathUtil.safeDiv(vo.getMonthProfitMargin(), new BigDecimal("100")));
            vo.setYearProfitMargin(MathUtil.safeDiv(vo.getYearProfitMargin(), new BigDecimal("100")));
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);

        ExcelExport.getInstance().export("projectProductionCostTwo-export.xlsx", beans, response);
    }
    
    /**
     * 项目成本三算对比分析
     * @param param
     * @return
     */
    @PostMapping(value = "/queryProjectCostThree")
    @ResponseBody
    public CommonResponse<Object> queryProjectCostThree(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.queryProjectCostThree(param));
    }

    /**
     * 项目成本三算对比分析导出
     * @param param
     * @param response
     */
    @PostMapping("projectCostThreeExport")
    public void projectCostThreeExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);

        JSONObject pageList = reportService.queryProjectCostThree(param);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageList.get("records"));

        ExcelExport.getInstance().export("projectCostThree-export.xlsx", beans, response);
    }


    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/getProductionVersusCostAccountingTreeList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProductionVersusCostAccountingTreeList(@RequestParam(value = "projectId") Long projectId,
                                                         @RequestParam(value = "happenDate") String happenDate) {
        List<Map<String, Object>> list = reportService.getProductionVersusCostAccountingTreeList(projectId,happenDate);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }
    /**
     * 导出
     *
     * @return
     */
    @PostMapping("productionVersusCostAccountingTreeExport")
    public void productionVersusCostAccountingTreeExport(@RequestBody ProductionVersusCostAccountingVO vo,
                                         HttpServletResponse response) {
        List<Map<String, Object>> list =new ArrayList<>();
        if(vo != null && vo.getProjectId() > 0 && StringUtils.isNotBlank(vo.getCountMonth())){
            list = reportService.getProductionVersusCostAccountingTreeList(vo.getProjectId(),vo.getCountMonth());
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("productionVersusCostAccountingTree-report-export.xlsx", beans, response);
    }

    /**
     * 项目实际成本统计（按核算对象展开）
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/accountingCostList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> accountingCostList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        return CommonResponse.success("查询列表数据成功！", reportService.accountingCostList(param));
    }

    /**
     * 项目实际成本统计（按核算对象展开）导出
     * @param param
     * @param response
     */
    @PostMapping("accountingCostExport")
    public void accountingCostExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = reportService.accountingCostList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<AccountingCostVO> list = new ArrayList<>();
        if (null != pageList.get("records") && CollectionUtils.isNotEmpty((List)pageList.get("records"))) {
            list = BeanMapper.mapList((List)pageList.get("records"), AccountingCostVO.class);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("accounting-cost-report-export.xlsx", beans, response);
    }
    
    /**
     * 项目经理门户-成本构成
     * @param yearFlag 0-年累，1-开累
     * @return
     */
    @GetMapping(value = "/querySubjectCostList")
    @ResponseBody
    public CommonResponse<List<OrgSubjectReportVO>> querySubjectCostList(@RequestParam(value = "yearFlag") Integer yearFlag) {
        return CommonResponse.success("查询列表数据成功！", reportService.querySubjectCostList(yearFlag));
    }

    /**
     * 工程项目完工成本关门成本汇总明细数据查询   3
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectCompletionSum")
    @ResponseBody
    public CommonResponse<JSONObject> projectCompletionSum(@RequestParam(value = "projectId") Long projectId) {
        List<Map<String, Object>> list = reportService.projectCompletionSum(projectId);
        JSONObject jsonObject = new JSONObject();
//        if(list != null && list.size()>0){
            jsonObject.put("records", list);
//        }
//        else{
//            throw new BusinessException("未找到当前项目下属的成本关门预估单数据，请先制单！");
//        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目完工成本关门成本汇总明细导出   3
     * @param param
     * @param response
     */
    @PostMapping("projectCompletionSumExport")
    public void projectCompletionSumExport(@RequestBody CostClosingForecastVO vo,
                                           HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = new ArrayList<>();
        if(vo != null && vo.getProjectId() != null){
            Long projectId = vo.getProjectId();
            list = reportService.projectCompletionSum(projectId);
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("project-completion-sum-export.xlsx", beans, response);
    }

    /**
     * 工程项目完工成本关门成本汇总明细表（变更后）   4   取变更单 非实时
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectCompletionSumRealtime")
    @ResponseBody
    public CommonResponse<JSONObject> projectCompletionSumRealtime(@RequestParam(value = "projectId") Long projectId) {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = reportService.projectCompletionSumRealtime(projectId);
        jsonObject.put("records", list);
//        if(projectId != null){
//            List<Map<String, Object>> list = reportService.projectCompletionSumRealtime(projectId);
//            jsonObject.put("records", list);
//        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目完工成本关门成本汇总明细表（变更后）导出   4
     * @param param
     * @param response
     */
    @PostMapping("projectCompletionSumRealtimeExport")
    public void projectCompletionSumRealtimeExport(@RequestBody CostClosingForecastVO vo,
                                           HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = new ArrayList<>();
        if(vo != null && vo.getProjectId() != null){
            Long projectId = vo.getProjectId();
            list = reportService.projectCompletionSumRealtime(projectId);
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("project-completion-sum-realtime-export.xlsx", beans, response);
    }

    /**
     * 工程项目完工成本关门收支汇总表    1
     * @param param
     * @return
     */
    @RequestMapping(value = "/revenueExpenditureSummary")
    @ResponseBody
    public CommonResponse<JSONObject> RevenueExpenditureSummary() {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = reportService.revenueExpenditureSummary();
        jsonObject.put("records", list);
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }


    /**
     * 工程项目完工成本关门收支汇总表导出   1
     * @param param
     * @param response
     */
    @PostMapping("revenueExpenditureSummaryExport")
    public void revenueExpenditureSummaryExport(HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = reportService.revenueExpenditureSummary();
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("revenue-expenditure-summary-export.xlsx", beans,response);
    }

    //        for(int a = 0;a<list.size();a++){
//            Map<String, Object> map = list.get(a);
//            Object start = map.get("actualStart");
//            Object end = map.get("completionAcceptanceTime");
//            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//            if(start !=null){
//                Date startdate = (Date) start;
//                String startdateString = sdf.format(startdate);
//                map.put("actualStart",startdateString);
//            }else{
//                map.put("actualStart","--");
//            }
//            if(end != null){
//                Date enddate = (Date) end;
//                String enddateString = sdf.format(enddate);
//                map.put("completionAcceptanceTime",enddateString);
//            }else{
//                map.put("completionAcceptanceTime","--");
//            }
//
//            list.set(a,map);
//        }

    /**
     * 工程项目完工成本关门收支汇总表(实时)    2   取变更单 非实时
     * @param param
     * @return
     */
    @RequestMapping(value = "/revenueExpenditureSummaryRealTime")
    @ResponseBody
    public CommonResponse<JSONObject> ExpenditureSummaryRealTime() {
        JSONObject realtimejsonObject = new JSONObject();
        List<Map<String, Object>> reallist = reportService.ExpenditureSummaryRealTime();
        realtimejsonObject.put("records", reallist);
        return CommonResponse.success("查询列表数据成功！", realtimejsonObject);
    }

    /**
     * 工程项目完工成本关门收支汇总表(实时)导出    2   取变更单 非实时
     * @param param
     * @param response
     */
    @PostMapping("revenueExpenditureSummaryRealTimeExport")
    public void revenueExpenditureSummaryRealTimeExport(HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = reportService.ExpenditureSummaryRealTime();
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("revenue-expenditure-summary-real-time-export.xlsx", beans,response);
    }

    /**
     * 工程项目最终成本关门收支汇总表    5
     * @param param
     * @return
     */
    @RequestMapping(value = "/lastRevenueExpenditureSummary")
    @ResponseBody
    public CommonResponse<JSONObject> LastRevenueExpenditureSummary() {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = reportService.lastRevenueExpenditureSummary();
        jsonObject.put("records", list);
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目最终成本关门收支汇总表导出    5
     * @param param
     * @param response
     */
    @PostMapping("lastRevenueExpenditureSummaryExport")
    public void LastRevenueExpenditureSummaryExport(HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = reportService.lastRevenueExpenditureSummary();
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("last-revenue-expenditure-summary-export.xlsx", beans,response);
    }

    /**
     * 工程项目最终成本关门成本汇总明细表    6
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectFinCompletionSum")
    @ResponseBody
    public CommonResponse<JSONObject> projectFinCompletionSum(@RequestParam(value = "projectId") Long projectId) {
        List<Map<String, Object>> list = reportService.projectFinCompletionSum(projectId);
        JSONObject jsonObject = new JSONObject();
//        if(list != null && list.size()>0){
        jsonObject.put("records", list);
//        }
//        else{
//            throw new BusinessException("未找到当前项目下属的成本关门预估单数据，请先制单！");
//        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目最终成本关门成本汇总明细表导出    6
     * @param param
     * @param response
     */
    @PostMapping("projectFinCompletionSumExport")
    public void projectFinCompletionSumExport(@RequestBody CostClosingForecastVO vo,HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = new ArrayList<>();
        if(vo != null && vo.getProjectId() != null){
            Long projectId = vo.getProjectId();
            list = reportService.projectFinCompletionSum(projectId);
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("project-fin-completion-sum-export.xlsx", beans,response);
    }

    /**
     * 工程项目开累结算成本汇总明细表    7
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectFinExhaustedSum")
    @ResponseBody
    public CommonResponse<JSONObject> projectFinExhaustedSum(@RequestParam(value = "projectId") Long projectId) {
        List<Map<String, Object>> list = reportService.projectFinExhaustedSum(projectId);
        JSONObject jsonObject = new JSONObject();
//        if(list != null && list.size()>0){
        jsonObject.put("records", list);
//        }
//        else{
//            throw new BusinessException("未找到当前项目下属的成本关门预估单数据，请先制单！");
//        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目开累结算成本汇总明细表导出    7
     * @param param
     * @return
     */
    @PostMapping("projectFinExhaustedSumExport")
    public void projectFinExhaustedSumExport(@RequestBody CostClosingForecastVO vo,HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = new ArrayList<>();
        if(vo != null && vo.getProjectId() != null){
            Long projectId = vo.getProjectId();
            list = reportService.projectFinExhaustedSum(projectId);
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("project-fin-exhausted-sum-export.xlsx", beans,response);
    }

    /**
     * 工程项目完工成本关门（最终成本关门）成本汇总明细表（实时）    8
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectFinClosingSumRealTime")
    @ResponseBody
    public CommonResponse<JSONObject> projectFinClosingSumRealTime(@RequestParam(value = "projectId") Long projectId) {
        List<Map<String, Object>> list = reportService.projectFinClosingSumRealTime(projectId);
        JSONObject jsonObject = new JSONObject();
//        if(list != null && list.size()>0){
        jsonObject.put("records", list);
//        }
//        else{
//            throw new BusinessException("未找到当前项目下属的成本关门预估单数据，请先制单！");
//        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目完工成本关门（最终成本关门）成本汇总明细表（实时）导出    8
     * @param param
     * @return
     */
    @PostMapping("projectFinClosingSumRealTimeExport")
    public void projectFinClosingSumRealTimeExport(@RequestBody CostClosingForecastVO vo,HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = new ArrayList<>();
        if(vo != null && vo.getProjectId() != null){
            Long projectId = vo.getProjectId();
            list = reportService.projectFinClosingSumRealTime(projectId);
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("project-fin-closing-sum-real-time-export.xlsx", beans,response);
    }

    /**
     * 工程项目完工成本关门收支汇总表（实时）    9
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectFinAllClosingSumRealTime")
    @ResponseBody
    public CommonResponse<JSONObject> projectFinAllClosingSumRealTime() {
        List<Map<String, Object>> list = reportService.projectFinAllClosingSumRealTime();
        JSONObject jsonObject = new JSONObject();
//        if(list != null && list.size()>0){
        jsonObject.put("records", list);
//        }
//        else{
//            throw new BusinessException("未找到当前项目下属的成本关门预估单数据，请先制单！");
//        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 工程项目完工成本关门收支汇总表（实时）导出    9
     * @param param
     * @return
     */
    @PostMapping("projectFinAllClosingSumRealTimeExport")
    public void projectFinAllClosingSumRealTimeExport(HttpServletResponse response) {
//        param.setPageIndex(1);
//        param.setPageSize(-1);
        List<Map<String, Object>> list = reportService.projectFinAllClosingSumRealTime();
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));

        ExcelExport.getInstance().export("project-fin-all-closing-sum-real-time-export.xlsx", beans,response);
    }




}
