package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.bean.ForecastOtherDetailChangeEntity;
import com.ejianc.business.cost.mapper.CostClosingForecastMapper;
import com.ejianc.business.cost.mapper.ForecastOtherDetailChangeMapper;
import com.ejianc.business.cost.vo.SubjectProjectImportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.SubjectProjectEntity;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.business.cost.vo.SubjectProjectVO;

/**
 * 项目成本科目实体
 *
 * @author generator
 */
@Controller
@RequestMapping("subjectProject")
public class SubjectProjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String SUBJECT_PROJECT = "BT211012000000004";

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubjectProjectService service;

    @Autowired
    private CostClosingForecastMapper costClosingForecastMapper;

    @Autowired
    private ForecastOtherDetailChangeMapper forecastOtherDetailChangeMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectProjectVO> saveOrUpdate(@RequestBody SubjectProjectVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectProjectVO> queryDetail(Long id) {
        SubjectProjectEntity entity = service.selectById(id);
        SubjectProjectVO vo = BeanMapper.map(entity, SubjectProjectVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectProjectVO> vos) {
        List<Long> ids = vos.stream().map(SubjectProjectVO::getId).collect(Collectors.toList());
        for(Long billId:ids){
            //是否被其他单据引用
            CommonResponse<String>  res = billTypeApi.checkQuote(SUBJECT_PROJECT,billId);
            logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
            if(!res.isSuccess()) {//单据被下游单据引用
                throw new BusinessException("存在被结算单引用的档案，请处理后再删除！");
            }
        }
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subjectName");
        fuzzyFields.add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectProjectEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubjectProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubjectProjectData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refSubjectProjectData(@RequestParam(value = "searchText", required = false) String searchText,
                                           @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            } else {
                throw new BusinessException("请先选择项目！");
            }
        } else {
            throw new BusinessException("请先选择项目！");
        }
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectProjectEntity> list = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(SubjectProjectEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("orgSubjectId", entity.getOrgSubjectId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/forecastSubjectProjectData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> forecastSubjectProjectData(@RequestParam(value = "searchText", required = false) String searchText,
                                                           @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            } else {
                throw new BusinessException("请先选择项目！");
            }
        } else {
            throw new BusinessException("请先选择项目！");
        }
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectProjectEntity> list = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        Integer countaudit = costClosingForecastMapper.queryByProject(projectId);
        List<ForecastOtherDetailChangeEntity> listfore = new ArrayList<>();
        //如果当前项目已经做了预估单，则仅能取到预估单涵盖的成本科目数据
        if(countaudit != 0){
            String subjectName = null;
            listfore = forecastOtherDetailChangeMapper.queryalldata(String.valueOf(projectId),subjectName);
            for(ForecastOtherDetailChangeEntity fore:listfore){
                for(SubjectProjectEntity entity:list) {
                    if (entity.getId().equals(fore.getSubjectId())) {
                        map = new HashMap<>();
                        map.put("id", entity.getId());
                        map.put("key", entity.getId());
                        map.put("name", entity.getSubjectName());
                        map.put("code", entity.getSubjectCode());
                        map.put("parentId", entity.getParentId());
                        map.put("memo", entity.getMemo());
                        map.put("orgSubjectId", entity.getOrgSubjectId());
                        map.put("innerCode", entity.getInnerCode());
                        resultMapList.add(map);
                    }
                }
            }
        }else{
            for(SubjectProjectEntity entity:list) {
                map = new HashMap<>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getSubjectName());
                map.put("code", entity.getSubjectCode());
                map.put("parentId", entity.getParentId());
                map.put("memo", entity.getMemo());
                map.put("orgSubjectId", entity.getOrgSubjectId());
                map.put("innerCode", entity.getInnerCode());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     */
    @RequestMapping(value = "/importOrgSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importOrgSubject(@RequestBody SubjectProjectImportVO importVo) {
        service.importOrgSubject(importVo);
        return CommonResponse.success("引入成功！");
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/SubjectProjectChange", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> SubjectProjectChange(@RequestParam(value = "searchText", required = false) String searchText,
                                                           @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            } else {
                throw new BusinessException("请先选择项目！");
            }
        } else {
            throw new BusinessException("请先选择项目！");
        }

//        projectId = 795327292791341101L;
//        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));

        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectProjectEntity> list = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        Integer countaudit = costClosingForecastMapper.queryByProject(projectId);
        List<ForecastOtherDetailChangeEntity> listfore = new ArrayList<>();
        //如果当前项目已经做了预估单，则仅能取到预估单涵盖的成本科目数据
        if(countaudit != 0){
            String subjectName = null;
            listfore = forecastOtherDetailChangeMapper.queryalldatacc(String.valueOf(projectId));
            for(SubjectProjectEntity entity:list) {
                String nocf = "N";
                for(ForecastOtherDetailChangeEntity fore:listfore){
                    if (entity.getId().equals(fore.getSubjectId())) {
                        nocf = "Y";
                    }
                }
                if(nocf.equals("N")){
                    map = new HashMap<>();
                    map.put("id", entity.getId());
                    map.put("key", entity.getId());
                    map.put("name", entity.getSubjectName());
                    map.put("code", entity.getSubjectCode());
                    map.put("parentId", entity.getParentId());
                    map.put("memo", entity.getMemo());
                    map.put("orgSubjectId", entity.getOrgSubjectId());
                    map.put("innerCode", entity.getInnerCode());
                    resultMapList.add(map);
                }
            }
        }else{
            for(SubjectProjectEntity entity:list) {
                map = new HashMap<>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getSubjectName());
                map.put("code", entity.getSubjectCode());
                map.put("parentId", entity.getParentId());
                map.put("memo", entity.getMemo());
                map.put("orgSubjectId", entity.getOrgSubjectId());
                map.put("innerCode", entity.getInnerCode());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}
