package com.ejianc.business.cost.mapper;

import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.vo.CostClosingForecastChangeVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.CostClosingForecastChangeEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 成本关门预估变更
 *
 * @author generator
 *
 */
@Mapper
public interface CostClosingForecastChangeMapper extends BaseCrudMapper<CostClosingForecastChangeEntity> {

    CostClosingForecastChangeEntity selectByForecastId(Long id);

    @Select("select change_status from ejc_cost_closing_forecast where id = #{id}")
    String querysourcetype(@Param("id") Long id);

    @Select("select count(id) from ejc_cost_closing_forecast_change where dr = '0' and source_forecast_id = #{id}")
    Integer querychangetotal(@Param("id") Long id);

    @Select("select count(id) from ejc_cost_closing_forecast_change where dr = '0' and bill_state not IN (1, 3) and source_forecast_id = #{forecastId} and id != #{id} ")
    Integer countClosing(@Param("forecastId") Long forecastId,@Param("id") Long id);

    @Select("select count(id) from ejc_cost_closing_forecast_change where dr = '0' and bill_state not IN (1, 3) and source_forecast_id = #{forecastId} ")
    Integer countClosing1(@Param("forecastId") Long forecastId);

    @Select("select * from ejc_cost_closing_forecast_change where id IN (select MAX(id) id FROM ejc_cost_closing_forecast_change where dr = '0' GROUP BY project_id) ")
    List<CostClosingForecastChangeEntity> revenueExpenditureSummaryRealTime();


    @Select("select id from ejc_cost_closing_forecast_change where dr = '0' and project_id = #{projectId} ORDER BY create_time DESC LIMIT 1")
    Long queryId(@Param("projectId") Long projectId);
    @Select("select * from ejc_cost_closing_forecast_change where id IN (select MAX(id) id FROM ejc_cost_closing_forecast_change where dr = '0' and project_id = #{projectId}  GROUP BY project_id) ")
    CostClosingForecastEntity queryAllrealproject(@Param("projectId") Long projectId);

    Integer querysub(@Param("costtype") Long costtype,@Param("subjectId") Long subjectId,@Param("id") Long id);

    Integer querysubsour(@Param("costtype") Long costtype,@Param("subjectId") Long subjectId,@Param("id") Long id);

    @Select("select subject_name from ejc_cost_subject_project where id = #{subjectId}")
    String querysubname(@Param("subjectId") Long subjectId);

    @Select("select count(id) from ejc_cost_closing_forecast_change where dr = '0' and project_id = #{projectId}")
    Integer queryIdtotal(@Param("projectId") Long projectId);
}
