package com.ejianc.business.cost.mapper;

import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import com.ejianc.framework.core.response.Parameter;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 最终成本关门通知
 *
 * @author generator
 *
 */
@Mapper
public interface CostClosingLastMapper extends BaseCrudMapper<CostClosingLastEntity> {
    @Select("select * from ejc_cost_closing where project_id = #{id} and bill_state IN (1,3) and dr = '0'")
    CostClosingEntity getCostClosing(@Param("id") String id);

    @Select("select count(id) from ejc_cost_closing_last where dr = '0' and project_id = #{projectId}")
    Integer count(@Param("projectId") Long projectId);

    @Select("select count(id) from ejc_cost_closing_last where dr = '0' and project_id = #{projectId} and bill_state = '3'")
    Integer auditcount(@Param("projectId") Long projectId);

    List<CostClosingLastEntity> revenueExpenditureSummaryRealTime();

    List<CostClosingLastEntity> revenueExpenditureSummary();

    List<CostClosingLastEntity> lastRevenueExpenditureSummary();

    CostClosingLastEntity revenueExpenditureSummaryByProjectId(@Param("projectId") Long projectId);

    @Select("select * from ejc_cost_closing_last_change where dr = '0' and closing_last_id = #{id} order by create_time desc")
    List<CostClosingLastChangeEntity> querylastchangeList(@Param("id") Long id);

    Integer querytotal(@Param("projectId") Long projectId,@Param("id") Long id);


    @Select("select count(id) from ejc_cost_closing_last_change where dr = '0' and closing_last_id = #{id} and bill_state NOT IN (1,3)")
    Integer querychange(@Param("id") Long id);

    @Select("select count(id) from ejc_cost_fin_cost_summary_reporting where dr = '0' and project_id = #{projectId}")
    Integer querysum(@Param("projectId") Long projectId);

    @Select("select * from ejc_cost_closing_last where dr = '0' and contract_id = #{truecontract}")
    CostClosingLastEntity selectByPC(@Param("truecontract") Long truecontract);
}
