package com.ejianc.business.cost.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.cost.vo.report.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ReportMapper extends BaseCrudMapper<CostDetailEntity> {

    List<SubjectCostVO> subjectCostList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("countMonth") String countMonth);

    //获取本年月报产值与实际成本
    List<ProductionVersusCostCompanyVO> getThisYearProductionAndCost(Long tenantId, String countMonth);

    //查询本年月报产值
    //List<Map<String,Object>> getThisYearProduction(Long tenantId,String countMonth);

    //查询本年实际成本
    //List<Map<String,Object>> getThisYearCost(Long tenantId,String countMonth);

    List<ProjectProductionCostTwoVO> queryProjectProductionCostTwo(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("projectIds") List<Long> projectIds, @Param("tenantId") Long tenantId, @Param("countMonth") String countMonth);
    
    List<ProjectCostThreeVo> queryProjectCostThree(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("projectIds") List<Long> projectIds, @Param("tenantId") Long tenantId);

    List<ProductionVersusCostAccountingVO> getProductionVersusCostAccountingTree(Long tenantId, Long projectId , String countMonth);

    List<AccountingCostVO> accountingCostList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("countMonth") String countMonth);

    List<CostDetailVO> querySubjectCostList(@Param("yearFlag") Integer yearFlag, @Param("idsList") List<Long> idsList);


}
