package com.ejianc.business.cost.service;

import com.ejianc.business.cost.vo.CostFinCostSummaryReportingVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.CostFinCostSummaryReportingEntity;

import java.util.List;
import java.util.Map;

/**
 * 最终成本关门上报汇总
 *
 * @author generator
 *
 */
public interface ICostFinCostSummaryReportingService extends IBaseService<CostFinCostSummaryReportingEntity> {

    CommonResponse<CostFinCostSummaryReportingVO> insertOrUpdate(CostFinCostSummaryReportingVO saveOrUpdateVO);

    CostFinCostSummaryReportingVO queryDetail(Long id);

    void deleteDatas(List<CostFinCostSummaryReportingVO> vos);

    Map<String, Object> queryAccumulateProfitMargin(Long projectId);

    String checkContractAndSettlement(Long projectId);

    String addProjectCheck(Long projectId, Long id);

    CostFinCostSummaryReportingEntity querySubContractByProjectId(Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectIdMaterial(Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectIdMachine(Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectIdOther(Long projectId);
}
