package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.SubjectOrgEntity;
import com.ejianc.business.cost.service.IAccountingProjectService;
import com.ejianc.business.cost.vo.AccountingOrgVO;
import com.ejianc.business.cost.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.AccountingOrgMapper;
import com.ejianc.business.cost.bean.AccountingOrgEntity;
import com.ejianc.business.cost.service.IAccountingOrgService;

import java.util.ArrayList;
import java.util.List;

/**
 * 集团核算对象实体
 *
 * @author generator
 */
@Service("accountingOrgService")
public class AccountingOrgServiceImpl extends BaseServiceImpl<AccountingOrgMapper, AccountingOrgEntity> implements IAccountingOrgService {

    @Autowired
    private IAccountingProjectService accountingProjectService;

    @Override
    public CommonResponse<AccountingOrgVO> saveOrUpdate(AccountingOrgVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AccountingOrgEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
            Boolean flag = accountingProjectService.delRefCheck(ids);
            if (flag) {
                throw new BusinessException("存在被引用的核算对象，暂不允许编辑");
            }
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<AccountingOrgEntity> lambda = Wrappers.<AccountingOrgEntity>lambdaQuery();
            lambda.eq(AccountingOrgEntity::getAccountingCode, saveorUpdateVO.getAccountingCode());
            lambda.eq(AccountingOrgEntity::getTenantId, tenantId);
            lambda.ne(AccountingOrgEntity::getId, saveorUpdateVO.getId());
            List<AccountingOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, AccountingOrgEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            //校验合同编号是否重复
            LambdaQueryWrapper<AccountingOrgEntity> lambda = Wrappers.<AccountingOrgEntity>lambdaQuery();
            lambda.eq(AccountingOrgEntity::getTenantId, tenantId);
            lambda.eq(AccountingOrgEntity::getAccountingCode, saveorUpdateVO.getAccountingCode());
            List<AccountingOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, AccountingOrgEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                AccountingOrgEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public List<AccountingOrgVO> getChildrenByPid(Long id) {
        AccountingOrgEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<AccountingOrgEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, AccountingOrgVO.class);
    }

}
