package com.ejianc.business.cost.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.cost.vo.*;
import com.ejianc.business.cost.vo.comparator.ForecastContractDetailComparatoeVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 成本关门预估
 *
 * @author generator
 *
 */
@Service("costClosingForecastService")
public class CostClosingForecastServiceImpl extends BaseServiceImpl<CostClosingForecastMapper, CostClosingForecastEntity> implements ICostClosingForecastService{
    private static final String BILL_CODE_ROLE = "COST_CLOSING_FORECAST";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IForecastContractDetailService iForecastContractDetailService;

    @Autowired
    private IForecastOtherDetailService iForecastOtherDetailService;

    @Autowired
    private ICostClosingForecastService iCostClosingForecastService;

    @Autowired
    private ForecastOtherDetailMapper forecastOtherDetailMapper;

    @Autowired
    private ICostClosingForecastChangeService costClosingForecastChangeService;

    @Autowired
    private IForecastMaterialcontractDetailService forecastMaterialcontractDetailService;

    @Autowired
    private IForecastMachinecontractDetailService forecastMachinecontractDetailService;

    @Autowired
    private IForecastOthercontractDetailService forecastOthercontractDetailService;

    @Autowired
    private ForecastMaterialcontractDetailMapper forecastMaterialcontractDetailMapper;

    @Autowired
    private ForecastMachinecontractDetailMapper forecastMachinecontractDetailMapper;

    @Autowired
    private ForecastOthercontractDetailMapper forecastOthercontractDetailMapper;

    @Autowired
    private CostClosingForecastMapper costClosingForecastMapper;

    @Autowired
    private CostClosingForecastChangeMapper costClosingForecastChangeMapper;

    @Autowired
    private ForecastContractDetailMapper forecastContractDetailMapper;

    @Autowired
    private CostClosingLastMapper costClosingLastMapper;

    @Override
    public CommonResponse<CostClosingForecastVO> insertOrUpdate(CostClosingForecastVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostClosingForecastEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setChangeStatusName("未变更");
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, CostClosingForecastEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(saveorUpdateVO.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE,tenantId);
                if(billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(saveorUpdateVO, CostClosingForecastEntity.class);
            operateType = "add";
        }
        if( operateType == "add") {

            LambdaQueryWrapper<CostClosingForecastEntity> lambda2 = Wrappers.<CostClosingForecastEntity>lambdaQuery();
            lambda2.eq(CostClosingForecastEntity::getProjectId, saveorUpdateVO.getProjectId());
            lambda2.eq(CostClosingForecastEntity::getTenantId, tenantId);
            lambda2.notIn(CostClosingForecastEntity::getBillState, 1,3);
            List<CostClosingForecastEntity> entities2 = super.list(lambda2);
            if(entities2 != null && entities2.size() > 0) {
                throw new BusinessException("该项目存在未审核完毕的成本关门预估单，不允许保存!");
            }
        }
        super.saveOrUpdate(entity);
        List<ForecastContractDetailVO> detailsVos = saveorUpdateVO.getForecastContractDetailList();
        List<ForecastContractDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(ForecastContractDetailVO detailsVo:detailsVos) {
            if("add".equals(detailsVo.getRowState())) {
                ForecastContractDetailEntity detailslist = BeanMapper.map(detailsVo, ForecastContractDetailEntity.class);
                detailslist.setCostClosingForecastId(entity.getId());
                saveOrUpldates.add(detailslist);
            }else if("edit".equals(detailsVo.getRowState())) {
                ForecastContractDetailEntity detailslist = BeanMapper.map(detailsVo, ForecastContractDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        List<ForecastOtherDetailVO> otherdetailsVos = saveorUpdateVO.getForecastOtherDetailList();
        List<ForecastOtherDetailEntity> othersaveOrUpldates = new ArrayList<>();
        List<Long> otherdeleteIds = new ArrayList<>();
        for(ForecastOtherDetailVO otherdetailsVo:otherdetailsVos) {
//            otherdetailsVo.setSubjectId(Long.parseLong(otherdetailsVo.getSubjectName()));
            if("add".equals(otherdetailsVo.getRowState())) {
                int a = 0;
                for(ForecastOtherDetailVO forecastOtherDetailVO:otherdetailsVos) {
//                    forecastOtherDetailVO.setSubjectId(Long.parseLong(forecastOtherDetailVO.getSubjectName()));
                    if(forecastOtherDetailVO.getSubjectId().equals(otherdetailsVo.getSubjectId())){
                        a++;
                        if(a>1){
                            String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
                            throw new BusinessException("成本科目"+name+"出现重复，不允许保存!");
                        }
                    }
                }
                Long id = otherdetailsVo.getId();
                Long subjectId = otherdetailsVo.getSubjectId();
                Long projectId = saveorUpdateVO.getProjectId();
                Integer to = forecastOtherDetailMapper.queryold(subjectId,projectId,id);
                if(to != 0) {
                    String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
                    throw new BusinessException("成本科目"+name+"已进行过成本关门预估，不允许保存!");
                }

                ForecastOtherDetailEntity otherdetailslist = BeanMapper.map(otherdetailsVo, ForecastOtherDetailEntity.class);
                otherdetailslist.setCostClosingForecastId(entity.getId());
                othersaveOrUpldates.add(otherdetailslist);
            }else if("edit".equals(otherdetailsVo.getRowState())) {
                int a = 0;
                for(ForecastOtherDetailVO forecastOtherDetailVO:otherdetailsVos) {
//                    forecastOtherDetailVO.setSubjectId(Long.parseLong(forecastOtherDetailVO.getSubjectName()));
                    if(forecastOtherDetailVO.getSubjectId().equals(otherdetailsVo.getSubjectId())){
                        a++;
                        if(a>1) {
                            String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
                            throw new BusinessException("成本科目" + name + "出现重复，不允许保存!");
                        }
                    }
                }
                Long detailid = otherdetailsVo.getId();
                Integer total = forecastOtherDetailMapper.queryoldexid(otherdetailsVo.getSubjectId(),saveorUpdateVO.getProjectId(),saveorUpdateVO.getId(),detailid);
                if(total != 0) {
                    String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
                    throw new BusinessException("成本科目"+name+"已进行过成本关门预估，不允许保存!");
                }
                ForecastOtherDetailEntity otherdetailslist = BeanMapper.map(otherdetailsVo, ForecastOtherDetailEntity.class);
                othersaveOrUpldates.add(otherdetailslist);
            } else if("del".equals(otherdetailsVo.getRowState())) {
                otherdeleteIds.add(otherdetailsVo.getId());
            }
        }
        List<ForecastMaterialcontractDetailEntity> materialsaveOrUpldates = new ArrayList<>();
        List<ForecastMachinecontractDetailEntity> machinesaveOrUpldates = new ArrayList<>();
        List<ForecastOthercontractDetailEntity> othsaveOrUpldates = new ArrayList<>();
        if(operateType == "add") {
            List<ForecastMaterialcontractDetailVO> resultList = iForecastContractDetailService.querySubContractByProjectIdMaterial(String.valueOf(saveorUpdateVO.getProjectId()));

            for(ForecastMaterialcontractDetailVO matdetailsVo:resultList) {
                ForecastMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastMaterialcontractDetailEntity.class);
                detailslist.setCostClosingForecastId(entity.getId());
                materialsaveOrUpldates.add(detailslist);
            }

            List<ForecastMachinecontractDetailVO> resultListmac = iForecastContractDetailService.querySubContractByProjectIdMachine(String.valueOf(saveorUpdateVO.getProjectId()));

            for(ForecastMachinecontractDetailVO macdetailsVo:resultListmac) {
                ForecastMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastMachinecontractDetailEntity.class);
                detailslist.setCostClosingForecastId(entity.getId());
                machinesaveOrUpldates.add(detailslist);
            }

            List<ForecastOthercontractDetailVO> resultListoth = iForecastContractDetailService.querySubContractByProjectIdOther(String.valueOf(saveorUpdateVO.getProjectId()));

            for(ForecastOthercontractDetailVO othdetailsVo:resultListoth) {
                ForecastOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastOthercontractDetailEntity.class);
                detailslist.setCostClosingForecastId(entity.getId());
                othsaveOrUpldates.add(detailslist);
            }
        }
        Long oldid = saveorUpdateVO.getId();
        Long projectold = saveorUpdateVO.getProjectId();
        if(operateType == "edit") {

            List<ForecastMaterialcontractDetailVO> resultList = iForecastContractDetailService.querySubContractByProjectIdMaterial(String.valueOf(saveorUpdateVO.getProjectId()));
            List<ForecastMaterialcontractDetailEntity> oldmatdata = forecastMaterialcontractDetailMapper.queryByIdMaterial(projectold);
            List<ForecastMaterialcontractDetailVO> oldmatdatavo = BeanMapper.mapList(oldmatdata, ForecastMaterialcontractDetailVO.class);
            List<Long> matidlist = forecastMaterialcontractDetailMapper.querySubContractIdByProjectIdMaterial(String.valueOf(saveorUpdateVO.getProjectId()));
            List<Long> matoldlist = forecastMaterialcontractDetailMapper.queryByIdMatId(oldid);


            for(ForecastMaterialcontractDetailVO matdetailsVo:resultList) {
                int a = 1;
                for(ForecastMaterialcontractDetailVO old : oldmatdatavo){
                    if(old.getContractId().equals(matdetailsVo.getContractId())){
//                        ForecastMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastMaterialcontractDetailEntity.class);
//                        detailslist.setCostClosingForecastId(old.getId());
//                        detailslist.setId(old.getId());
//                        forecastMaterialcontractDetailMapper.updateById(detailslist);

//                        materialsaveOrUpldates.add(detailslist);
                        ForecastMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastMaterialcontractDetailEntity.class);
                        ForecastMaterialcontractDetailEntity oldothlist = BeanMapper.map(old, ForecastMaterialcontractDetailEntity.class);

                        LambdaUpdateWrapper<ForecastMaterialcontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getContractType, detailslist.getContractType());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getContractAmount, detailslist.getContractAmount());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getContractCode, detailslist.getContractCode());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getContractName, detailslist.getContractName());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getTaxRate, detailslist.getTaxRate());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getSubOrg, detailslist.getSubOrg());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getSubOrgId, detailslist.getSubOrgId());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getAmountSettled, detailslist.getAmountSettled());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getAmountSettledNotax, detailslist.getAmountSettledNotax());
                        updateWrapperot.set(ForecastMaterialcontractDetailEntity::getAmountSettledTax, detailslist.getAmountSettledTax());
                        updateWrapperot.eq(ForecastMaterialcontractDetailEntity::getContractId,oldothlist.getContractId());

                        forecastMaterialcontractDetailService.update(updateWrapperot);

                        a++;
                    }
                }
                if(a == 1){
                    ForecastMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastMaterialcontractDetailEntity.class);
                    detailslist.setCostClosingForecastId(entity.getId());
                    materialsaveOrUpldates.add(detailslist);
                }
            }
            for(Long matoldid :matoldlist){
                int ol = 1;
                for(Long matnewid :matidlist){
                    if(matoldid.equals(matnewid)){
                        ol++;
                    }
                }
                if(ol == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<ForecastMaterialcontractDetailEntity> updateWrappermat = new LambdaUpdateWrapper<>();
                    updateWrappermat.set(ForecastMaterialcontractDetailEntity::getDr, '1');
                    updateWrappermat.eq(ForecastMaterialcontractDetailEntity::getContractId,matoldid);

                    forecastMaterialcontractDetailService.update(updateWrappermat);
                }
            }

            List<ForecastMachinecontractDetailVO> resultListmac = iForecastContractDetailService.querySubContractByProjectIdMachine(String.valueOf(saveorUpdateVO.getProjectId()));
            List<ForecastMachinecontractDetailEntity> oldmacdata = forecastMachinecontractDetailMapper.queryByIdMachine(projectold);
            List<ForecastMachinecontractDetailVO> oldmacdatavo = BeanMapper.mapList(oldmacdata, ForecastMachinecontractDetailVO.class);
            List<Long> macidlist = forecastMachinecontractDetailMapper.querySubContractIdByProjectIdMachine(String.valueOf(saveorUpdateVO.getProjectId()));
            List<Long> macoldlist = forecastMachinecontractDetailMapper.queryByIdMacId(oldid);

            for(ForecastMachinecontractDetailVO macdetailsVo:resultListmac) {
                int b = 1;
                for(ForecastMachinecontractDetailVO oldmac:oldmacdatavo){
                    if(oldmac.getContractId().equals(macdetailsVo.getContractId())){
//                        ForecastMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastMachinecontractDetailEntity.class);
//                        detailslist.setCostClosingForecastId(oldmac.getId());
//                        detailslist.setId(oldmac.getId());
//                        forecastMachinecontractDetailMapper.updateById(detailslist);

                        ForecastMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastMachinecontractDetailEntity.class);
                        ForecastMachinecontractDetailEntity oldothlist = BeanMapper.map(oldmac, ForecastMachinecontractDetailEntity.class);

                        LambdaUpdateWrapper<ForecastMachinecontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getContractType, detailslist.getContractType());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getContractAmount, detailslist.getContractAmount());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getContractCode, detailslist.getContractCode());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getContractName, detailslist.getContractName());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getTaxRate, detailslist.getTaxRate());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getSubOrg, detailslist.getSubOrg());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getSubOrgId, detailslist.getSubOrgId());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getAmountSettled, detailslist.getAmountSettled());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getAmountSettledNotax, detailslist.getAmountSettledNotax());
                        updateWrapperot.set(ForecastMachinecontractDetailEntity::getAmountSettledTax, detailslist.getAmountSettledTax());
                        updateWrapperot.eq(ForecastMachinecontractDetailEntity::getContractId,oldothlist.getContractId());

                        forecastMachinecontractDetailService.update(updateWrapperot);

//                        machinesaveOrUpldates.add(detailslist);
                        b++;
                    }
                }
                if(b == 1){
                    ForecastMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastMachinecontractDetailEntity.class);
                    detailslist.setCostClosingForecastId(entity.getId());
                    machinesaveOrUpldates.add(detailslist);
                }
            }
            for(Long macoldid :macoldlist){
                int olm = 1;
                for(Long macnewid :macidlist){
                    if(macoldid.equals(macnewid)){
                        olm++;
                    }
                }
                if(olm == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<ForecastMachinecontractDetailEntity> updateWrappermc = new LambdaUpdateWrapper<>();
                    updateWrappermc.set(ForecastMachinecontractDetailEntity::getDr, '1');
                    updateWrappermc.eq(ForecastMachinecontractDetailEntity::getContractId,macoldid);

                    forecastMachinecontractDetailService.update(updateWrappermc);
                }
            }

            //查询合同表
            List<ForecastOthercontractDetailVO> resultListoth = iForecastContractDetailService.querySubContractByProjectIdOther(String.valueOf(saveorUpdateVO.getProjectId()));
            //查预估原单
            List<ForecastOthercontractDetailEntity> oldothdata = forecastOthercontractDetailMapper.queryBytIdOther(projectold);
            List<ForecastOthercontractDetailVO> oldothdatavo = BeanMapper.mapList(oldothdata, ForecastOthercontractDetailVO.class);

            List<Long> othidlist = forecastOthercontractDetailMapper.querySubContractIdByProjectIdOther(String.valueOf(saveorUpdateVO.getProjectId()));
            List<Long> otholdlist = forecastOthercontractDetailMapper.queryByIdOtherId(oldid);

            //遍历查询到的合同全部数据
            for(ForecastOthercontractDetailVO othdetailsVo:resultListoth) {
                int c = 1;
                //遍历查询到的预估原单
                for(ForecastOthercontractDetailVO oldoth:oldothdatavo){
                    //如果id相等，即预估单已有改合同
                    if(oldoth.getContractId().equals(othdetailsVo.getContractId())){
                        ForecastOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastOthercontractDetailEntity.class);
                        ForecastOthercontractDetailEntity oldothlist = BeanMapper.map(oldoth, ForecastOthercontractDetailEntity.class);
////                        detailslist.setCostClosingForecastId(oldoth.getId());
////                        detailslist.setId(oldoth.getId());
//
//                        oldothlist.setContractAmount(detailslist.getContractAmount());
//                        oldothlist.setContractCode(detailslist.getContractCode());
//                        oldothlist.setContractName(detailslist.getContractName());
//                        oldothlist.setTaxRate(detailslist.getTaxRate());
//                        oldothlist.setSubOrg(detailslist.getSubOrg());
//                        oldothlist.setSubOrgId(detailslist.getSubOrgId());
//                        oldothlist.setAmountSettled(detailslist.getAmountSettled());
//                        oldothlist.setAmountSettledNotax(detailslist.getAmountSettledNotax());
//                        oldothlist.setAmountSettledTax(detailslist.getAmountSettledTax());
//
//                        forecastOthercontractDetailMapper.updateById(oldothlist);

                        LambdaUpdateWrapper<ForecastOthercontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getContractAmount, detailslist.getContractAmount());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getContractCode, detailslist.getContractCode());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getContractName, detailslist.getContractName());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getTaxRate, detailslist.getTaxRate());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getSubOrg, detailslist.getSubOrg());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getSubOrgId, detailslist.getSubOrgId());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getAmountSettled, detailslist.getAmountSettled());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getAmountSettledNotax, detailslist.getAmountSettledNotax());
                        updateWrapperot.set(ForecastOthercontractDetailEntity::getAmountSettledTax, detailslist.getAmountSettledTax());
                        updateWrapperot.eq(ForecastOthercontractDetailEntity::getContractId,oldothlist.getContractId());

                        forecastOthercontractDetailService.update(updateWrapperot);

//                        LambdaQueryWrapper<ForecastOthercontractDetailEntity> updateWrapperotdd = new LambdaQueryWrapper<>();
//                        updateWrapperotdd.eq(ForecastOthercontractDetailEntity::getId,oldoth.getId());
//
//                        forecastOthercontractDetailMapper.update(detailslist,updateWrapperotdd);
//                        othsaveOrUpldates.add(detailslist);
                        c++;
                    }
                }
                if(c == 1){
                    ForecastOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastOthercontractDetailEntity.class);
                    detailslist.setCostClosingForecastId(entity.getId());
                    othsaveOrUpldates.add(detailslist);
                }
            }
            for(Long otholdid :otholdlist){
                int othc = 1;
                for(Long othnewid :othidlist){
                    if(otholdid.equals(othnewid)){
                        othc++;
                    }
                }
                if(othc == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<ForecastOthercontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                    updateWrapperot.set(ForecastOthercontractDetailEntity::getDr, '1');
                    updateWrapperot.eq(ForecastOthercontractDetailEntity::getContractId,otholdid);

                    forecastOthercontractDetailService.update(updateWrapperot);
                }
            }
        }

        if(saveOrUpldates.size() > 0) {
            iForecastContractDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if(othersaveOrUpldates.size() >0){
            iForecastOtherDetailService.saveOrUpdateBatch(othersaveOrUpldates,othersaveOrUpldates.size(),false);
        }
        if(deleteIds.size() > 0) {
            iForecastContractDetailService.removeByIds(deleteIds, false);
        }
        if(otherdeleteIds.size() > 0) {
            iForecastOtherDetailService.removeByIds(otherdeleteIds, false);
        }
//        if(operateType == "add") {
            if(materialsaveOrUpldates.size()>0){
                forecastMaterialcontractDetailService.saveOrUpdateBatch(materialsaveOrUpldates,materialsaveOrUpldates.size(),false);
            }
            if(machinesaveOrUpldates.size()>0){
                forecastMachinecontractDetailService.saveOrUpdateBatch(machinesaveOrUpldates,machinesaveOrUpldates.size(),false);
            }
            if(othsaveOrUpldates.size()>0){
                forecastOthercontractDetailService.saveOrUpdateBatch(othsaveOrUpldates,othsaveOrUpldates.size(),false);
            }
//        }


        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public CostClosingForecastVO queryDetail(Long id) {
        CostClosingForecastEntity entity = this.baseMapper.selectById(id);
        if(entity != null) {
            CostClosingForecastVO contractVo = BeanMapper.map(entity, CostClosingForecastVO.class);
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));

            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("cost_closing_forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));
            queryParam2.getParams().put("dr",new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));

            List<ForecastContractDetailEntity> purchaseDetailss = iForecastContractDetailService.queryList(queryParam2, false);
            List<ForecastOtherDetailEntity> forecastOtherDetailEntities = iForecastOtherDetailService.queryList(queryParam2,false);
            List<ForecastMaterialcontractDetailEntity> forecastOtherDetailChangeEntities = forecastMaterialcontractDetailService.queryList(queryParam2,false);

            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                List<ForecastContractDetailVO> resultMapList = BeanMapper.mapList(purchaseDetailss, ForecastContractDetailVO.class);
                contractVo.setForecastContractDetailList(resultMapList);
            }
            if(forecastOtherDetailEntities != null && forecastOtherDetailEntities.size() > 0) {
                List<ForecastOtherDetailVO> resultMapList2 = BeanMapper.mapList(forecastOtherDetailEntities, ForecastOtherDetailVO.class);
                contractVo.setForecastOtherDetailList(resultMapList2);
            }
            if(forecastOtherDetailChangeEntities != null && forecastOtherDetailChangeEntities.size() > 0) {
                List<ForecastMaterialcontractDetailVO> resultMapList3 = BeanMapper.mapList(forecastOtherDetailChangeEntities, ForecastMaterialcontractDetailVO.class);
            }


            return contractVo;
        }
        return null;
    }

    @Override
    public CostClosingForecastVO queryDetailMobile(Long id) {
        CostClosingForecastEntity entity = this.baseMapper.selectById(id);
        if(entity != null) {
            CostClosingForecastVO contractVo = BeanMapper.map(entity, CostClosingForecastVO.class);
            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("cost_closing_forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));
            queryParam2.getParams().put("dr",new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));

            List<ForecastContractDetailEntity> purchaseDetailss = iForecastContractDetailService.queryList(queryParam2, false);
            List<ForecastOtherDetailEntity> forecastOtherDetailEntities = iForecastOtherDetailService.queryList(queryParam2,false);
            List<ForecastMaterialcontractDetailEntity> forecastMaterialcontractDetailList = forecastMaterialcontractDetailService.queryList(queryParam2,false);
            List<ForecastMachinecontractDetailEntity> forecastMachinecontractDetailList = forecastMachinecontractDetailService.queryList(queryParam2,false);
            List<ForecastOthercontractDetailEntity> forecastOthercontractDetailList = forecastOthercontractDetailService.queryList(queryParam2,false);

            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                List<ForecastContractDetailVO> resultMapList = BeanMapper.mapList(purchaseDetailss, ForecastContractDetailVO.class);
                contractVo.setForecastContractDetailList(resultMapList);
            }
            if(forecastOtherDetailEntities != null && forecastOtherDetailEntities.size() > 0) {
                List<ForecastOtherDetailVO> resultMapList2 = BeanMapper.mapList(forecastOtherDetailEntities, ForecastOtherDetailVO.class);
                contractVo.setForecastOtherDetailList(resultMapList2);
            }
            if(forecastMaterialcontractDetailList != null && forecastMaterialcontractDetailList.size() > 0) {
                List<ForecastMaterialcontractDetailVO> resultMapList3 = BeanMapper.mapList(forecastMaterialcontractDetailList, ForecastMaterialcontractDetailVO.class);
                contractVo.setForecastMaterialcontractDetailList(resultMapList3);
            }
            if(forecastMachinecontractDetailList != null && forecastMachinecontractDetailList.size() > 0) {
                List<ForecastMachinecontractDetailVO> resultMapList4 = BeanMapper.mapList(forecastMachinecontractDetailList, ForecastMachinecontractDetailVO.class);
                contractVo.setForecastMachinecontractDetailList(resultMapList4);
            }
            if(forecastMaterialcontractDetailList != null && forecastMaterialcontractDetailList.size() > 0) {
                List<ForecastOthercontractDetailVO> resultMapList5 = BeanMapper.mapList(forecastOthercontractDetailList, ForecastOthercontractDetailVO.class);
                contractVo.setForecastOthercontractDetailList(resultMapList5);
            }


            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteDatas(List<CostClosingForecastVO> vos) {
        for(CostClosingForecastVO vo : vos){
            Long id = vo.getId();//获取主表id
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("forecast_id", new Parameter(QueryParam.EQ, id));

            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("cost_closing_forecast_id", new Parameter(QueryParam.EQ, id));
            List<ForecastContractDetailEntity> forecastContractDetails = iForecastContractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastContractDetailEntity> ceupdate = new LambdaUpdateWrapper<>();
            ceupdate.set(ForecastContractDetailEntity::getDr,'1');

            List<ForecastOtherDetailEntity> forecastOtherDetailEntities = iForecastOtherDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastOtherDetailEntity> oeupdate = new LambdaUpdateWrapper<>();
            oeupdate.set(ForecastOtherDetailEntity::getDr,'1');

            List<ForecastMaterialcontractDetailEntity> forecastMaterialcontractDetailEntities = forecastMaterialcontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastMaterialcontractDetailEntity> meupdate = new LambdaUpdateWrapper<>();
            meupdate.set(ForecastMaterialcontractDetailEntity::getDr,'1');

            List<ForecastMachinecontractDetailEntity> forecastMachinecontractDetailEntities = forecastMachinecontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastMachinecontractDetailEntity> maupdate = new LambdaUpdateWrapper<>();
            maupdate.set(ForecastMachinecontractDetailEntity::getDr,'1');

            List<ForecastOthercontractDetailEntity> forecastOthercontractDetailEntities = forecastOthercontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastOthercontractDetailEntity> ocupdate = new LambdaUpdateWrapper<>();
            ocupdate.set(ForecastOthercontractDetailEntity::getDr,'1');

            LambdaUpdateWrapper<CostClosingForecastEntity> zhu = new LambdaUpdateWrapper<>();
            zhu.set(CostClosingForecastEntity::getDr,'1');
            zhu.eq(CostClosingForecastEntity::getId,id);
            iCostClosingForecastService.update(zhu);

            if(!forecastContractDetails.isEmpty()){
                ceupdate.eq(ForecastContractDetailEntity::getCostClosingForecastId,id);
                iForecastContractDetailService.update(ceupdate);
            }
            if(!forecastOtherDetailEntities.isEmpty()){
                oeupdate.eq(ForecastOtherDetailEntity::getCostClosingForecastId,id);
                iForecastOtherDetailService.update(oeupdate);
            }
            if(!forecastMaterialcontractDetailEntities.isEmpty()){
                meupdate.eq(ForecastMaterialcontractDetailEntity::getCostClosingForecastId,id);
                forecastMaterialcontractDetailService.update(meupdate);
            }
            if(!forecastMachinecontractDetailEntities.isEmpty()){
                maupdate.eq(ForecastMachinecontractDetailEntity::getCostClosingForecastId,id);
                forecastMachinecontractDetailService.update(maupdate);
            }
            if(!forecastOthercontractDetailEntities.isEmpty()){
                ocupdate.eq(ForecastOthercontractDetailEntity::getCostClosingForecastId,id);
                forecastOthercontractDetailService.update(ocupdate);
            }

        }
    }

    @Override
    public CostClosingForecastVO queryDetailRecord(Long id) {
        CostClosingForecastEntity costClosingEntity = this.baseMapper.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("source_forecast_id", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        List<CostClosingForecastChangeEntity> purchaseDetailss = costClosingForecastChangeService.queryList(queryParam, false);
        List<CostClosingForecastChangeVO> costClosingChangesList = BeanMapper.mapList(purchaseDetailss, CostClosingForecastChangeVO.class);
        CostClosingForecastVO vo = BeanMapper.map(costClosingEntity, CostClosingForecastVO.class);
        vo.setChangeSub(this.baseMapper.querychangesub(id));
        vo.setChangeSubNotax(this.baseMapper.querychangesubnotax(id));
        vo.setChangeSubTax(this.baseMapper.querychangesubtax(id));
        vo.setChangeOther(this.baseMapper.querychangeother(id));
        vo.setChangeOtherNotax(this.baseMapper.querychangeothernotax(id));
        vo.setChangeOtherTax(this.baseMapper.querychangeothertax(id));
        vo.setCostClosingChanges(costClosingChangesList);
        return vo;
    }

    @Override
    public Map<String, Object> queryMoney(Long projectId) {
        Map<String,Object> map = this.baseMapper.queryMoney(projectId);
//        Map<String,Object> sumSettleTaxMnyMap = this.baseMapper.querySumSettleTaxMny(projectId);

        BigDecimal totalSettleMoney = forecastOtherDetailMapper.queryPaymnybyprojectId1c(projectId);

        //材料费查询结果
        List<ForecastMaterialcontractDetailEntity> forecastContractDetailEntityListcl = forecastContractDetailMapper.querySubContractByProjectIdMaterial(String.valueOf(projectId));

        for(ForecastMaterialcontractDetailEntity cl:forecastContractDetailEntityListcl){
            totalSettleMoney = totalSettleMoney.add(cl.getAmountSettledNotax());
        }

        //机械费查询结果
        List<ForecastMachinecontractDetailEntity> forecastContractDetailEntityListjx = forecastContractDetailMapper.querySubContractByProjectIdMachine(String.valueOf(projectId));

        for(ForecastMachinecontractDetailEntity jx:forecastContractDetailEntityListjx){
            totalSettleMoney = totalSettleMoney.add(jx.getAmountSettledNotax());
        }

        //其他合同费查询结果
        List<ForecastOthercontractDetailEntity> forecastContractDetailEntityListqtht = forecastContractDetailMapper.querySubContractByProjectIdOther(String.valueOf(projectId));

        for(ForecastOthercontractDetailEntity qt:forecastContractDetailEntityListqtht){
            totalSettleMoney = totalSettleMoney.add(qt.getAmountSettledNotax());
        }

        String contractIds = null;
        //分包
        List<ForecastContractDetailEntity> forecastContractDetailEntityList = forecastContractDetailMapper.querySubContractByProjectId(String.valueOf(projectId),contractIds);
        for(int a = 0;a<forecastContractDetailEntityList.size();a++){
            ForecastContractDetailEntity forecastContractDetailEntity = forecastContractDetailEntityList.get(a);
            Long contractId = forecastContractDetailEntity.getContractId();
            Integer finishcount = forecastContractDetailMapper.querySubFinish(contractId);
            Integer finishcostcount = forecastContractDetailMapper.queryCostFinish(String.valueOf(projectId));
            if(finishcount != 0 || finishcostcount != 0){
                forecastContractDetailEntity.setIsend("Y");
            }else{
                forecastContractDetailEntity.setIsend("N");
            }
            forecastContractDetailEntityList.set(a,forecastContractDetailEntity);
        }

        for(ForecastContractDetailEntity sub:forecastContractDetailEntityList){
            totalSettleMoney = totalSettleMoney.add(sub.getAmountSettledNotax());
        }

        map.put("profitMargin",totalSettleMoney);
        return map;
    }

    @Override
    public String addProjectCheck(Long projectId,Long id) {
        String message = "";
        Integer total = this.baseMapper.querytotal(projectId,id);
        if(total != 0) {
            message ="该项目已经存在成本关门预估单！";
        }
        Integer totalsum = this.baseMapper.querysumtotal(projectId);
        if(totalsum != 0) {
            message ="该项目已制作最终成本关门上报汇总单，禁止录入预估单！";
        }
        return message;
    }

    @Override
    public String checkContractAndSettlement(Long projectId) {
        StringBuffer message = new StringBuffer();
        List<Map<String,String>> sublist = this.baseMapper.querySub(projectId);
        List<Map<String,String>> subbcbglist = this.baseMapper.querySubbcbg(projectId);
        List<Map<String,String>> subsettlelist = this.baseMapper.querySubsettle(projectId);
        boolean isAdded = false;
        boolean isAddbcbged = false;
        boolean isAddsettle = false;
        boolean isAddrmat = false;
        boolean isAddbcbgrmat = false;
        boolean isAddmaterial = false;
        boolean isAddbcbgmaterial = false;
        boolean isAddsebeicg = false;
        boolean isAddbcbgsebeicg = false;
        boolean isAddsebeizl = false;
        boolean isAddbcbgsebeizl = false;
        boolean isAddother = false;
        boolean isAddbcbgother = false;
        if(sublist != null && sublist.size()>0){
            for (Map<String,String> sub:sublist
            ) {
                if (!isAdded) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(sub.get("flag")) && StringUtils.isNotEmpty(sub.get("contract_id"))) {
                        message.append("分包合同、分包结算、");
                        isAdded = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sub.get("flag")) && StringUtils.isEmpty(sub.get("contract_id"))) {
                        message.append("分包合同、");
                        isAdded = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sub.get("contract_id")) && StringUtils.isEmpty(sub.get("flag"))) {
                        message.append("分包完工结算、");
                        isAdded = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(subbcbglist != null && subbcbglist.size()>0){
            for (Map<String,String> subbcbg:subbcbglist
            ) {
                if (!isAddbcbged) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(subbcbg.get("flag")) && StringUtils.isNotEmpty(subbcbg.get("contract_id"))) {
                        message.append("分包合同变更、分包合同补充协议、");
                        isAddbcbged = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(subbcbg.get("flag")) && StringUtils.isEmpty(subbcbg.get("contract_id"))) {
                        message.append("分包合同补充协议、");
                        isAddbcbged = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(subbcbg.get("contract_id")) && StringUtils.isEmpty(subbcbg.get("flag"))) {
                        message.append("分包合同变更、");
                        isAddbcbged = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(subsettlelist != null && subsettlelist.size()>0){
            for (Map<String,String> subsettle:subsettlelist
            ) {
                if (!isAddsettle) { // 只有在未添加过message时，才进行条件判断
                    if(subsettle.get("contract_id") != null){
                        String subcontractid = String.valueOf(subsettle.get("contract_id"));
                        if (StringUtils.isNotEmpty(subcontractid) && StringUtils.isEmpty(subsettle.get("flag"))) {
                            message.append("分包进度结算、");
                            isAddsettle = true; // 添加后标记为已添加
                        }
                    }
                }
            }
        }


        List<Map<String,String>> rmatlist = this.baseMapper.queryRmat(projectId);
        List<Map<String,String>> rmatbcbglist = this.baseMapper.querybcbgRmat(projectId);
        if(rmatlist != null && rmatlist.size()>0){
            for (Map<String,String> rmat:rmatlist
            ) {
                if (!isAddrmat) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(rmat.get("flag")) && StringUtils.isNotEmpty(rmat.get("contract_id"))) {
                        message.append("周转材合同、周转材合同结算、");
                        isAddrmat = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(rmat.get("flag")) && StringUtils.isEmpty(rmat.get("contract_id"))) {
                        message.append("周转材合同、");
                        isAddrmat = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(rmat.get("contract_id")) && StringUtils.isEmpty(rmat.get("flag"))) {
                        message.append("周转材合同结算、");
                        isAddrmat = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(rmatbcbglist != null && rmatbcbglist.size()>0){
            for (Map<String,String> rmatbcbg:rmatbcbglist
            ) {
                if (!isAddbcbgrmat) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(rmatbcbg.get("flag")) && StringUtils.isNotEmpty(rmatbcbg.get("contract_id"))) {
                        message.append("周转材合同变更、周转材合同补充协议、");
                        isAddbcbgrmat = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(rmatbcbg.get("flag")) && StringUtils.isEmpty(rmatbcbg.get("contract_id"))) {
                        message.append("周转材合同变更、");
                        isAddbcbgrmat = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(rmatbcbg.get("contract_id")) && StringUtils.isEmpty(rmatbcbg.get("flag"))) {
                        message.append("周转材合同补充协议、");
                        isAddbcbgrmat = true; // 添加后标记为已添加
                    }
                }
            }
        }


        List<Map<String,String>> materialList = this.baseMapper.queryMaterial(projectId);
        List<Map<String,String>> materialbcbgList = this.baseMapper.queryMaterialbcbg(projectId);

        if(materialList != null && materialList.size()>0) {
            for (Map<String, String> material : materialList
            ) {
                if (!isAddmaterial) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(material.get("flag")) && StringUtils.isNotEmpty(material.get("contract_id"))) {
                        message.append("物资合同、物资合同结算、");
                        isAddmaterial = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(material.get("flag")) && StringUtils.isEmpty(material.get("contract_id"))) {
                        message.append("物资合同、");
                        isAddmaterial = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(material.get("contract_id")) && StringUtils.isEmpty(material.get("flag"))) {
                        message.append("物资合同结算、");
                        isAddmaterial = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(materialbcbgList != null && materialbcbgList.size()>0){
            for (Map<String,String> materialbcbg:materialbcbgList
            ) {
                if (!isAddbcbgmaterial) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(materialbcbg.get("flag")) && StringUtils.isNotEmpty(materialbcbg.get("contract_id"))) {
                        message.append("物资合同变更、物资合同补充协议、");
                        isAddbcbgmaterial = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(materialbcbg.get("flag")) && StringUtils.isEmpty(materialbcbg.get("contract_id"))) {
                        message.append("物资合同变更、");
                        isAddbcbgmaterial = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(materialbcbg.get("contract_id")) && StringUtils.isEmpty(materialbcbg.get("flag"))) {
                        message.append("物资合同补充协议、");
                        isAddbcbgmaterial = true; // 添加后标记为已添加
                    }
                }
            }
        }

        List<Map<String,String>> sebeicglist = this.baseMapper.querySebeicg(projectId);
        List<Map<String,String>> sebeicgbcbglist = this.baseMapper.querySebeicgbcbg(projectId);

        if(sebeicglist != null && sebeicglist.size()>0) {
            for (Map<String, String> sebeicg : sebeicglist
            ) {
                if (!isAddsebeicg) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(sebeicg.get("flag")) && StringUtils.isNotEmpty(sebeicg.get("contract_id"))) {
                        message.append("设备采购合同、设备采购合同结算、");
                        isAddsebeicg = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeicg.get("flag")) && StringUtils.isEmpty(sebeicg.get("contract_id"))) {
                        message.append("设备采购合同、");
                        isAddsebeicg = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeicg.get("contract_id")) && StringUtils.isEmpty(sebeicg.get("flag"))) {
                        message.append("设备采购合同结算、");
                        isAddsebeicg = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(sebeicgbcbglist != null && sebeicgbcbglist.size()>0){
            for (Map<String,String> sebeicgbcbg:sebeicgbcbglist
            ) {
                if (!isAddbcbgsebeicg) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(sebeicgbcbg.get("flag")) && StringUtils.isNotEmpty(sebeicgbcbg.get("contract_id"))) {
                        message.append("设备采购合同变更、设备采购合同补充协议、");
                        isAddbcbgsebeicg = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeicgbcbg.get("flag")) && StringUtils.isEmpty(sebeicgbcbg.get("contract_id"))) {
                        message.append("设备采购合同变更、");
                        isAddbcbgsebeicg = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeicgbcbg.get("contract_id")) && StringUtils.isEmpty(sebeicgbcbg.get("flag"))) {
                        message.append("设备采购合同补充协议、");
                        isAddbcbgsebeicg = true; // 添加后标记为已添加
                    }
                }
            }
        }

        List<Map<String,String>> sebeizlList = this.baseMapper.querySebeizl(projectId);
        List<Map<String,String>> sebeizlbcbgList = this.baseMapper.querySebeizlbcbg(projectId);

        if(sebeizlList != null && sebeizlList.size()>0) {
            for (Map<String, String> sebeizl : sebeizlList
            ) {
                if (!isAddsebeizl) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(sebeizl.get("flag")) && StringUtils.isNotEmpty(sebeizl.get("contract_id"))) {
                        message.append("设备租赁合同、设备租赁合同结算、");
                        isAddsebeizl = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeizl.get("flag")) && StringUtils.isEmpty(sebeizl.get("contract_id"))) {
                        message.append("设备租赁合同、");
                        isAddsebeizl = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeizl.get("contract_id")) && StringUtils.isEmpty(sebeizl.get("flag"))) {
                        message.append("设备租赁合同结算、");
                        isAddsebeizl = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(sebeizlbcbgList != null && sebeizlbcbgList.size()>0){
            for (Map<String,String> sebeizlbcbg:sebeizlbcbgList
            ) {
                if (!isAddbcbgsebeizl) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(sebeizlbcbg.get("flag")) && StringUtils.isNotEmpty(sebeizlbcbg.get("contract_id"))) {
                        message.append("设备租赁合同变更、设备租赁合同补充协议、");
                        isAddbcbgsebeizl = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeizlbcbg.get("flag")) && StringUtils.isEmpty(sebeizlbcbg.get("contract_id"))) {
                        message.append("设备租赁合同变更、");
                        isAddbcbgsebeizl = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(sebeizlbcbg.get("contract_id")) && StringUtils.isEmpty(sebeizlbcbg.get("flag"))) {
                        message.append("设备租赁合同补充协议、");
                        isAddbcbgsebeizl = true; // 添加后标记为已添加
                    }
                }
            }
        }

        List<Map<String,String>> otherlist = this.baseMapper.queryOther(projectId);
        List<Map<String,String>> otherbcbglist = this.baseMapper.queryOtherbcbg(projectId);

        if(otherlist != null && otherlist.size()>0){
            for (Map<String,String> other:otherlist
            ) {
                if (!isAddother) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(other.get("flag")) && StringUtils.isNotEmpty(other.get("contract_id"))) {
                        message.append("间接费合同、间接费合同结算、");
                        isAddother = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(other.get("flag")) && StringUtils.isEmpty(other.get("contract_id"))) {
                        message.append("间接费合同、");
                        isAddother = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(other.get("contract_id")) && StringUtils.isEmpty(other.get("flag"))) {
                        message.append("间接费合同结算、");
                        isAddother = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(otherbcbglist != null && otherbcbglist.size()>0){
            for (Map<String,String> otherbcbg:otherbcbglist
            ) {
                if (!isAddbcbgother) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(otherbcbg.get("flag")) && StringUtils.isNotEmpty(otherbcbg.get("contract_id"))) {
                        message.append("间接费合同变更、间接费合同补充协议、");
                        isAddbcbgother = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(otherbcbg.get("flag")) && StringUtils.isEmpty(otherbcbg.get("contract_id"))) {
                        message.append("间接费合同变更、");
                        isAddbcbgother = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(otherbcbg.get("contract_id")) && StringUtils.isEmpty(otherbcbg.get("flag"))) {
                        message.append("间接费合同补充协议、");
                        isAddbcbgother = true; // 添加后标记为已添加
                    }
                }
            }
        }

        List<Map<String,String>> reimburselist = this.baseMapper.queryReimburse(projectId);

        if(reimburselist != null && reimburselist.size()>0){
            message.append("其他费用付款、");
        }
        return message.toString().equals("") ? message.toString():message.toString().substring(0,message.toString().lastIndexOf("、"));
    }

    @Override
    public String checkchange(Long id) {
        String message = "";
        CostClosingForecastEntity entity = this.selectById(id);
        Integer total = this.baseMapper.querychange(id);
        if(total != 0) {
            message ="当前选中预估单存在尚未提交或审核的变更单，请提交或审核后再进行变更！";
        }
        Integer sumtotal = costClosingLastMapper.querysum(entity.getProjectId());
        if(sumtotal != 0) {
            message ="当前选中最终通知单已完成最终成本关门汇总，禁止变更！";
        }
        return message;
    }
}
