package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.CostFinCostSummaryReportingEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 最终成本关门上报汇总
 *
 * @author generator
 *
 */
@Service("costFinCostSummaryReportingService")
public class CostFinCostSummaryReportingServiceImpl extends BaseServiceImpl<CostFinCostSummaryReportingMapper, CostFinCostSummaryReportingEntity> implements ICostFinCostSummaryReportingService{
    private static final String BILL_CODE_ROLE = "COST_FIN_COST_SUMMARY_REPORTING";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ICostFinContractDetailService iCostFinContractDetailService;

    @Autowired
    private ICostFinOtherDetailService iCostFinOtherDetailService;

    @Autowired
    private ICostFinCostSummaryReportingService iCostFinCostSummaryReportingService;

    @Autowired
    private IFinMaterialContractService forecastMaterialcontractDetailService;

    @Autowired
    private IFinMachineContractService forecastMachinecontractDetailService;

    @Autowired
    private IFinOtherContractService forecastOthercontractDetailService;

    @Autowired
    private CostFinOtherDetailMapper otherDetailMapper;

    @Autowired
    private FinMaterialContractMapper finMaterialContractMapper;

    @Autowired
    private FinMachineContractMapper finMachineContractMapper;

    @Autowired
    private FinOtherContractMapper finOtherContractMapper;
    @Autowired
    private ForecastMaterialcontractDetailMapper forecastMaterialcontractDetailMapper;

    @Autowired
    private ForecastMachinecontractDetailMapper forecastMachinecontractDetailMapper;

    @Autowired
    private ForecastOthercontractDetailMapper forecastOthercontractDetailMapper;

    @Autowired
    private CostClosingForecastMapper costClosingForecastMapper;

    @Autowired
    private ForecastOtherDetailChangeMapper forecastOtherDetailChangeMapper;



    @Override
    public CommonResponse<CostFinCostSummaryReportingVO> insertOrUpdate(CostFinCostSummaryReportingVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostFinCostSummaryReportingEntity entity = null;
        String operateType = null;
        if(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
                saveOrUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveOrUpdateVO, CostFinCostSummaryReportingEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE,tenantId);
                if(billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(saveOrUpdateVO, CostFinCostSummaryReportingEntity.class);
            operateType = "add";
        }
        if(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) {
            //修改  校验合同编号是否重复
//            LambdaQueryWrapper<CostFinCostSummaryReportingEntity> lambda = Wrappers.<CostFinCostSummaryReportingEntity>lambdaQuery();
//            lambda.eq(CostFinCostSummaryReportingEntity::getBillCode, saveOrUpdateVO.getBillCode());
//            lambda.eq(CostFinCostSummaryReportingEntity::getTenantId, tenantId);
//            lambda.ne(CostFinCostSummaryReportingEntity::getId, saveOrUpdateVO.getId());
//            lambda.eq(CostFinCostSummaryReportingEntity::getDr, '0');
//            List<CostFinCostSummaryReportingEntity> entities = super.list(lambda);
//            if(entities != null && entities.size() > 0) {
//                throw new BusinessException("存在相同编码，不允许保存!");
//            }
            LambdaQueryWrapper<CostFinCostSummaryReportingEntity> lambda2 = Wrappers.<CostFinCostSummaryReportingEntity>lambdaQuery();
            lambda2.eq(CostFinCostSummaryReportingEntity::getProjectId, saveOrUpdateVO.getProjectId());
            lambda2.eq(CostFinCostSummaryReportingEntity::getTenantId, tenantId);
            lambda2.ne(CostFinCostSummaryReportingEntity::getId, saveOrUpdateVO.getId());
            lambda2.eq(CostFinCostSummaryReportingEntity::getDr, '0');
            List<CostFinCostSummaryReportingEntity> entities2 = super.list(lambda2);
            if(entities2 != null && entities2.size() > 0) {
                throw new BusinessException("该项目已经做过最终汇总，不允许保存!");
            }
        }else{
            LambdaQueryWrapper<CostFinCostSummaryReportingEntity> lambda2 = Wrappers.<CostFinCostSummaryReportingEntity>lambdaQuery();
            lambda2.eq(CostFinCostSummaryReportingEntity::getTenantId, tenantId);
            lambda2.eq(CostFinCostSummaryReportingEntity::getProjectId, saveOrUpdateVO.getProjectId());
            lambda2.eq(CostFinCostSummaryReportingEntity::getDr, '0');
            List<CostFinCostSummaryReportingEntity> entities2 = super.list(lambda2);
            if(entities2 != null && entities2.size() > 0) {
                throw new BusinessException("该项目已经做过最终汇总，不允许保存!");
            }
        }
        super.saveOrUpdate(entity);
        List<CostFinContractDetailVO> detailsVos = saveOrUpdateVO.getCostFinContractDetailList();
        List<CostFinContractDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(CostFinContractDetailVO detailsVo:detailsVos) {
            if("add".equals(detailsVo.getRowState())) {
                CostFinContractDetailEntity detailslist = BeanMapper.map(detailsVo, CostFinContractDetailEntity.class);
                detailslist.setCostFinId(entity.getId());
                saveOrUpldates.add(detailslist);
            }else if("edit".equals(detailsVo.getRowState())) {
                CostFinContractDetailEntity detailslist = BeanMapper.map(detailsVo, CostFinContractDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        List<CostFinOtherDetailVO> otherdetailsVos = saveOrUpdateVO.getCostFinOtherDetailList();
        List<CostFinOtherDetailEntity> othersaveOrUpldates = new ArrayList<>();
        List<Long> otherdeleteIds = new ArrayList<>();
        if(otherdetailsVos != null && otherdetailsVos.size()>0){
            for(CostFinOtherDetailVO otherdetailsVo:otherdetailsVos) {
                if("add".equals(otherdetailsVo.getRowState())) {
                    CostFinOtherDetailEntity otherdetailslist = BeanMapper.map(otherdetailsVo, CostFinOtherDetailEntity.class);
                    otherdetailslist.setFinCostId(entity.getId());
                    othersaveOrUpldates.add(otherdetailslist);
                }else if("edit".equals(otherdetailsVo.getRowState())) {
                    CostFinOtherDetailEntity otherdetailslist = BeanMapper.map(otherdetailsVo, CostFinOtherDetailEntity.class);
                    othersaveOrUpldates.add(otherdetailslist);
                } else if("del".equals(otherdetailsVo.getRowState())) {
                    otherdeleteIds.add(otherdetailsVo.getId());
                }
            }
        }

        //编辑但是未作修改的，维持原样
        if(otherdetailsVos == null || otherdetailsVos.size() == 0) {
            //查找当前单据的原数据
            List<CostFinOtherDetailEntity> forecastContractDetailEntityList = otherDetailMapper.queryOtherById(saveOrUpdateVO.getId());
            List<CostFinOtherDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, CostFinOtherDetailVO.class);
            //查找当前的其他费用数据
            List<CostFinOtherDetailVO> resultList = iCostFinOtherDetailService.querySubjectByProjectId(String.valueOf(saveOrUpdateVO.getProjectId()));
            if(resultList != null && resultList.size()>0){
                if(forecastContractDetailVOS != null && forecastContractDetailVOS.size() >0) {
                    for (CostFinOtherDetailVO res : resultList) {
                        int c = 0;
                        for (CostFinOtherDetailVO otherdetailsVoo : forecastContractDetailVOS) {
                            CostFinOtherDetailEntity otherdetailslist = BeanMapper.map(res, CostFinOtherDetailEntity.class);
                            otherdetailslist.setFinCostId(otherdetailsVoo.getId());
                            othersaveOrUpldates.add(otherdetailslist);
                            c++;
                        }
                        if (c == 0) {
                            CostFinOtherDetailEntity otherdetailslist = BeanMapper.map(res, CostFinOtherDetailEntity.class);
                            otherdetailslist.setFinCostId(entity.getId());
                            othersaveOrUpldates.add(otherdetailslist);
                        }
                    }
                }else{
                    for (CostFinOtherDetailVO res : resultList) {
                        CostFinOtherDetailEntity otherdetailslist = BeanMapper.map(res, CostFinOtherDetailEntity.class);
                        otherdetailslist.setFinCostId(entity.getId());
                        othersaveOrUpldates.add(otherdetailslist);
                    }
                }
            }
        }

        List<FinMaterialContractEntity> materialsaveOrUpldates = new ArrayList<>();
        List<FinMachineContractEntity> machinesaveOrUpldates = new ArrayList<>();
        List<FinOtherContractEntity> othsaveOrUpldates = new ArrayList<>();
        if(operateType == "add") {
            List<FinMaterialContractVO> resultList = iCostFinContractDetailService.querySubContractByProjectIdMaterial(String.valueOf(saveOrUpdateVO.getProjectId()));

            for(FinMaterialContractVO matdetailsVo:resultList) {
                FinMaterialContractEntity detailslist = BeanMapper.map(matdetailsVo, FinMaterialContractEntity.class);
                detailslist.setFinCostId(entity.getId());
                materialsaveOrUpldates.add(detailslist);
            }

            List<FinMachineContractVO> resultListmac = iCostFinContractDetailService.querySubContractByProjectIdMachine(String.valueOf(saveOrUpdateVO.getProjectId()));

            for(FinMachineContractVO macdetailsVo:resultListmac) {
                FinMachineContractEntity detailslist = BeanMapper.map(macdetailsVo, FinMachineContractEntity.class);
                detailslist.setFinCostId(entity.getId());
                machinesaveOrUpldates.add(detailslist);
            }

            List<FinOtherContractVO> resultListoth = iCostFinContractDetailService.querySubContractByProjectIdOther(String.valueOf(saveOrUpdateVO.getProjectId()));

            for(FinOtherContractVO othdetailsVo:resultListoth) {
                FinOtherContractEntity detailslist = BeanMapper.map(othdetailsVo, FinOtherContractEntity.class);
                detailslist.setFinCostId(entity.getId());
                othsaveOrUpldates.add(detailslist);
            }
        }
        Long oldid = saveOrUpdateVO.getId();
        if(operateType == "edit") {

            List<FinMaterialContractVO> resultList = iCostFinContractDetailService.querySubContractByProjectIdMaterial(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<FinMaterialContractEntity> oldmatdata = finMaterialContractMapper.querySubContractByIdMaterial(oldid);
            List<FinMaterialContractVO> oldmatdatavo = BeanMapper.mapList(oldmatdata, FinMaterialContractVO.class);
            List<Long> matidlist = forecastMaterialcontractDetailMapper.querySubContractIdByProjectIdMaterial(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<Long> matoldlist = finMaterialContractMapper.queryByIdMatId(oldid);

            for(FinMaterialContractVO matdetailsVo:resultList) {
                int a = 1;
                for(FinMaterialContractVO old : oldmatdatavo){
                    if(old.getContractId().equals(matdetailsVo.getContractId())){
                        FinMaterialContractEntity detailslist = BeanMapper.map(matdetailsVo, FinMaterialContractEntity.class);
                        detailslist.setFinCostId(old.getId());
                        materialsaveOrUpldates.add(detailslist);
                        a++;
                    }
                }
                if(a == 1){
                    FinMaterialContractEntity detailslist = BeanMapper.map(matdetailsVo, FinMaterialContractEntity.class);
                    detailslist.setFinCostId(entity.getId());
                    materialsaveOrUpldates.add(detailslist);
                }
            }
            for(Long matoldid :matoldlist){
                int ol = 1;
                for(Long matnewid :matidlist){
                    if(matoldid.equals(matnewid)){
                        ol++;
                    }
                }
                if(ol == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<FinMaterialContractEntity> updateWrappermat = new LambdaUpdateWrapper<>();
                    updateWrappermat.set(FinMaterialContractEntity::getDr, '1');
                    updateWrappermat.eq(FinMaterialContractEntity::getContractId,matoldid);

                    forecastMaterialcontractDetailService.update(updateWrappermat);
                }
            }

            List<FinMachineContractVO> resultListmac = iCostFinContractDetailService.querySubContractByProjectIdMachine(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<FinMachineContractEntity> oldmacdata = finMachineContractMapper.querySubContractByIdMachine(oldid);
            List<FinMachineContractVO> oldmacdatavo = BeanMapper.mapList(oldmacdata, FinMachineContractVO.class);
            List<Long> macidlist = forecastMachinecontractDetailMapper.querySubContractIdByProjectIdMachine(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<Long> macoldlist = finMachineContractMapper.queryByIdMacId(oldid);

            for(FinMachineContractVO macdetailsVo:resultListmac) {
                int b = 1;
                for(FinMachineContractVO oldmac:oldmacdatavo){
                    if(oldmac.getContractId().equals(macdetailsVo.getContractId())){
                        FinMachineContractEntity detailslist = BeanMapper.map(macdetailsVo, FinMachineContractEntity.class);
                        detailslist.setFinCostId(oldmac.getId());
                        machinesaveOrUpldates.add(detailslist);
                        b++;
                    }
                }
                if(b == 1){
                    FinMachineContractEntity detailslist = BeanMapper.map(macdetailsVo, FinMachineContractEntity.class);
                    detailslist.setFinCostId(entity.getId());
                    machinesaveOrUpldates.add(detailslist);
                }
            }
            for(Long macoldid :macoldlist){
                int olm = 1;
                for(Long macnewid :macidlist){
                    if(macoldid.equals(macnewid)){
                        olm++;
                    }
                }
                if(olm == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<FinMachineContractEntity> updateWrappermc = new LambdaUpdateWrapper<>();
                    updateWrappermc.set(FinMachineContractEntity::getDr, '1');
                    updateWrappermc.eq(FinMachineContractEntity::getContractId,macoldid);

                    forecastMachinecontractDetailService.update(updateWrappermc);
                }
            }

            List<FinOtherContractVO> resultListoth = iCostFinContractDetailService.querySubContractByProjectIdOther(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<FinOtherContractEntity> oldothdata = finOtherContractMapper.querySubContractByIdOther(oldid);
            List<FinOtherContractVO> oldothdatavo = BeanMapper.mapList(oldothdata, FinOtherContractVO.class);

            List<Long> othidlist = forecastOthercontractDetailMapper.querySubContractIdByProjectIdOther(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<Long> otholdlist = finOtherContractMapper.queryByIdOtherId(oldid);



            for(FinOtherContractVO othdetailsVo:resultListoth) {
                int c = 1;
                for(FinOtherContractVO oldoth:oldothdatavo){
                    if(oldoth.getContractId().equals(othdetailsVo.getContractId())){
                        FinOtherContractEntity detailslist = BeanMapper.map(othdetailsVo, FinOtherContractEntity.class);
                        detailslist.setFinCostId(oldoth.getId());
                        othsaveOrUpldates.add(detailslist);
                        c++;
                    }
                }
                if(c == 1){
                    FinOtherContractEntity detailslist = BeanMapper.map(othdetailsVo, FinOtherContractEntity.class);
                    detailslist.setFinCostId(entity.getId());
                    othsaveOrUpldates.add(detailslist);
                }
            }
            for(Long otholdid :otholdlist){
                int othc = 1;
                for(Long othnewid :othidlist){
                    if(otholdid.equals(othnewid)){
                        othc++;
                    }
                }
                if(othc == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<FinOtherContractEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                    updateWrapperot.set(FinOtherContractEntity::getDr, '1');
                    updateWrapperot.eq(FinOtherContractEntity::getContractId,otholdid);

                    forecastOthercontractDetailService.update(updateWrapperot);
                }
            }
        }


        if(saveOrUpldates.size() > 0) {
            iCostFinContractDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if(othersaveOrUpldates.size() > 0) {
            iCostFinOtherDetailService.saveOrUpdateBatch(othersaveOrUpldates, saveOrUpldates.size(), false);
        }
        if(deleteIds.size() > 0) {
            iCostFinOtherDetailService.removeByIds(deleteIds, false);
        }
        if(otherdeleteIds.size() > 0) {
            iCostFinOtherDetailService.removeByIds(otherdeleteIds, false);
        }
//        if(operateType == "add") {
            if(materialsaveOrUpldates.size()>0){
                forecastMaterialcontractDetailService.saveOrUpdateBatch(materialsaveOrUpldates,materialsaveOrUpldates.size(),false);
            }
            if(machinesaveOrUpldates.size()>0){
                forecastMachinecontractDetailService.saveOrUpdateBatch(machinesaveOrUpldates,machinesaveOrUpldates.size(),false);
            }
            if(othsaveOrUpldates.size()>0){
                forecastOthercontractDetailService.saveOrUpdateBatch(othsaveOrUpldates,othsaveOrUpldates.size(),false);
            }
//        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public CostFinCostSummaryReportingVO queryDetail(Long id) {
        CostFinCostSummaryReportingEntity entity = this.baseMapper.selectById(id);
        if(entity != null) {
            CostFinCostSummaryReportingVO contractVo = BeanMapper.map(entity, CostFinCostSummaryReportingVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("cost_fin_id", new Parameter(QueryParam.EQ, contractVo.getId()));

            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("fin_cost_id", new Parameter(QueryParam.EQ, contractVo.getId()));

            List<CostFinContractDetailEntity> purchaseDetailss = iCostFinContractDetailService.queryList(queryParam, false);
            List<CostFinOtherDetailEntity> forecastOtherDetailEntities = iCostFinOtherDetailService.queryList(queryParam2,false);
//            List<ForecastMaterialcontractDetailEntity> forecastOtherDetailChangeEntities = iForecastMaterialcontractDetailService.queryList(queryParam2,false);

            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                List<CostFinContractDetailVO> resultMapList = BeanMapper.mapList(purchaseDetailss, CostFinContractDetailVO.class);
                contractVo.setCostFinContractDetailList(resultMapList);
            }
            if(forecastOtherDetailEntities != null && forecastOtherDetailEntities.size() > 0) {
                List<CostFinOtherDetailVO> resultMapList2 = BeanMapper.mapList(forecastOtherDetailEntities, CostFinOtherDetailVO.class);
                contractVo.setCostFinOtherDetailList(resultMapList2);
            }
//            if(forecastOtherDetailChangeEntities != null && forecastOtherDetailChangeEntities.size() > 0) {
//                List<ForecastMaterialcontractDetailVO> resultMapList3 = BeanMapper.mapList(forecastOtherDetailChangeEntities, ForecastMaterialcontractDetailVO.class);
//            }
            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteDatas(List<CostFinCostSummaryReportingVO> vos) {
        for(CostFinCostSummaryReportingVO vo:vos){
            Long id = vo.getId();//获取主表id
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("cost_fin_id", new Parameter(QueryParam.EQ, id));

            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("fin_cost_id", new Parameter(QueryParam.EQ, id));

            List<CostFinContractDetailEntity> costFinContractDetailEntities = iCostFinContractDetailService.queryList(queryParam);
            LambdaUpdateWrapper<CostFinContractDetailEntity> ceupdate = new LambdaUpdateWrapper<>();
            ceupdate.set(CostFinContractDetailEntity::getDr,'1');

            List<CostFinOtherDetailEntity> costFinOtherDetailEntities = iCostFinOtherDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<CostFinOtherDetailEntity> oeupdate = new LambdaUpdateWrapper<>();
            oeupdate.set(CostFinOtherDetailEntity::getDr,'1');

            List<FinMaterialContractEntity> forecastMaterialcontractDetailEntities = forecastMaterialcontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<FinMaterialContractEntity> meupdate = new LambdaUpdateWrapper<>();
            meupdate.set(FinMaterialContractEntity::getDr,'1');

            List<FinMachineContractEntity> forecastMachinecontractDetailEntities = forecastMachinecontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<FinMachineContractEntity> maupdate = new LambdaUpdateWrapper<>();
            maupdate.set(FinMachineContractEntity::getDr,'1');

            List<FinOtherContractEntity> forecastOthercontractDetailEntities = forecastOthercontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<FinOtherContractEntity> ocupdate = new LambdaUpdateWrapper<>();
            ocupdate.set(FinOtherContractEntity::getDr,'1');

            LambdaUpdateWrapper<CostFinCostSummaryReportingEntity> zhu = new LambdaUpdateWrapper<>();
            zhu.set(CostFinCostSummaryReportingEntity::getDr,'1');
            zhu.eq(CostFinCostSummaryReportingEntity::getId,id);
            iCostFinCostSummaryReportingService.update(zhu);

            if(!costFinContractDetailEntities.isEmpty()){
                ceupdate.eq(CostFinContractDetailEntity::getCostFinId,id);
                iCostFinContractDetailService.update(ceupdate);
            }
            if(!costFinOtherDetailEntities.isEmpty()){
                oeupdate.eq(CostFinOtherDetailEntity::getFinCostId,id);
                iCostFinOtherDetailService.update(oeupdate);
            }
            if(!forecastMaterialcontractDetailEntities.isEmpty()){
                meupdate.eq(FinMaterialContractEntity::getFinCostId,id);
                forecastMaterialcontractDetailService.update(meupdate);
            }
            if(!forecastMachinecontractDetailEntities.isEmpty()){
                maupdate.eq(FinMachineContractEntity::getFinCostId,id);
                forecastMachinecontractDetailService.update(maupdate);
            }
            if(!forecastOthercontractDetailEntities.isEmpty()){
                ocupdate.eq(FinOtherContractEntity::getFinCostId,id);
                forecastOthercontractDetailService.update(ocupdate);
            }

        }
    }

    @Override
    public Map<String, Object> queryAccumulateProfitMargin(Long projectId) {
        Map<String,Object> matmap = new HashMap<>();
        CostClosingLastEntity costClosingLastEntity = this.baseMapper.queryAccumulateProfitMargin(projectId);

        CostClosingForecastEntity costClosingForecastEntity = costClosingForecastMapper.selectsourceByProject(projectId);

        BigDecimal subsettle = costClosingForecastMapper.finsubsettle(projectId);
        BigDecimal materialsettle = costClosingForecastMapper.finmaterialsettle(projectId);
        BigDecimal machinesettle = costClosingForecastMapper.finmachinesettle(projectId);
        BigDecimal othersettle = costClosingForecastMapper.finothersettle(projectId);
        BigDecimal yjs = subsettle.add(materialsettle).add(machinesettle).add(othersettle);

        BigDecimal subnotax = costClosingForecastMapper.subnotax(projectId);
        BigDecimal subchangenotax = costClosingForecastMapper.subchangenotax(projectId);
        BigDecimal othnotax = costClosingForecastMapper.othnotax(projectId);
        BigDecimal othchangenotax = costClosingForecastMapper.othchangenotax(projectId);
        BigDecimal yg = subnotax.add(subchangenotax).add(othnotax).add(othchangenotax);

        BigDecimal conjs = forecastOtherDetailChangeMapper.conjs(projectId);
        BigDecimal js = forecastOtherDetailChangeMapper.js(projectId);
        BigDecimal closecostv = yg.subtract(conjs).subtract(js);

        //G = E+F
        BigDecimal wgzcb = yjs.add(closecostv);

        //H = D-G
        BigDecimal lr = costClosingForecastEntity.getConservativeSettlement().subtract(wgzcb);

        //I = H/D
        BigDecimal lrl = new BigDecimal("0.00");
        if(lr.compareTo(BigDecimal.ZERO) != 0 && costClosingForecastEntity.getConservativeSettlement().compareTo(BigDecimal.ZERO) != 0){
            lrl = lr.divide(costClosingForecastEntity.getConservativeSettlement(),2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100"));
        }

        matmap.put("expectprofits",lrl);

        return matmap;
    }

    @Override
    public String checkContractAndSettlement(Long projectId) {
        StringBuffer message = new StringBuffer();
        List<Map<String,String>> sublist = costClosingForecastMapper.querySub(projectId);
        List<Map<String,String>> subbcbglist = costClosingForecastMapper.querySubbcbg(projectId);
        List<Map<String,String>> subsettlelist = costClosingForecastMapper.querySubsettle(projectId);
        boolean isAdded = false;
        boolean isAddbcbged = false;
        boolean isAddsettle = false;
        boolean isAddrmat = false;
        boolean isAddbcbgrmat = false;
        boolean isAddmaterial = false;
        boolean isAddbcbgmaterial = false;
        boolean isAddsebeicg = false;
        boolean isAddbcbgsebeicg = false;
        boolean isAddsebeizl = false;
        boolean isAddbcbgsebeizl = false;
        boolean isAddother = false;
        boolean isAddbcbgother = false;
        if(sublist != null && sublist.size()>0){
            for (Map<String,String> sub:sublist
            ) {
                if (!isAdded) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(sub.get("flag")) && StringUtils.isNotEmpty(sub.get("contract_id"))) {
                        message.append("分包完工结算、");
                        isAdded = true; // 添加后标记为已添加
                    }
//                    else if (StringUtils.isNotEmpty(sub.get("flag")) && StringUtils.isEmpty(sub.get("contract_id"))) {
//                        message.append("分包合同、");
//                        isAdded = true; // 添加后标记为已添加
//                    } else
                    if (StringUtils.isNotEmpty(sub.get("contract_id")) && StringUtils.isEmpty(sub.get("flag"))) {
                        message.append("分包完工结算、");
                        isAdded = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(subbcbglist != null && subbcbglist.size()>0){
            for (Map<String,String> subbcbg:subbcbglist
            ) {
                if (!isAddbcbged) { // 只有在未添加过message时，才进行条件判断
                    if (StringUtils.isNotEmpty(subbcbg.get("flag")) && StringUtils.isNotEmpty(subbcbg.get("contract_id"))) {
                        message.append("分包合同变更、分包合同补充协议、");
                        isAddbcbged = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(subbcbg.get("flag")) && StringUtils.isEmpty(subbcbg.get("contract_id"))) {
                        message.append("分包合同补充协议、");
                        isAddbcbged = true; // 添加后标记为已添加
                    } else if (StringUtils.isNotEmpty(subbcbg.get("contract_id")) && StringUtils.isEmpty(subbcbg.get("flag"))) {
                        message.append("分包合同变更、");
                        isAddbcbged = true; // 添加后标记为已添加
                    }
                }
            }
        }

        if(subsettlelist != null && subsettlelist.size()>0){
            for (Map<String,String> subsettle:subsettlelist
            ) {
                if (!isAddsettle) { // 只有在未添加过message时，才进行条件判断
                    if(subsettle.get("contract_id") != null){
                        String subcontractid = String.valueOf(subsettle.get("contract_id"));
                        if (StringUtils.isNotEmpty(subcontractid) && StringUtils.isEmpty(subsettle.get("flag"))) {
                            message.append("分包进度结算、");
                            isAddsettle = true; // 添加后标记为已添加
                        }
                    }
                }
            }
        }

        List<Map<String,String>> otherlist = costClosingForecastMapper.queryOther(projectId);
        List<Map<String,String>> otherbcbglist = costClosingForecastMapper.queryOtherbcbg(projectId);

        if(otherlist != null && otherlist.size()>0){
            for (Map<String,String> other:otherlist
            ) {
                if (!isAddother) { // 只有在未添加过message时，才进行条件判断
//                    if (StringUtils.isNotEmpty(other.get("flag")) && StringUtils.isNotEmpty(other.get("contract_id"))) {
//                        message.append("间接费合同、间接费合同结算、");
//                        isAddother = true; // 添加后标记为已添加
//                    } else if (StringUtils.isNotEmpty(other.get("flag")) && StringUtils.isEmpty(other.get("contract_id"))) {
//                        message.append("间接费合同、");
//                        isAddother = true; // 添加后标记为已添加
//                    } else
                    if (StringUtils.isNotEmpty(other.get("contract_id")) && StringUtils.isEmpty(other.get("flag"))) {
                        message.append("间接费合同结算、");
                        isAddother = true; // 添加后标记为已添加
                    }
                }
            }
        }

//        if(otherbcbglist != null && otherbcbglist.size()>0){
//            for (Map<String,String> otherbcbg:otherbcbglist
//            ) {
//                if (!isAddbcbgother) { // 只有在未添加过message时，才进行条件判断
//                    if (StringUtils.isNotEmpty(otherbcbg.get("flag")) && StringUtils.isNotEmpty(otherbcbg.get("contract_id"))) {
//                        message.append("间接费合同变更、间接费合同补充协议、");
//                        isAddbcbgother = true; // 添加后标记为已添加
//                    } else if (StringUtils.isNotEmpty(otherbcbg.get("flag")) && StringUtils.isEmpty(otherbcbg.get("contract_id"))) {
//                        message.append("间接费合同变更、");
//                        isAddbcbgother = true; // 添加后标记为已添加
//                    } else if (StringUtils.isNotEmpty(otherbcbg.get("contract_id")) && StringUtils.isEmpty(otherbcbg.get("flag"))) {
//                        message.append("间接费合同补充协议、");
//                        isAddbcbgother = true; // 添加后标记为已添加
//                    }
//                }
//            }
//        }

        List<Map<String,String>> reimburselist = costClosingForecastMapper.queryReimburse(projectId);

        if (!reimburselist.isEmpty()) {
            message.append("其他费用付款、");
        }
        return message.toString().equals("") ? message.toString():message.toString().substring(0,message.toString().lastIndexOf("、"));
    }

    @Override
    public String addProjectCheck(Long projectId,Long id) {
        String message = "";
        Integer total = this.baseMapper.querytotal(projectId,id);
        if(total != 0) {
            message ="该项目已经存在最终成本关门上报汇总单！";
        }
        return message;
    }

    @Override
    public CostFinCostSummaryReportingEntity querySubContractByProjectId(Long projectId) {
        CostFinCostSummaryReportingEntity costFinContractDetailEntity = this.baseMapper.querySubContractByProjectId(projectId);
        return costFinContractDetailEntity;
    }

    @Override
    public CostFinCostSummaryReportingEntity querySubContractByProjectIdMaterial(Long projectId) {
        CostFinCostSummaryReportingEntity costFinContractDetailEntity = this.baseMapper.querySubContractByProjectIdMaterial(projectId);
        return costFinContractDetailEntity;    }

    @Override
    public CostFinCostSummaryReportingEntity querySubContractByProjectIdMachine(Long projectId) {
        CostFinCostSummaryReportingEntity costFinContractDetailEntity = this.baseMapper.querySubContractByProjectIdMachine(projectId);
        return costFinContractDetailEntity;    }

    @Override
    public CostFinCostSummaryReportingEntity querySubContractByProjectIdOther(Long projectId) {
        CostFinCostSummaryReportingEntity costFinContractDetailEntity = this.baseMapper.querySubContractByProjectIdOther(projectId);
        return costFinContractDetailEntity;    }
}
