package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.vo.UnfinishVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.cost.mapper.UnfinishMapper;
import com.ejianc.business.cost.bean.UnfinishEntity;
import com.ejianc.business.cost.service.IUnfinishService;

/**
 * 已完未结成本
 * 
 * @author generator
 * 
 */
@Service("unfinishService")
public class UnfinishServiceImpl extends BaseServiceImpl<UnfinishMapper, UnfinishEntity> implements IUnfinishService{
    private static final String BILL_CODE = "YWWJ_CODE";;//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public UnfinishVO saveOrUpdate(UnfinishVO saveOrUpdateVO) {
        UnfinishEntity entity = BeanMapper.map(saveOrUpdateVO, UnfinishEntity.class);
        if(StringUtils.isBlank(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public UnfinishVO queryDetail(Long id) {
        UnfinishEntity entity = super.selectById(id);
        UnfinishVO vo = BeanMapper.map(entity, UnfinishVO.class);
        return vo;
    }
}
