package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.bean.ForecastOtherDetailChangeEntity;
import com.ejianc.business.cost.mapper.CostClosingForecastChangeMapper;
import com.ejianc.business.cost.service.ICostClosingForecastService;
import com.ejianc.business.cost.vo.CostClosingForecastVO;
import com.ejianc.business.cost.vo.ForecastOtherDetailChangeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostClosingForecastChangeEntity;
import com.ejianc.business.cost.service.ICostClosingForecastChangeService;
import com.ejianc.business.cost.vo.CostClosingForecastChangeVO;

/**
 * 成本关门预估变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costClosingForecastChange")
public class CostClosingForecastChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "COST_CLOSING_FORECAST_CHANGE";//此处需要根据实际修改

    @Autowired
    private ICostClosingForecastChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CostClosingForecastChangeMapper baseMapper;

    @Autowired
    private ICostClosingForecastService costClosingForecastService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostClosingForecastChangeVO> saveOrUpdate(@RequestBody CostClosingForecastChangeVO saveOrUpdateVO) {
        Long forecastId = saveOrUpdateVO.getSourceForecastId();
        Long id = saveOrUpdateVO.getId();
        Integer count = 0;
        if(id != null){
            count = this.baseMapper.countClosing(forecastId,id);
        }else{
            count = this.baseMapper.countClosing1(forecastId);
        }

        if(count != 0){
            throw new BusinessException("当前预估单下存在尚未过审的变更单，不允许新增保存");
        }

        List<ForecastOtherDetailChangeVO> elist = saveOrUpdateVO.getForecastOtherDetailChangeList();
        if(elist != null && elist.size()>0){
            for(ForecastOtherDetailChangeVO vo:elist){
                Long costtype = vo.getCostTypeId();
                Long subjectId = vo.getSubjectId();
                //根据保存的数据，查找已有单据，防止出现同科目不同类型的情况
                Integer countchange = this.baseMapper.querysub(costtype,subjectId,id);
                Integer countsource = this.baseMapper.querysubsour(costtype,subjectId,id);

                String subjectname = this.baseMapper.querysubname(subjectId);

                if(countchange != 0 || countsource != 0){
                    throw new BusinessException("成本科目 " + subjectname + " 已在该项目下属成本关门预估单据中选取过，禁止保存！");
                }

            }
        }

        CommonResponse<CostClosingForecastChangeVO> response = service.insertOrUpdate(saveOrUpdateVO);
        return response;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingForecastChangeVO> queryDetail(Long id) {
    	CostClosingForecastChangeEntity entity = this.baseMapper.selectById(id);
    	CostClosingForecastChangeVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询原预估单详情
     * @param id
     */
    @RequestMapping(value = "/queryCostClosingForecast", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostClosingForecastChangeVO> queryCostClosingForecast(Long id) {
//        CostClosingForecastChangeEntity entity = this.baseMapper.selectById(id);
        CostClosingForecastChangeVO vo = service.queryCostClosingForecast(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostClosingForecastChangeVO> vos) {
        Long id = vos.get(0).getId();
        CostClosingForecastChangeEntity vo = service.selectById(id);
        service.deleteDatas(vos);
        Integer total = this.baseMapper.querychangetotal(vo.getSourceForecastId());
        if(total == 0){
            //回写主表
            LambdaUpdateWrapper<CostClosingForecastEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(CostClosingForecastEntity::getChangeStatus, '1');
            updateWrapper.set(CostClosingForecastEntity::getChangeStatusName, "未变更");
            updateWrapper.eq(CostClosingForecastEntity::getId,vo.getSourceForecastId());

            costClosingForecastService.update(updateWrapper);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostClosingForecastChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<CostClosingForecastChangeEntity> page = service.queryPage(param,false);
        IPage<CostClosingForecastChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingForecastChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CostClosingForecastChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CostClosingForecastChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCostClosingForecastChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CostClosingForecastChangeVO>> refCostClosingForecastChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CostClosingForecastChangeEntity> page = service.queryPage(param,false);
        IPage<CostClosingForecastChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostClosingForecastChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


}
