package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.vo.*;
import com.ejianc.business.cost.vo.ForecastContractDetailChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.CostClosingForecastChangeEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 成本关门预估变更
 *
 * @author generator
 *
 */
@Service("costClosingForecastChangeService")
public class CostClosingForecastChangeServiceImpl extends BaseServiceImpl<CostClosingForecastChangeMapper, CostClosingForecastChangeEntity> implements ICostClosingForecastChangeService{
    private static final String BILL_CODE_ROLE = "COST_CLOSING_FORECAST_CHANGE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IForecastContractDetailChangeService iForecastContractDetailChangeService;

    @Autowired
    private IForecastOtherDetailChangeService iForecastOtherDetailChangeService;

    @Autowired
    private ICostClosingForecastChangeService iCostClosingForecastChangeService;

    @Autowired
    private ForecastOtherDetailChangeMapper forecastOtherDetailChangeMapper;

    @Autowired
    private ForecastContractDetailChangeMapper forecastContractDetailChangeMapper;

    @Autowired
    private ForecastOtherDetailMapper forecastOtherDetailMapper;

    @Autowired
    private ForecastMachinecontractDetailMapper forecastMachinecontractDetailMapper;

    @Autowired
    private ForecastOthercontractDetailMapper forecastOthercontractDetailMapper;

    @Autowired
    private ICostClosingForecastService costClosingForecastService;

    @Autowired
    private IForecastChangeMaterialcontractDetailService forecastMaterialcontractDetailService;

    @Autowired
    private IForecastChangeMachinecontractDetailService forecastMachinecontractDetailService;

    @Autowired
    private IForecastChangeOthercontractDetailService forecastOthercontractDetailService;

    @Autowired
    private ForecastChangeMaterialcontractDetailMapper forecastChangeMaterialcontractDetailMapper;

    @Autowired
    private ForecastChangeMachinecontractDetailMapper forecastChangeMachinecontractDetailMapper;

    @Autowired
    private ForecastChangeOthercontractDetailMapper forecastChangeOthercontractDetailMapper;


    @Override
    public CommonResponse<CostClosingForecastChangeVO> insertOrUpdate(CostClosingForecastChangeVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostClosingForecastChangeEntity entity = null;
        Long sourceForecastId = saveOrUpdateVO.getSourceForecastId();
        String operateType = null;
        if(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
                saveOrUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveOrUpdateVO, CostClosingForecastChangeEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE,tenantId);
                if(billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(saveOrUpdateVO, CostClosingForecastChangeEntity.class);
            operateType = "add";
        }
        if(operateType == "add") {
            LambdaQueryWrapper<CostClosingForecastChangeEntity> lambda2 = Wrappers.<CostClosingForecastChangeEntity>lambdaQuery();
            lambda2.eq(CostClosingForecastChangeEntity::getProjectId, saveOrUpdateVO.getProjectId());
            lambda2.eq(CostClosingForecastChangeEntity::getTenantId, tenantId);
            lambda2.eq(CostClosingForecastChangeEntity::getDr, '0');
            lambda2.notIn(CostClosingForecastChangeEntity::getBillState, 1,3);
            List<CostClosingForecastChangeEntity> entities2 = super.list(lambda2);
            if(entities2 != null && entities2.size() > 0) {
                throw new BusinessException("该预估单存在未审核完毕的变更单，不允许保存!");
            }
        }
        super.saveOrUpdate(entity);
        List<ForecastContractDetailChangeVO> detailsVos = saveOrUpdateVO.getForecastContractDetailChangeList();
        List<ForecastContractDetailChangeEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(ForecastContractDetailChangeVO detailsVo:detailsVos) {
            if("add".equals(detailsVo.getRowState())) {
                ForecastContractDetailChangeEntity detailslist = BeanMapper.map(detailsVo, ForecastContractDetailChangeEntity.class);
                detailslist.setCostChangeForecastId(entity.getId());
                saveOrUpldates.add(detailslist);
            }else if("edit".equals(detailsVo.getRowState())) {
                ForecastContractDetailChangeEntity detailslist = BeanMapper.map(detailsVo, ForecastContractDetailChangeEntity.class);
                saveOrUpldates.add(detailslist);
            } else if("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        List<ForecastOtherDetailChangeVO> otherdetailsVos = saveOrUpdateVO.getForecastOtherDetailChangeList();
        List<ForecastOtherDetailChangeEntity> othersaveOrUpldates = new ArrayList<>();
        List<Long> otherdeleteIds = new ArrayList<>();
        for(ForecastOtherDetailChangeVO otherdetailsVo:otherdetailsVos) {
//            otherdetailsVo.setSubjectId(Long.parseLong(otherdetailsVo.getSubjectName()));
            if("add".equals(otherdetailsVo.getRowState())) {

                //校验成本科目是否重复
//                Integer total = forecastOtherDetailMapper.queryold(otherdetailsVo.getSubjectId(),saveOrUpdateVO.getProjectId());
//                if(total != 0) {
//                    String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
//                    throw new BusinessException("成本科目"+name+"已进行过成本关门预估，不允许保存!");
//                }
                int a = 0;
                for(ForecastOtherDetailChangeVO forecastOtherDetailVO:otherdetailsVos) {
//                    forecastOtherDetailVO.setSubjectId(Long.parseLong(forecastOtherDetailVO.getSubjectName()));
                    if(forecastOtherDetailVO.getSubjectId().equals(otherdetailsVo.getSubjectId())){
                        a++;
                        if(a>1) {
                            String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
                            throw new BusinessException("成本科目" + name + "出现重复，不允许保存!");
                        }
                    }
                }
                ForecastOtherDetailChangeEntity otherdetailslist = BeanMapper.map(otherdetailsVo, ForecastOtherDetailChangeEntity.class);
                otherdetailslist.setCostChangeForecastId(entity.getId());
                othersaveOrUpldates.add(otherdetailslist);
            }else if("edit".equals(otherdetailsVo.getRowState())) {
                //校验合同编号是否重复
//                Integer total = forecastOtherDetailMapper.queryoldexid(otherdetailsVo.getSubjectId(),saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());
//                if(total != 0) {
//                    String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
//                    throw new BusinessException("成本科目"+name+"已进行过成本关门预估，不允许保存!");
//                }
                int a = 0;
                for(ForecastOtherDetailChangeVO forecastOtherDetailVO:otherdetailsVos) {
//                    forecastOtherDetailVO.setSubjectId(Long.parseLong(forecastOtherDetailVO.getSubjectName()));
                    if(forecastOtherDetailVO.getSubjectId().equals(otherdetailsVo.getSubjectId())){
                        a++;
                        if(a>1) {
                            String name = forecastOtherDetailMapper.queryname(otherdetailsVo.getSubjectId());
                            throw new BusinessException("成本科目" + name + "出现重复，不允许保存!");
                        }
                    }
                }
                ForecastOtherDetailChangeEntity otherdetailslist = BeanMapper.map(otherdetailsVo, ForecastOtherDetailChangeEntity.class);
                othersaveOrUpldates.add(otherdetailslist);
            } else if("del".equals(otherdetailsVo.getRowState())) {
                otherdeleteIds.add(otherdetailsVo.getId());
            }
        }

        List<ForecastChangeMaterialcontractDetailEntity> materialsaveOrUpldates = new ArrayList<>();
        List<ForecastChangeMachinecontractDetailEntity> machinesaveOrUpldates = new ArrayList<>();
        List<ForecastChangeOthercontractDetailEntity> othsaveOrUpldates = new ArrayList<>();
        if(operateType == "add") {
            List<ForecastChangeMaterialcontractDetailVO> resultList = iForecastContractDetailChangeService.querySubContractByProjectIdMaterial(String.valueOf(saveOrUpdateVO.getProjectId()));

            for(ForecastChangeMaterialcontractDetailVO matdetailsVo:resultList) {
                ForecastChangeMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastChangeMaterialcontractDetailEntity.class);
                detailslist.setCostChangeForecastId(entity.getId());
                materialsaveOrUpldates.add(detailslist);
            }

            List<ForecastChangeMachinecontractDetailVO> resultListmac = iForecastContractDetailChangeService.querySubContractByProjectIdMachine(String.valueOf(saveOrUpdateVO.getProjectId()));

            for(ForecastChangeMachinecontractDetailVO macdetailsVo:resultListmac) {
                ForecastChangeMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastChangeMachinecontractDetailEntity.class);
                detailslist.setCostChangeForecastId(entity.getId());
                machinesaveOrUpldates.add(detailslist);
            }

            List<ForecastChangeOthercontractDetailVO> resultListoth = iForecastContractDetailChangeService.querySubContractByProjectIdOther(String.valueOf(saveOrUpdateVO.getProjectId()));

            for(ForecastChangeOthercontractDetailVO othdetailsVo:resultListoth) {
                ForecastChangeOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastChangeOthercontractDetailEntity.class);
                detailslist.setCostChangeForecastId(entity.getId());
                othsaveOrUpldates.add(detailslist);
            }

        }
        Long oldid = saveOrUpdateVO.getId();
        Long projectold = saveOrUpdateVO.getProjectId();
        if(operateType == "edit") {

            List<ForecastChangeMaterialcontractDetailVO> resultList = iForecastContractDetailChangeService.querySubContractByProjectIdMaterial(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<ForecastChangeMaterialcontractDetailEntity> oldmatdata = forecastChangeMaterialcontractDetailMapper.querySubContractByIdMaterial(projectold);
            List<ForecastChangeMaterialcontractDetailVO> oldmatdatavo = BeanMapper.mapList(oldmatdata, ForecastChangeMaterialcontractDetailVO.class);
            List<Long> matidlist = forecastChangeMaterialcontractDetailMapper.querySubContractIdByProjectIdMaterial(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<Long> matoldlist = forecastChangeMaterialcontractDetailMapper.queryByIdMatId(oldid);

            //遍历最新物资合同
            for(ForecastChangeMaterialcontractDetailVO matdetailsVo:resultList) {
                int a = 1;
                //遍历原变更单旧数据
                for(ForecastChangeMaterialcontractDetailVO old : oldmatdatavo){
                    //当合同id一致，更新原数据
                    if(old.getContractId().equals(matdetailsVo.getContractId())){
//                        ForecastChangeMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastChangeMaterialcontractDetailEntity.class);
//                        detailslist.setCostChangeForecastId(old.getId());
//                        detailslist.setId(old.getId());
//                        forecastChangeMaterialcontractDetailMapper.updateById(detailslist);

                        ForecastChangeMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastChangeMaterialcontractDetailEntity.class);
                        ForecastChangeMaterialcontractDetailEntity oldothlist = BeanMapper.map(old, ForecastChangeMaterialcontractDetailEntity.class);

                        LambdaUpdateWrapper<ForecastChangeMaterialcontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getContractType, detailslist.getContractType());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getContractAmount, detailslist.getContractAmount());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getContractCode, detailslist.getContractCode());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getContractName, detailslist.getContractName());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getTaxRate, detailslist.getTaxRate());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getSubOrg, detailslist.getSubOrg());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getSubOrgId, detailslist.getSubOrgId());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getAmountSettled, detailslist.getAmountSettled());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getAmountSettledNotax, detailslist.getAmountSettledNotax());
                        updateWrapperot.set(ForecastChangeMaterialcontractDetailEntity::getAmountSettledTax, detailslist.getAmountSettledTax());
                        updateWrapperot.eq(ForecastChangeMaterialcontractDetailEntity::getContractId,oldothlist.getContractId());

                        forecastMaterialcontractDetailService.update(updateWrapperot);

//                        materialsaveOrUpldates.add(detailslist);
                        a++;
                    }
                }
                if(a == 1){
                    ForecastChangeMaterialcontractDetailEntity detailslist = BeanMapper.map(matdetailsVo, ForecastChangeMaterialcontractDetailEntity.class);
                    detailslist.setCostChangeForecastId(entity.getId());
                    materialsaveOrUpldates.add(detailslist);
                }
            }
            for(Long matoldid :matoldlist){
                int ol = 1;
                for(Long matnewid :matidlist){
                    if(matoldid.equals(matnewid)){
                        ol++;
                    }
                }
                if(ol == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<ForecastChangeMaterialcontractDetailEntity> updateWrappermat = new LambdaUpdateWrapper<>();
                    updateWrappermat.set(ForecastChangeMaterialcontractDetailEntity::getDr, '1');
                    updateWrappermat.eq(ForecastChangeMaterialcontractDetailEntity::getContractId,matoldid);

                    forecastMaterialcontractDetailService.update(updateWrappermat);
                }
            }

            List<ForecastChangeMachinecontractDetailVO> resultListmac = iForecastContractDetailChangeService.querySubContractByProjectIdMachine(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<ForecastChangeMachinecontractDetailEntity> oldmacdata = forecastChangeMachinecontractDetailMapper.querySubContractByIdMachine(projectold);
            List<ForecastChangeMachinecontractDetailVO> oldmacdatavo = BeanMapper.mapList(oldmacdata, ForecastChangeMachinecontractDetailVO.class);
            List<Long> macidlist = forecastMachinecontractDetailMapper.querySubContractIdByProjectIdMachine(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<Long> macoldlist = forecastChangeMachinecontractDetailMapper.queryByIdMacId(oldid);

            for(ForecastChangeMachinecontractDetailVO macdetailsVo:resultListmac) {
                int b = 1;
                for(ForecastChangeMachinecontractDetailVO oldmac:oldmacdatavo){
                    if(oldmac.getContractId().equals(macdetailsVo.getContractId())){
//                        ForecastChangeMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastChangeMachinecontractDetailEntity.class);
//                        detailslist.setCostChangeForecastId(oldmac.getId());
//                        detailslist.setId(oldmac.getId());
//                        forecastChangeMachinecontractDetailMapper.updateById(detailslist);

                    ForecastChangeMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastChangeMachinecontractDetailEntity.class);
                    ForecastChangeMachinecontractDetailEntity oldothlist = BeanMapper.map(oldmac, ForecastChangeMachinecontractDetailEntity.class);

                    LambdaUpdateWrapper<ForecastChangeMachinecontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getContractType, detailslist.getContractType());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getContractAmount, detailslist.getContractAmount());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getContractCode, detailslist.getContractCode());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getContractName, detailslist.getContractName());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getTaxRate, detailslist.getTaxRate());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getSubOrg, detailslist.getSubOrg());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getSubOrgId, detailslist.getSubOrgId());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getAmountSettled, detailslist.getAmountSettled());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getAmountSettledNotax, detailslist.getAmountSettledNotax());
                    updateWrapperot.set(ForecastChangeMachinecontractDetailEntity::getAmountSettledTax, detailslist.getAmountSettledTax());
                    updateWrapperot.eq(ForecastChangeMachinecontractDetailEntity::getContractId,oldothlist.getContractId());

                    forecastMachinecontractDetailService.update(updateWrapperot);

//                        machinesaveOrUpldates.add(detailslist);
                        b++;
                    }
                }
                if(b == 1){
                    ForecastChangeMachinecontractDetailEntity detailslist = BeanMapper.map(macdetailsVo, ForecastChangeMachinecontractDetailEntity.class);
                    detailslist.setCostChangeForecastId(entity.getId());
                    machinesaveOrUpldates.add(detailslist);
                }
            }
            for(Long macoldid :macoldlist){
                int olm = 1;
                for(Long macnewid :macidlist){
                    if(macoldid.equals(macnewid)){
                        olm++;
                    }
                }
                if(olm == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<ForecastChangeMachinecontractDetailEntity> updateWrappermc = new LambdaUpdateWrapper<>();
                    updateWrappermc.set(ForecastChangeMachinecontractDetailEntity::getDr, '1');
                    updateWrappermc.eq(ForecastChangeMachinecontractDetailEntity::getContractId,macoldid);

                    forecastMachinecontractDetailService.update(updateWrappermc);
                }
            }

            List<ForecastChangeOthercontractDetailVO> resultListoth = iForecastContractDetailChangeService.querySubContractByProjectIdOther(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<ForecastChangeOthercontractDetailEntity> oldothdata = forecastChangeOthercontractDetailMapper.querySubContractByIdOther(projectold);
            List<ForecastChangeOthercontractDetailVO> oldothdatavo = BeanMapper.mapList(oldothdata, ForecastChangeOthercontractDetailVO.class);
            List<Long> othidlist = forecastOthercontractDetailMapper.querySubContractIdByProjectIdOther(String.valueOf(saveOrUpdateVO.getProjectId()));
            List<Long> otholdlist = forecastChangeOthercontractDetailMapper.queryByIdOtherId(oldid);


            for(ForecastChangeOthercontractDetailVO othdetailsVo:resultListoth) {
                int c = 1;
                for(ForecastChangeOthercontractDetailVO oldoth:oldothdatavo){
                    if(oldoth.getContractId().equals(othdetailsVo.getContractId())){
//                        ForecastChangeOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastChangeOthercontractDetailEntity.class);
//                        detailslist.setCostChangeForecastId(oldoth.getId());
//                        detailslist.setId(oldoth.getId());
//                        forecastChangeOthercontractDetailMapper.updateById(detailslist);

                        ForecastChangeOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastChangeOthercontractDetailEntity.class);
                        ForecastChangeOthercontractDetailEntity oldothlist = BeanMapper.map(oldoth, ForecastChangeOthercontractDetailEntity.class);

                        LambdaUpdateWrapper<ForecastChangeOthercontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getContractAmount, detailslist.getContractAmount());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getContractCode, detailslist.getContractCode());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getContractName, detailslist.getContractName());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getTaxRate, detailslist.getTaxRate());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getSubOrg, detailslist.getSubOrg());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getSubOrgId, detailslist.getSubOrgId());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getAmountSettled, detailslist.getAmountSettled());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getAmountSettledNotax, detailslist.getAmountSettledNotax());
                        updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getAmountSettledTax, detailslist.getAmountSettledTax());
                        updateWrapperot.eq(ForecastChangeOthercontractDetailEntity::getContractId,oldothlist.getContractId());

                        forecastOthercontractDetailService.update(updateWrapperot);

//                        othsaveOrUpldates.add(detailslist);
                        c++;
                    }
                }
                if(c == 1){
                    ForecastChangeOthercontractDetailEntity detailslist = BeanMapper.map(othdetailsVo, ForecastChangeOthercontractDetailEntity.class);
                    detailslist.setCostChangeForecastId(entity.getId());
                    othsaveOrUpldates.add(detailslist);
                }
            }
            for(Long otholdid :otholdlist){
                int othc = 1;
                for(Long othnewid :othidlist){
                    if(otholdid.equals(othnewid)){
                        othc++;
                    }
                }
                if(othc == 1){
                    //删除该条数据
                    LambdaUpdateWrapper<ForecastChangeOthercontractDetailEntity> updateWrapperot = new LambdaUpdateWrapper<>();
                    updateWrapperot.set(ForecastChangeOthercontractDetailEntity::getDr, '1');
                    updateWrapperot.eq(ForecastChangeOthercontractDetailEntity::getContractId,otholdid);

                    forecastOthercontractDetailService.update(updateWrapperot);
                }
            }
        }


        if(saveOrUpldates.size() > 0) {
            iForecastContractDetailChangeService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if(othersaveOrUpldates.size() >0){
            iForecastOtherDetailChangeService.saveOrUpdateBatch(othersaveOrUpldates,othersaveOrUpldates.size(),false);
        }
        if(deleteIds.size() > 0) {
            iForecastContractDetailChangeService.removeByIds(deleteIds, false);
        }
        if(otherdeleteIds.size() > 0) {
            iForecastOtherDetailChangeService.removeByIds(otherdeleteIds, false);
        }
//        if(operateType == "add") {
            if(materialsaveOrUpldates.size()>0){
                forecastMaterialcontractDetailService.saveOrUpdateBatch(materialsaveOrUpldates,materialsaveOrUpldates.size(),false);
            }
            if(machinesaveOrUpldates.size()>0){
                forecastMachinecontractDetailService.saveOrUpdateBatch(machinesaveOrUpldates,machinesaveOrUpldates.size(),false);
            }
            if(othsaveOrUpldates.size()>0){
                forecastOthercontractDetailService.saveOrUpdateBatch(othsaveOrUpldates,othsaveOrUpldates.size(),false);
            }
//        }

        String changetype = this.baseMapper.querysourcetype(sourceForecastId);

        if(changetype.equals("1")){
            //回写主表
            LambdaUpdateWrapper<CostClosingForecastEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(CostClosingForecastEntity::getChangeStatus, '2');//变更中
            updateWrapper.set(CostClosingForecastEntity::getChangeStatusName, "已变更");//变更中
            updateWrapper.eq(CostClosingForecastEntity::getId,sourceForecastId);

            costClosingForecastService.update(updateWrapper);
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public CostClosingForecastChangeVO queryDetail(Long id) {
        CostClosingForecastChangeEntity entity = this.baseMapper.selectById(id);
        if(entity != null) {
            CostClosingForecastChangeVO contractVo = BeanMapper.map(entity, CostClosingForecastChangeVO.class);
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));

            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("cost_change_forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));

            List<ForecastContractDetailChangeEntity> purchaseDetailss = iForecastContractDetailChangeService.queryList(queryParam2, false);
            List<ForecastOtherDetailChangeEntity> forecastOtherDetailEntities = iForecastOtherDetailChangeService.queryList(queryParam2,false);
//            List<ForecastMaterialcontractDetailEntity> forecastOtherDetailChangeEntities = iForecastMaterialcontractDetailService.queryList(queryParam2,false);

            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                List<ForecastContractDetailChangeVO> resultMapList = BeanMapper.mapList(purchaseDetailss, ForecastContractDetailChangeVO.class);
                contractVo.setForecastContractDetailChangeList(resultMapList);
            }
            if(forecastOtherDetailEntities != null && forecastOtherDetailEntities.size() > 0) {
                List<ForecastOtherDetailChangeVO> resultMapList2 = BeanMapper.mapList(forecastOtherDetailEntities, ForecastOtherDetailChangeVO.class);
                contractVo.setForecastOtherDetailChangeList(resultMapList2);
            }
//            if(forecastOtherDetailChangeEntities != null && forecastOtherDetailChangeEntities.size() > 0) {
//                List<ForecastMaterialcontractDetailVO> resultMapList3 = BeanMapper.mapList(forecastOtherDetailChangeEntities, ForecastMaterialcontractDetailVO.class);
//            }


            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteDatas(List<CostClosingForecastChangeVO> vos) {
        for(CostClosingForecastChangeVO vo : vos){
            Long id = vo.getId();//获取主表id
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("forecast_id", new Parameter(QueryParam.EQ, id));

            QueryParam queryParam2 = new QueryParam();
            queryParam2.getParams().put("cost_change_forecast_id", new Parameter(QueryParam.EQ, id));
            List<ForecastContractDetailChangeEntity> forecastContractDetails = iForecastContractDetailChangeService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastContractDetailChangeEntity> ceupdate = new LambdaUpdateWrapper<>();
            ceupdate.set(ForecastContractDetailChangeEntity::getDr,'1');

            List<ForecastOtherDetailChangeEntity> forecastOtherDetailEntities = iForecastOtherDetailChangeService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastOtherDetailChangeEntity> oeupdate = new LambdaUpdateWrapper<>();
            oeupdate.set(ForecastOtherDetailChangeEntity::getDr,'1');

            List<ForecastChangeMaterialcontractDetailEntity> forecastMaterialcontractDetailEntities = forecastMaterialcontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastChangeMaterialcontractDetailEntity> meupdate = new LambdaUpdateWrapper<>();
            meupdate.set(ForecastChangeMaterialcontractDetailEntity::getDr,'1');

            List<ForecastChangeMachinecontractDetailEntity> forecastMachinecontractDetailEntities = forecastMachinecontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastChangeMachinecontractDetailEntity> maupdate = new LambdaUpdateWrapper<>();
            maupdate.set(ForecastChangeMachinecontractDetailEntity::getDr,'1');

            List<ForecastChangeOthercontractDetailEntity> forecastOthercontractDetailEntities = forecastOthercontractDetailService.queryList(queryParam2);
            LambdaUpdateWrapper<ForecastChangeOthercontractDetailEntity> ocupdate = new LambdaUpdateWrapper<>();
            ocupdate.set(ForecastChangeOthercontractDetailEntity::getDr,'1');

            LambdaUpdateWrapper<CostClosingForecastChangeEntity> zhu = new LambdaUpdateWrapper<>();
            zhu.set(CostClosingForecastChangeEntity::getDr,'1');
            zhu.eq(CostClosingForecastChangeEntity::getId,id);
            iCostClosingForecastChangeService.update(zhu);

            if(!forecastContractDetails.isEmpty()){
                ceupdate.eq(ForecastContractDetailChangeEntity::getCostChangeForecastId,id);
                iForecastContractDetailChangeService.update(ceupdate);
            }
            if(!forecastOtherDetailEntities.isEmpty()){
                oeupdate.eq(ForecastOtherDetailChangeEntity::getCostChangeForecastId,id);
                iForecastOtherDetailChangeService.update(oeupdate);
            }
            if(!forecastMaterialcontractDetailEntities.isEmpty()){
                meupdate.eq(ForecastChangeMaterialcontractDetailEntity::getCostChangeForecastId,id);
                forecastMaterialcontractDetailService.update(meupdate);
            }
            if(!forecastMachinecontractDetailEntities.isEmpty()){
                maupdate.eq(ForecastChangeMachinecontractDetailEntity::getCostChangeForecastId,id);
                forecastMachinecontractDetailService.update(maupdate);
            }
            if(!forecastOthercontractDetailEntities.isEmpty()){
                ocupdate.eq(ForecastChangeOthercontractDetailEntity::getCostChangeForecastId,id);
                forecastOthercontractDetailService.update(ocupdate);
            }
        }
    }

    @Override
    public CostClosingForecastChangeVO queryCostClosingForecast(Long id) {
        CostClosingForecastChangeEntity entity = this.baseMapper.selectByForecastId(id);
        if(entity != null) {
            CostClosingForecastChangeVO contractVo = BeanMapper.map(entity, CostClosingForecastChangeVO.class);
            contractVo.setChangeSub(new BigDecimal("0"));
            contractVo.setChangeSubNotax(new BigDecimal("0"));
            contractVo.setChangeSubTax(new BigDecimal("0"));
            contractVo.setChangeOther(new BigDecimal("0"));
            contractVo.setChangeOtherNotax(new BigDecimal("0"));
            contractVo.setChangeOtherTax(new BigDecimal("0"));

//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));

//            QueryParam queryParam2 = new QueryParam();
//            queryParam2.getParams().put("cost_closing_forecast_id", new Parameter(QueryParam.EQ, contractVo.getId()));

            List<ForecastContractDetailChangeEntity> purchaseDetailss = forecastContractDetailChangeMapper.queryByForecastId(id);
//            List<ForecastOtherDetailChangeEntity> forecastOtherDetailEntities = forecastOtherDetailChangeMapper.queryByForecastId(id);
//            List<ForecastMaterialcontractDetailEntity> forecastOtherDetailChangeEntities = iForecastMaterialcontractDetailService.queryList(queryParam2,false);

            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                List<ForecastContractDetailChangeVO> resultMapList = BeanMapper.mapList(purchaseDetailss, ForecastContractDetailChangeVO.class);
//                contractVo.setForecastContractDetailChangeList(resultMapList);
            }
//            if(forecastOtherDetailEntities != null && forecastOtherDetailEntities.size() > 0) {
//                List<ForecastOtherDetailChangeVO> resultMapList2 = BeanMapper.mapList(forecastOtherDetailEntities, ForecastOtherDetailChangeVO.class);
//                contractVo.setForecastOtherDetailChangeList(resultMapList2);
//            }
//            if(forecastOtherDetailChangeEntities != null && forecastOtherDetailChangeEntities.size() > 0) {
//                List<ForecastMaterialcontractDetailVO> resultMapList3 = BeanMapper.mapList(forecastOtherDetailChangeEntities, ForecastMaterialcontractDetailVO.class);
//            }


            return contractVo;
        }
        return null;
    }
}
