/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CostFinCostSummaryReportingEntity;
import com.ejianc.business.cost.mapper.CostFinCostSummaryReportingMapper;
import com.ejianc.business.cost.service.ICostFinCostSummaryReportingService;
import com.ejianc.business.cost.vo.CostFinCostSummaryReportingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costFinCostSummaryReporting"})
public class CostFinCostSummaryReportingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICostFinCostSummaryReportingService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CostFinCostSummaryReportingMapper baseMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostFinCostSummaryReportingVO> saveOrUpdate(@RequestBody CostFinCostSummaryReportingVO saveOrUpdateVO) {
        CommonResponse<CostFinCostSummaryReportingVO> response = this.service.insertOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/checkmakedata"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value="projectId") Long projectId) {
        Integer count = this.baseMapper.countClosing(projectId);
        if (count == 0) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u5bf9\u5e94\u7684\u8fc7\u5ba1\u7684\u6700\u7ec8\u6210\u672c\u5173\u95e8\u901a\u77e5\u5355\uff0c\u8bf7\u5148\u5236\u5355\u5e76\u8fc7\u5ba1\uff01");
        }
        Integer countchange = this.baseMapper.countClosingChange(projectId);
        if (count == 0) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u5bf9\u5e94\u7684\u8fc7\u5ba1\u7684\u6700\u7ec8\u6210\u672c\u5173\u95e8\u901a\u77e5\u5355\uff0c\u8bf7\u5148\u5236\u5355\u5e76\u8fc7\u5ba1\uff01");
        }
        String message = "\u6821\u9a8c\u6210\u529f\uff0c\u5141\u8bb8\u5f55\u5165\uff01";
        return CommonResponse.success((String)message);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostFinCostSummaryReportingVO> queryDetail(Long id) {
        CostFinCostSummaryReportingEntity entity = (CostFinCostSummaryReportingEntity)((Object)this.baseMapper.selectById(id));
        CostFinCostSummaryReportingVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostFinCostSummaryReportingVO> vos) {
        this.service.deleteDatas(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CostFinCostSummaryReportingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostFinCostSummaryReportingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage list = this.service.queryPage(param, false);
        List volist = new ArrayList();
        if (null != list.getRecords() && CollectionUtils.isNotEmpty((Collection)list.getRecords())) {
            volist = BeanMapper.mapList((Iterable)list.getRecords(), CostFinCostSummaryReportingVO.class);
            volist.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", volist);
        ExcelExport.getInstance().export("CostFinCostSummaryReporting-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCostFinCostSummaryReportingData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CostFinCostSummaryReportingVO>> refCostFinCostSummaryReportingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostFinCostSummaryReportingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAccumulateProfitMargin"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> queryAccumulateProfitMargin(@RequestParam(value="projectId") Long projectId) {
        Map<String, Object> map = this.service.queryAccumulateProfitMargin(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/checkContractAndSettlement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkContractAndSettlement(@RequestParam(value="projectId") Long projectId) {
        String message = this.service.checkContractAndSettlement(projectId);
        return CommonResponse.success((String)message);
    }

    @RequestMapping(value={"/addProjectCheck"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addProjectCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="id") Long id) {
        String message = this.service.addProjectCheck(projectId, id);
        return CommonResponse.success((String)message);
    }

    @RequestMapping(value={"/querySubContractAmount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostFinCostSummaryReportingVO> querySubContractAmount(@RequestParam(value="projectId") Long projectId) {
        CostFinCostSummaryReportingEntity subcontractList = this.service.querySubContractByProjectId(projectId);
        CostFinCostSummaryReportingEntity matcontractList = this.service.querySubContractByProjectIdMaterial(projectId);
        CostFinCostSummaryReportingEntity maccontractList = this.service.querySubContractByProjectIdMachine(projectId);
        CostFinCostSummaryReportingEntity othcontractList = this.service.querySubContractByProjectIdOther(projectId);
        BigDecimal subam = BigDecimal.ZERO;
        BigDecimal subamnt = BigDecimal.ZERO;
        BigDecimal subamt = BigDecimal.ZERO;
        BigDecimal matam = BigDecimal.ZERO;
        BigDecimal matamnt = BigDecimal.ZERO;
        BigDecimal matamt = BigDecimal.ZERO;
        BigDecimal macam = BigDecimal.ZERO;
        BigDecimal macamnt = BigDecimal.ZERO;
        BigDecimal macamt = BigDecimal.ZERO;
        BigDecimal otham = BigDecimal.ZERO;
        BigDecimal othamnt = BigDecimal.ZERO;
        BigDecimal othamt = BigDecimal.ZERO;
        if (subcontractList != null) {
            subam = subcontractList.getSubconsum();
            subamnt = subcontractList.getSubconsumnotax();
            subamt = subcontractList.getSubconsumtax();
        }
        if (matcontractList != null) {
            matam = matcontractList.getSubconsum();
            matamnt = matcontractList.getSubconsumnotax();
            matamt = matcontractList.getSubconsumtax();
        }
        if (maccontractList != null) {
            macam = maccontractList.getSubconsum();
            macamnt = maccontractList.getSubconsumnotax();
            macamt = maccontractList.getSubconsumtax();
        }
        if (othcontractList != null) {
            otham = othcontractList.getSubconsum();
            othamnt = othcontractList.getSubconsumnotax();
            othamt = othcontractList.getSubconsumtax();
        }
        CostFinCostSummaryReportingVO vo = new CostFinCostSummaryReportingVO();
        vo.setProjectId(projectId);
        BigDecimal subconsum = subam.add(matam.add(macam.add(otham)));
        vo.setSubconsum(subconsum);
        BigDecimal subconsumnotax = subamnt.add(matamnt.add(macamnt.add(othamnt)));
        vo.setSubconsumnotax(subconsumnotax);
        BigDecimal subconsumtax = subamt.add(matamt.add(macamt.add(othamt)));
        vo.setSubconsumtax(subconsumtax);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

