/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cost.service.IReportService;
import com.ejianc.business.cost.utils.MathUtil;
import com.ejianc.business.cost.utils.TreeUtil;
import com.ejianc.business.cost.vo.CostClosingForecastVO;
import com.ejianc.business.cost.vo.report.AccountingCostVO;
import com.ejianc.business.cost.vo.report.OrgSubjectReportVO;
import com.ejianc.business.cost.vo.report.ProductionVersusCostAccountingVO;
import com.ejianc.business.cost.vo.report.ProductionVersusCostCompanyVO;
import com.ejianc.business.cost.vo.report.ProjectProductionCostTwoVO;
import com.ejianc.business.cost.vo.report.SubjectCostVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report"})
public class ReportController {
    @Autowired
    private IReportService reportService;

    @RequestMapping(value={"/subjectCostList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> subjectCostList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.subjectCostList(param));
    }

    @PostMapping(value={"subjectCostExport"})
    public void subjectCostExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = this.reportService.subjectCostList(param);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageList.get((Object)"records") && CollectionUtils.isNotEmpty((Collection)((List)pageList.get((Object)"records")))) {
            list = BeanMapper.mapList((Iterable)((List)pageList.get((Object)"records")), SubjectCostVO.class);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("subject-cost-report-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getProductionVersusCostCompanyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getProductionVersusCostCompanyList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.getProductionVersusCostCompanyList(param));
    }

    @PostMapping(value={"productionVersusCostCompanyExport"})
    public void productionVersusCostCompanyExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = this.reportService.getProductionVersusCostCompanyList(param);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageList.get((Object)"records") && CollectionUtils.isNotEmpty((Collection)((List)pageList.get((Object)"records")))) {
            list = BeanMapper.mapList((Iterable)((List)pageList.get((Object)"records")), ProductionVersusCostCompanyVO.class);
            for (ProductionVersusCostCompanyVO vo : list) {
                vo.setMonthProfitMargin(MathUtil.safeDiv(vo.getMonthProfitMargin(), new BigDecimal("100")));
                vo.setYearProfitMargin(MathUtil.safeDiv(vo.getYearProfitMargin(), new BigDecimal("100")));
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("productionVersusCostCompany-report-export.xlsx", beans, response);
    }

    @PostMapping(value={"/queryProjectProductionCostTwo"})
    @ResponseBody
    public CommonResponse<Object> queryProjectProductionCostTwo(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.queryProjectProductionCostTwo(param));
    }

    @PostMapping(value={"/queryProjectProductionCostTwoExport"})
    @ResponseBody
    public void queryProjectProductionCostTwoExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = this.reportService.queryProjectProductionCostTwo(param);
        List list = (List)pageList.get((Object)"records");
        for (ProjectProductionCostTwoVO vo : list) {
            vo.setMonthProfitMargin(MathUtil.safeDiv(vo.getMonthProfitMargin(), new BigDecimal("100")));
            vo.setYearProfitMargin(MathUtil.safeDiv(vo.getYearProfitMargin(), new BigDecimal("100")));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("projectProductionCostTwo-export.xlsx", beans, response);
    }

    @PostMapping(value={"/queryProjectCostThree"})
    @ResponseBody
    public CommonResponse<Object> queryProjectCostThree(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.queryProjectCostThree(param));
    }

    @PostMapping(value={"projectCostThreeExport"})
    public void projectCostThreeExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = this.reportService.queryProjectCostThree(param);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get((Object)"records"));
        ExcelExport.getInstance().export("projectCostThree-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getProductionVersusCostAccountingTreeList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getProductionVersusCostAccountingTreeList(@RequestParam(value="projectId") Long projectId, @RequestParam(value="happenDate") String happenDate) {
        List<Map<String, Object>> list = this.reportService.getProductionVersusCostAccountingTreeList(projectId, happenDate);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"productionVersusCostAccountingTreeExport"})
    public void productionVersusCostAccountingTreeExport(@RequestBody ProductionVersusCostAccountingVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() > 0L && StringUtils.isNotBlank((CharSequence)vo.getCountMonth())) {
            list = this.reportService.getProductionVersusCostAccountingTreeList(vo.getProjectId(), vo.getCountMonth());
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("productionVersusCostAccountingTree-report-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/accountingCostList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> accountingCostList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.accountingCostList(param));
    }

    @PostMapping(value={"accountingCostExport"})
    public void accountingCostExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = this.reportService.accountingCostList(param);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageList.get((Object)"records") && CollectionUtils.isNotEmpty((Collection)((List)pageList.get((Object)"records")))) {
            list = BeanMapper.mapList((Iterable)((List)pageList.get((Object)"records")), AccountingCostVO.class);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("accounting-cost-report-export.xlsx", beans, response);
    }

    @GetMapping(value={"/querySubjectCostList"})
    @ResponseBody
    public CommonResponse<List<OrgSubjectReportVO>> querySubjectCostList(@RequestParam(value="yearFlag") Integer yearFlag) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.reportService.querySubjectCostList(yearFlag));
    }

    @RequestMapping(value={"/projectCompletionSum"})
    @ResponseBody
    public CommonResponse<JSONObject> projectCompletionSum(@RequestParam(value="projectId") Long projectId) {
        List<Map<String, Object>> list = this.reportService.projectCompletionSum(projectId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectCompletionSumExport"})
    public void projectCompletionSumExport(@RequestBody CostClosingForecastVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() != null) {
            Long projectId = vo.getProjectId();
            list = this.reportService.projectCompletionSum(projectId);
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("project-completion-sum-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/projectCompletionSumRealtime"})
    @ResponseBody
    public CommonResponse<JSONObject> projectCompletionSumRealtime(@RequestParam(value="projectId") Long projectId) {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = this.reportService.projectCompletionSumRealtime(projectId);
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectCompletionSumRealtimeExport"})
    public void projectCompletionSumRealtimeExport(@RequestBody CostClosingForecastVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() != null) {
            Long projectId = vo.getProjectId();
            list = this.reportService.projectCompletionSumRealtime(projectId);
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("project-completion-sum-realtime-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/revenueExpenditureSummary"})
    @ResponseBody
    public CommonResponse<JSONObject> RevenueExpenditureSummary() {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = this.reportService.revenueExpenditureSummary();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"revenueExpenditureSummaryExport"})
    public void revenueExpenditureSummaryExport(HttpServletResponse response) {
        List<Map<String, Object>> list = this.reportService.revenueExpenditureSummary();
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("revenue-expenditure-summary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/revenueExpenditureSummaryRealTime"})
    @ResponseBody
    public CommonResponse<JSONObject> ExpenditureSummaryRealTime() {
        JSONObject realtimejsonObject = new JSONObject();
        List<Map<String, Object>> reallist = this.reportService.ExpenditureSummaryRealTime();
        realtimejsonObject.put("records", reallist);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)realtimejsonObject);
    }

    @PostMapping(value={"revenueExpenditureSummaryRealTimeExport"})
    public void revenueExpenditureSummaryRealTimeExport(HttpServletResponse response) {
        List<Map<String, Object>> list = this.reportService.ExpenditureSummaryRealTime();
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("revenue-expenditure-summary-real-time-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/lastRevenueExpenditureSummary"})
    @ResponseBody
    public CommonResponse<JSONObject> LastRevenueExpenditureSummary() {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = this.reportService.lastRevenueExpenditureSummary();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"lastRevenueExpenditureSummaryExport"})
    public void LastRevenueExpenditureSummaryExport(HttpServletResponse response) {
        List<Map<String, Object>> list = this.reportService.lastRevenueExpenditureSummary();
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("last-revenue-expenditure-summary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/projectFinCompletionSum"})
    @ResponseBody
    public CommonResponse<JSONObject> projectFinCompletionSum(@RequestParam(value="projectId") Long projectId) {
        List<Map<String, Object>> list = this.reportService.projectFinCompletionSum(projectId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectFinCompletionSumExport"})
    public void projectFinCompletionSumExport(@RequestBody CostClosingForecastVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() != null) {
            Long projectId = vo.getProjectId();
            list = this.reportService.projectFinCompletionSum(projectId);
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("project-fin-completion-sum-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/projectFinExhaustedSum"})
    @ResponseBody
    public CommonResponse<JSONObject> projectFinExhaustedSum(@RequestParam(value="projectId") Long projectId) {
        List<Map<String, Object>> list = this.reportService.projectFinExhaustedSum(projectId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectFinExhaustedSumExport"})
    public void projectFinExhaustedSumExport(@RequestBody CostClosingForecastVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() != null) {
            Long projectId = vo.getProjectId();
            list = this.reportService.projectFinExhaustedSum(projectId);
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("project-fin-exhausted-sum-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/projectFinClosingSumRealTime"})
    @ResponseBody
    public CommonResponse<JSONObject> projectFinClosingSumRealTime(@RequestParam(value="projectId") Long projectId) {
        List<Map<String, Object>> list = this.reportService.projectFinClosingSumRealTime(projectId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectFinClosingSumRealTimeExport"})
    public void projectFinClosingSumRealTimeExport(@RequestBody CostClosingForecastVO vo, HttpServletResponse response) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (vo != null && vo.getProjectId() != null) {
            Long projectId = vo.getProjectId();
            list = this.reportService.projectFinClosingSumRealTime(projectId);
        }
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("project-fin-closing-sum-real-time-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/projectFinAllClosingSumRealTime"})
    @ResponseBody
    public CommonResponse<JSONObject> projectFinAllClosingSumRealTime() {
        List<Map<String, Object>> list = this.reportService.projectFinAllClosingSumRealTime();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @PostMapping(value={"projectFinAllClosingSumRealTimeExport"})
    public void projectFinAllClosingSumRealTimeExport(HttpServletResponse response) {
        List<Map<String, Object>> list = this.reportService.projectFinAllClosingSumRealTime();
        HashMap<String, List<Map<String, Object>>> beans = new HashMap<String, List<Map<String, Object>>>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("project-fin-all-closing-sum-real-time-export.xlsx", beans, response);
    }
}

