/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.bean.AccountingProjectEntity;
import com.ejianc.business.cost.mapper.AccountingProjectMapper;
import com.ejianc.business.cost.service.IAccountingOrgService;
import com.ejianc.business.cost.service.IAccountingProjectService;
import com.ejianc.business.cost.vo.AccountingOrgVO;
import com.ejianc.business.cost.vo.AccountingProjectImportVO;
import com.ejianc.business.cost.vo.AccountingProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountingProjectService")
public class AccountingProjectServiceImpl
extends BaseServiceImpl<AccountingProjectMapper, AccountingProjectEntity>
implements IAccountingProjectService {
    @Autowired
    private IAccountingOrgService accountingOrgService;

    @Override
    public CommonResponse<AccountingProjectVO> saveOrUpdate(AccountingProjectVO saveorUpdateVO) {
        AccountingProjectEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (AccountingProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, AccountingProjectEntity.class));
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        entity = (AccountingProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, AccountingProjectEntity.class));
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            AccountingProjectEntity uniqueBean = (AccountingProjectEntity)((Object)((AccountingProjectMapper)this.baseMapper).selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public Boolean delRefCheck(List<Long> ids) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(AccountingProjectEntity::getOrgAccountingId, ids);
        List list = super.list((Wrapper)lambda);
        return list != null && list.size() > 0;
    }

    @Override
    public void importOrgSubject(AccountingProjectImportVO importVo) {
        List detailList = importVo.getDetailList();
        List ids = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<String> innerCodeList = detailList.stream().map(AccountingOrgVO::getInnerCode).collect(Collectors.toList());
        ArrayList innerCodes = new ArrayList();
        innerCodeList.forEach(x -> {
            if (StringUtils.isNotEmpty((CharSequence)x)) {
                innerCodes.addAll(Arrays.asList(x.split(",")).stream().map(y -> Long.valueOf(y)).filter(y -> !ids.contains(y)).collect(Collectors.toList()));
            }
        });
        if (CollectionUtils.isNotEmpty(innerCodes)) {
            List innerList = (List)this.accountingOrgService.listByIds(innerCodes);
            ids.addAll(innerCodes);
            detailList.addAll(BeanMapper.mapList((Iterable)innerList, AccountingOrgVO.class));
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(AccountingProjectEntity::getProjectId, (Object)importVo.getProjectId());
        lambda.in(AccountingProjectEntity::getOrgAccountingId, ids);
        List list = super.list((Wrapper)lambda);
        ArrayList<Long> oldIds = new ArrayList<Long>();
        HashMap<Long, Long> parentMap = new HashMap<Long, Long>();
        for (AccountingProjectEntity spe : list) {
            parentMap.put(spe.getOrgAccountingId(), spe.getId());
            oldIds.add(spe.getOrgAccountingId());
        }
        ArrayList<AccountingProjectEntity> saveList = new ArrayList<AccountingProjectEntity>();
        for (AccountingOrgVO vo : detailList) {
            if (oldIds.contains(vo.getId())) continue;
            AccountingProjectEntity entity = new AccountingProjectEntity();
            long id = IdWorker.getId();
            entity.setId(id);
            entity.setAccountingCode(vo.getAccountingCode());
            entity.setAccountingName(vo.getAccountingName());
            entity.setMemo(vo.getMemo());
            entity.setOrgId(importVo.getOrgId());
            entity.setOrgName(importVo.getOrgName());
            entity.setProjectId(importVo.getProjectId());
            entity.setProjectName(importVo.getProjectName());
            entity.setOrgAccountingId(vo.getId());
            entity.setParentId(vo.getParentId());
            entity.setInnerCode(vo.getInnerCode());
            parentMap.put(vo.getId(), id);
            saveList.add(entity);
        }
        if (saveList.size() > 0) {
            for (AccountingProjectEntity spe : saveList) {
                spe.setParentId((Long)parentMap.get(spe.getParentId()));
                String innerCode = spe.getInnerCode();
                String[] split = innerCode.split(",");
                String newInnerCode = "";
                for (int i = 0; i < split.length; ++i) {
                    Long aLong = (Long)parentMap.get(Long.parseLong(split[i]));
                    newInnerCode = i == 0 ? aLong.toString() : newInnerCode + "," + aLong.toString();
                }
                spe.setInnerCode(newInnerCode);
            }
            super.saveBatch(saveList);
        }
    }
}

