/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.ShareDetailEntity;
import com.ejianc.business.cost.bean.ShareEntity;
import com.ejianc.business.cost.service.IShareDetailService;
import com.ejianc.business.cost.service.IShareService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="share")
public class ShareBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IShareService shareService;
    @Autowired
    private IShareDetailService shareDetailService;
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ShareDetailEntity::getShareId, (Object)billId);
        lambda.ne(ShareDetailEntity::getSubjectFlag, (Object)1);
        List list = this.shareDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5b58\u5728\u672a\u5173\u8054\u79d1\u76ee\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ShareDetailEntity::getShareId, (Object)billId);
            lambda.ne(ShareDetailEntity::getSubjectFlag, (Object)1);
            List list = this.shareDetailService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return CommonResponse.error((String)"\u8be5\u5355\u636e\u5b58\u5728\u672a\u5173\u8054\u79d1\u76ee\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4!");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ShareEntity shareEntity = (ShareEntity)((Object)this.shareService.selectById(billId));
        List<ShareDetailEntity> list = shareEntity.getShareDetail();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> this.commenQueryFieldsService.updateProportionFlag(e.getBillType(), String.valueOf(e.getSourceId()), "1"));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ShareEntity shareEntity = (ShareEntity)((Object)this.shareService.selectById(billId));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ShareEntity::getProjectId, (Object)shareEntity.getProjectId());
        lambda.gt(ShareEntity::getPeriod, (Object)shareEntity.getPeriod());
        List list = this.shareService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5b58\u5728\u6bd4\u5f53\u524d\u64a4\u56de\u671f\u95f4\u66f4\u665a\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ShareEntity shareEntity = (ShareEntity)((Object)this.shareService.selectById(billId));
        List<ShareDetailEntity> list = shareEntity.getShareDetail();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> this.commenQueryFieldsService.updateProportionFlag(e.getBillType(), String.valueOf(e.getSourceId()), "0"));
        }
        return CommonResponse.success();
    }
}

