/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.TurnMaterialEntity;
import com.ejianc.business.cost.mapper.TurnMaterialMapper;
import com.ejianc.business.cost.service.ITurnMaterialService;
import com.ejianc.business.cost.vo.TurnMaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="turnMaterialService")
public class TurnMaterialServiceImpl
extends BaseServiceImpl<TurnMaterialMapper, TurnMaterialEntity>
implements ITurnMaterialService {
    private static final String BILL_CODE = "TURN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public TurnMaterialVO saveOrUpdate(TurnMaterialVO saveOrUpdateVO) {
        TurnMaterialEntity entity = (TurnMaterialEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TurnMaterialEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public TurnMaterialVO queryDetail(Long id) {
        TurnMaterialEntity entity = (TurnMaterialEntity)((Object)super.selectById((Serializable)id));
        TurnMaterialVO vo = (TurnMaterialVO)BeanMapper.map((Object)((Object)entity), TurnMaterialVO.class);
        return vo;
    }
}

