package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.CostFinContractDetailEntity;
import com.ejianc.business.cost.bean.CostFinOtherDetailEntity;
import com.ejianc.business.cost.bean.FinMaterialContractEntity;
import com.ejianc.business.cost.bean.FinMachineContractEntity;
import com.ejianc.business.cost.bean.FinOtherContractEntity;
/**
 * 最终成本关门上报汇总
 *
 * @author generator
 *
 */
 @TableName("ejc_cost_fin_cost_summary_reporting")
public class CostFinCostSummaryReportingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="amount_fees_tax")
    private BigDecimal amountFeesTax; // 预估总成本（含税）
    @TableField(value="amount_fees")
    private BigDecimal amountFees; // 预估总成本（不含税）
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 预估总成本税金
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人姓名
    @TableField(value="employee_org")
    private Long employeeOrg; // 经办部门
    @TableField(value="subconsum")
    private BigDecimal subconsum; // 分包合同成本汇总含税
    @TableField(value="subconsumnotax")
    private BigDecimal subconsumnotax; // 分包合同成本汇总不含税
    @TableField(value="subconsumtax")
    private BigDecimal subconsumtax; // 分包合同成本汇总税金
    @TableField(value="othersum")
    private BigDecimal othersum; // 其他成本汇总含税
    @TableField(value="othersumnotax")
    private BigDecimal othersumnotax; // 其他成本汇总不含税
    @TableField(value="othersumtax")
    private BigDecimal othersumtax; // 其他成本汇总税金
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_id")
    private Long orgId; // 组织

    @TableField(value="accumulate_profit_margin")
    private BigDecimal accumulateProfitMargin; // 开累项目利润率

    @TableField(exist=false)
    @SubEntity(serviceName="costFinContractDetailService",pidName = "costFinId")
    private List<CostFinContractDetailEntity> costFinContractDetailList = new ArrayList<>(); // 最终合同成本汇总
    @TableField(exist=false)
    @SubEntity(serviceName="costFinOtherDetailService",pidName = "finCostId")
    private List<CostFinOtherDetailEntity> costFinOtherDetailList = new ArrayList<>(); // 最终其他成本汇总
    @TableField(exist=false)
    @SubEntity(serviceName="finMaterialContractService",pidName = "finCostId")
    private List<FinMaterialContractEntity> finMaterialContractList = new ArrayList<>(); // 最终物资合同成本汇总
    @TableField(exist=false)
    @SubEntity(serviceName="finMachineContractService",pidName = "finCostId")
    private List<FinMachineContractEntity> finMachineContractList = new ArrayList<>(); // 最终设备合同成本汇总
    @TableField(exist=false)
    @SubEntity(serviceName="finOtherContractService",pidName = "finCostId")
    private List<FinOtherContractEntity> finOtherContractList = new ArrayList<>(); // 最终其他合同成本汇总


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getAmountFeesTax() {
        return amountFeesTax;
    }

    public void setAmountFeesTax(BigDecimal amountFeesTax) {
        this.amountFeesTax = amountFeesTax;
    }
    public BigDecimal getAmountFees() {
        return amountFees;
    }

    public void setAmountFees(BigDecimal amountFees) {
        this.amountFees = amountFees;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeOrg() {
        return employeeOrg;
    }

    public void setEmployeeOrg(Long employeeOrg) {
        this.employeeOrg = employeeOrg;
    }
    public BigDecimal getSubconsum() {
        return subconsum;
    }

    public void setSubconsum(BigDecimal subconsum) {
        this.subconsum = subconsum;
    }
    public BigDecimal getSubconsumnotax() {
        return subconsumnotax;
    }

    public void setSubconsumnotax(BigDecimal subconsumnotax) {
        this.subconsumnotax = subconsumnotax;
    }
    public BigDecimal getSubconsumtax() {
        return subconsumtax;
    }

    public void setSubconsumtax(BigDecimal subconsumtax) {
        this.subconsumtax = subconsumtax;
    }
    public BigDecimal getOthersum() {
        return othersum;
    }

    public void setOthersum(BigDecimal othersum) {
        this.othersum = othersum;
    }
    public BigDecimal getOthersumnotax() {
        return othersumnotax;
    }

    public void setOthersumnotax(BigDecimal othersumnotax) {
        this.othersumnotax = othersumnotax;
    }
    public BigDecimal getOthersumtax() {
        return othersumtax;
    }

    public void setOthersumtax(BigDecimal othersumtax) {
        this.othersumtax = othersumtax;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }


    public List<CostFinContractDetailEntity> getCostFinContractDetailList() {
        return costFinContractDetailList;
    }

    public void setCostFinContractDetailList(List<CostFinContractDetailEntity> costFinContractDetailList) {
        this.costFinContractDetailList = costFinContractDetailList;
    }

    public List<CostFinOtherDetailEntity> getCostFinOtherDetailList() {
        return costFinOtherDetailList;
    }

    public void setCostFinOtherDetailList(List<CostFinOtherDetailEntity> costFinOtherDetailList) {
        this.costFinOtherDetailList = costFinOtherDetailList;
    }

    public List<FinMaterialContractEntity> getFinMaterialContractList() {
        return finMaterialContractList;
    }

    public void setFinMaterialContractList(List<FinMaterialContractEntity> finMaterialContractList) {
        this.finMaterialContractList = finMaterialContractList;
    }

    public List<FinMachineContractEntity> getFinMachineContractList() {
        return finMachineContractList;
    }

    public void setFinMachineContractList(List<FinMachineContractEntity> finMachineContractList) {
        this.finMachineContractList = finMachineContractList;
    }

    public List<FinOtherContractEntity> getFinOtherContractList() {
        return finOtherContractList;
    }

    public void setFinOtherContractList(List<FinOtherContractEntity> finOtherContractList) {
        this.finOtherContractList = finOtherContractList;
    }

    public BigDecimal getAccumulateProfitMargin() {
        return accumulateProfitMargin;
    }

    public void setAccumulateProfitMargin(BigDecimal accumulateProfitMargin) {
        this.accumulateProfitMargin = accumulateProfitMargin;
    }
}
