package com.ejianc.business.cost.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 目标责任成本
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_target_liability")
public class TargetLiabilityCostEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="tax_rate")
    private java.math.BigDecimal taxRate; // 税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="calculate_date")
    private java.util.Date calculateDate; // 测算日期
    @TableField(value="calculate_mny")
    private java.math.BigDecimal calculateMny; // 测算金额(无税)
    @TableField(value="calculate_tax_mny")
    private java.math.BigDecimal calculateTaxMny; // 测算金额
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="target_tax_rate")
    private java.math.BigDecimal targetTaxRate; // 项目目标利润率(含税)
    @TableField(value="target_rate")
    private java.math.BigDecimal targetRate; // 项目目标利润率(无税)
    @TableField(value="build_mny")
    private java.math.BigDecimal buildMny; // 不含税施工图预算
    @TableField(value="tender_mny")
    private java.math.BigDecimal tenderMny; // 不含中标价

    @TableField(exist = false)
    @SubEntity(serviceName="targetLiabilityCostDetailService",pidName = "targetLiabilityId")
    private List<TargetLiabilityCostDetailEntity> detailList = new ArrayList();
    

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 测算日期
     */
    public java.util.Date getCalculateDate() {
        return calculateDate;
    }

    /**
     * 测算日期
     */
    public void setCalculateDate(java.util.Date calculateDate) {
        this.calculateDate = calculateDate;
    }
    /**
     * 测算金额(无税)
     */
    public java.math.BigDecimal getCalculateMny() {
        return calculateMny;
    }

    /**
     * 测算金额(无税)
     */
    public void setCalculateMny(java.math.BigDecimal calculateMny) {
        this.calculateMny = calculateMny;
    }
    /**
     * 测算金额
     */
    public java.math.BigDecimal getCalculateTaxMny() {
        return calculateTaxMny;
    }

    /**
     * 测算金额
     */
    public void setCalculateTaxMny(java.math.BigDecimal calculateTaxMny) {
        this.calculateTaxMny = calculateTaxMny;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getTargetTaxRate() {
        return targetTaxRate;
    }

    public void setTargetTaxRate(BigDecimal targetTaxRate) {
        this.targetTaxRate = targetTaxRate;
    }

    public BigDecimal getTargetRate() {
        return targetRate;
    }

    public void setTargetRate(BigDecimal targetRate) {
        this.targetRate = targetRate;
    }

    public BigDecimal getBuildMny() {
        return buildMny;
    }

    public void setBuildMny(BigDecimal buildMny) {
        this.buildMny = buildMny;
    }

    public BigDecimal getTenderMny() {
        return tenderMny;
    }

    public void setTenderMny(BigDecimal tenderMny) {
        this.tenderMny = tenderMny;
    }

    public List<TargetLiabilityCostDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TargetLiabilityCostDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
