package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.service.IAccountingProjectService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.AccountingOrgEntity;
import com.ejianc.business.cost.service.IAccountingOrgService;
import com.ejianc.business.cost.vo.AccountingOrgVO;

/**
 * 集团核算对象实体
 *
 * @author generator
 */
@Controller
@RequestMapping("accountingOrg")
public class AccountingOrgController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IAccountingOrgService service;
    @Autowired
    private IAccountingProjectService accountingProjectService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AccountingOrgVO> saveOrUpdate(@RequestBody AccountingOrgVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AccountingOrgVO> queryDetail(Long id) {
        AccountingOrgEntity entity = service.selectById(id);
        AccountingOrgVO vo = BeanMapper.map(entity, AccountingOrgVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody AccountingOrgVO vo) {
        List<Long> ids = vo.getIds();
        Boolean flag = accountingProjectService.delRefCheck(ids);
        if (flag) {
            throw new BusinessException("存在被引用的核算对象，请处理后操作");
        }
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("accountingName");
        fuzzyFields.add("accountingCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("accountingCode", "asc");
        List<AccountingOrgEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AccountingOrgEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AccountingOrg-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refAccountingOrgData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refAccountingOrgData(@RequestParam(value = "searchText", required = false) String searchText,
                                          @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("accountingName");
        param.getFuzzyFields().add("accountingCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getOrderMap().put("accountingCode", "asc");
        List<AccountingOrgEntity> list = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(AccountingOrgEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getAccountingName());
            map.put("code", entity.getAccountingCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}
